/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.esri.core.geometry;

import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.AttributeStreamOfInt32;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.IndexMultiList;
import java.util.Arrays;

final class IndexHashTable {
    int m_random;
    AttributeStreamOfInt32 m_hashBuckets;
    int[] m_bit_filter;
    IndexMultiList m_lists;
    HashFunction m_hash;

    public IndexHashTable(int size, HashFunction hashFunction) {
        this.m_hashBuckets = new AttributeStreamOfInt32(size, IndexHashTable.nullNode());
        this.m_lists = new IndexMultiList();
        this.m_hash = hashFunction;
        this.m_bit_filter = new int[size * 10 + 31 >> 5];
    }

    public void reserveElements(int capacity) {
        this.m_lists.reserveLists(Math.min(this.m_hashBuckets.size(), capacity));
        this.m_lists.reserveNodes(capacity);
    }

    public int addElement(int element, int hash) {
        int bit_bucket = hash % (this.m_bit_filter.length << 5);
        int n = bit_bucket >> 5;
        this.m_bit_filter[n] = this.m_bit_filter[n] | 1 << (bit_bucket & 0x1F);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == -1) {
            list = this.m_lists.createList();
            this.m_hashBuckets.set(bucket, list);
        }
        int node = this.m_lists.addElement(list, element);
        return node;
    }

    public int addElement(int element) {
        int hash = this.m_hash.getHash(element);
        int bit_bucket = hash % (this.m_bit_filter.length << 5);
        int n = bit_bucket >> 5;
        this.m_bit_filter[n] = this.m_bit_filter[n] | 1 << (bit_bucket & 0x1F);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == -1) {
            list = this.m_lists.createList();
            this.m_hashBuckets.set(bucket, list);
        }
        int node = this.m_lists.addElement(list, element);
        return node;
    }

    public void deleteElement(int element, int hash) {
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == -1) {
            throw new IllegalArgumentException();
        }
        int ptr = this.m_lists.getFirst(list);
        int prev = -1;
        while (ptr != -1) {
            int e = this.m_lists.getElement(ptr);
            int nextptr = this.m_lists.getNext(ptr);
            if (e == element) {
                this.m_lists.deleteElement(list, prev, ptr);
                if (this.m_lists.getFirst(list) == -1) {
                    this.m_lists.deleteList(list);
                    this.m_hashBuckets.set(bucket, -1);
                }
            } else {
                prev = ptr;
            }
            ptr = nextptr;
        }
    }

    public void deleteElement(int element) {
        int hash = this.m_hash.getHash(element);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == -1) {
            throw new IllegalArgumentException();
        }
        int ptr = this.m_lists.getFirst(list);
        int prev = -1;
        while (ptr != -1) {
            int e = this.m_lists.getElement(ptr);
            int nextptr = this.m_lists.getNext(ptr);
            if (e == element) {
                this.m_lists.deleteElement(list, prev, ptr);
                if (this.m_lists.getFirst(list) == -1) {
                    this.m_lists.deleteList(list);
                    this.m_hashBuckets.set(bucket, -1);
                }
            } else {
                prev = ptr;
            }
            ptr = nextptr;
        }
    }

    public int getFirstInBucket(int hashValue) {
        int bit_bucket = hashValue % (this.m_bit_filter.length << 5);
        if ((this.m_bit_filter[bit_bucket >> 5] & 1 << (bit_bucket & 0x1F)) == 0) {
            return -1;
        }
        int bucket = hashValue % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == -1) {
            return -1;
        }
        return this.m_lists.getFirst(list);
    }

    public int getNextInBucket(int elementHandle) {
        return this.m_lists.getNext(elementHandle);
    }

    public int findNode(int element) {
        int hash = this.m_hash.getHash(element);
        int ptr = this.getFirstInBucket(hash);
        while (ptr != -1) {
            int e = this.m_lists.getElement(ptr);
            if (this.m_hash.equal(e, element)) {
                return ptr;
            }
            ptr = this.m_lists.getNext(ptr);
        }
        return -1;
    }

    public int findNode(Object elementDescriptor) {
        int hash = this.m_hash.getHash(elementDescriptor);
        int ptr = this.getFirstInBucket(hash);
        while (ptr != -1) {
            int e = this.m_lists.getElement(ptr);
            if (this.m_hash.equal(elementDescriptor, e)) {
                return ptr;
            }
            ptr = this.m_lists.getNext(ptr);
        }
        return -1;
    }

    public int getNextNode(int elementHandle) {
        int element = this.m_lists.getElement(elementHandle);
        int ptr = this.m_lists.getNext(elementHandle);
        while (ptr != -1) {
            int e = this.m_lists.getElement(ptr);
            if (this.m_hash.equal(e, element)) {
                return ptr;
            }
            ptr = this.m_lists.getNext(ptr);
        }
        return -1;
    }

    public void deleteNode(int node) {
        int element = this.getElement(node);
        int hash = this.m_hash.getHash(element);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == -1) {
            throw new IllegalArgumentException();
        }
        int ptr = this.m_lists.getFirst(list);
        int prev = -1;
        while (ptr != -1) {
            if (ptr == node) {
                this.m_lists.deleteElement(list, prev, ptr);
                if (this.m_lists.getFirst(list) == -1) {
                    this.m_lists.deleteList(list);
                    this.m_hashBuckets.set(bucket, -1);
                }
                return;
            }
            prev = ptr;
            ptr = this.m_lists.getNext(ptr);
        }
        throw new IllegalArgumentException();
    }

    public int getElement(int elementHandle) {
        return this.m_lists.getElement(elementHandle);
    }

    public int getAnyElement() {
        return this.m_lists.getFirstElement(this.m_lists.getFirstList());
    }

    public int getAnyNode() {
        return this.m_lists.getFirst(this.m_lists.getFirstList());
    }

    public static int nullNode() {
        return -1;
    }

    public void clear() {
        Arrays.fill(this.m_bit_filter, 0);
        this.m_hashBuckets = new AttributeStreamOfInt32(this.m_hashBuckets.size(), IndexHashTable.nullNode());
        this.m_lists.clear();
    }

    public int size() {
        return this.m_lists.getNodeCount();
    }

    public static abstract class HashFunction {
        public abstract int getHash(int var1);

        public abstract boolean equal(int var1, int var2);

        public abstract int getHash(Object var1);

        public abstract boolean equal(Object var1, int var2);
    }
}

