/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;

public class JoinSqlCallTransformer
extends SqlCallTransformer {
    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().kind == SqlKind.JOIN && ((SqlJoin)sqlCall).getJoinType() == JoinType.COMMA;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        SqlJoin joinSqlCall = (SqlJoin)sqlCall;
        if (JoinSqlCallTransformer.isUnnestOperatorPresentInRightSqlNode(joinSqlCall.getRight())) {
            if (JoinSqlCallTransformer.isUnnestSqlCallCorrelated(joinSqlCall.getRight())) {
                return JoinSqlCallTransformer.createCrossJoinSqlCall(joinSqlCall);
            }
            return joinSqlCall;
        }
        return JoinSqlCallTransformer.createCrossJoinSqlCall(joinSqlCall);
    }

    private static boolean isUnnestOperatorPresentInRightSqlNode(SqlNode rightSqlNode) {
        return rightSqlNode instanceof SqlCall && rightSqlNode.getKind() == SqlKind.AS && ((SqlCall)rightSqlNode).operand(0) instanceof SqlCall && ((SqlNode)((SqlCall)rightSqlNode).operand(0)).getKind() == SqlKind.UNNEST;
    }

    private static boolean isUnnestSqlCallCorrelated(SqlNode sqlNode) {
        Object aliasOperand = ((SqlCall)sqlNode).operand(0);
        Object unnestOperand = ((SqlCall)aliasOperand).operand(0);
        return ((SqlNode)unnestOperand).getKind() == SqlKind.IDENTIFIER || unnestOperand instanceof SqlCall && ((SqlCall)unnestOperand).getOperator().getName().equalsIgnoreCase("transform") || unnestOperand instanceof SqlCall && ((SqlCall)unnestOperand).getOperator().getName().equalsIgnoreCase("if");
    }

    private static SqlCall createCrossJoinSqlCall(SqlJoin sqlCall) {
        return new SqlJoin(SqlImplementor.POS, sqlCall.getLeft(), SqlLiteral.createBoolean(false, SqlParserPos.ZERO), JoinType.CROSS.symbol(SqlImplementor.POS), sqlCall.getRight(), JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
    }
}

