/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.filesystem.alluxio.AlluxioCacheStats;
import io.trino.filesystem.alluxio.AlluxioCoordinatorFileSystemCache;
import io.trino.filesystem.alluxio.AlluxioFileSystemCache;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.ConsistentHashingHostAddressProvider;
import io.trino.filesystem.cache.ConsistentHashingHostAddressProviderConfig;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import java.util.Properties;
import org.weakref.jmx.guice.ExportBinder;

public class AlluxioFileSystemCacheModule
extends AbstractConfigurationAwareModule {
    private final boolean isCoordinator;

    public AlluxioFileSystemCacheModule(boolean isCoordinator) {
        this.isCoordinator = isCoordinator;
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(AlluxioFileSystemCacheConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ConsistentHashingHostAddressProviderConfig.class);
        binder.bind(AlluxioCacheStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(AlluxioCacheStats.class).as(generator -> generator.generatedNameOf(AlluxioCacheStats.class));
        if (this.isCoordinator) {
            binder.bind(TrinoFileSystemCache.class).to(AlluxioCoordinatorFileSystemCache.class).in(Scopes.SINGLETON);
            OptionalBinder.newOptionalBinder((Binder)binder, CachingHostAddressProvider.class).setBinding().to(ConsistentHashingHostAddressProvider.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(TrinoFileSystemCache.class).to(AlluxioFileSystemCache.class).in(Scopes.SINGLETON);
        }
        Properties metricProps = new Properties();
        metricProps.put("sink.jmx.class", "alluxio.metrics.sink.JmxSink");
        metricProps.put("sink.jmx.domain", "org.alluxio");
        MetricsSystem.startSinksFromConfig((MetricsConfig)new MetricsConfig(metricProps));
    }
}

