/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import io.airlift.slice.Slice;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.util.Timestamps;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.UnboundPredicate;

public final class ExpressionConverter {
    private ExpressionConverter() {
    }

    public static Expression toIcebergExpression(TupleDomain<IcebergColumnHandle> tupleDomain) {
        if (tupleDomain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (tupleDomain.getDomains().isEmpty()) {
            return Expressions.alwaysFalse();
        }
        Map domainMap = (Map)tupleDomain.getDomains().get();
        ArrayList<Expression> conjuncts = new ArrayList<Expression>();
        for (Map.Entry entry : domainMap.entrySet()) {
            IcebergColumnHandle columnHandle = (IcebergColumnHandle)entry.getKey();
            Preconditions.checkArgument((!IcebergMetadataColumn.isMetadataColumnId(columnHandle.getId()) ? 1 : 0) != 0, (String)"Constraint on an unexpected column %s", (Object)columnHandle);
            Domain domain = (Domain)entry.getValue();
            conjuncts.add(ExpressionConverter.toIcebergExpression(columnHandle.getQualifiedName(), columnHandle.getType(), domain));
        }
        return ExpressionConverter.and(conjuncts);
    }

    private static Expression toIcebergExpression(String columnName, Type type, Domain domain) {
        if (domain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? Expressions.isNull((String)columnName) : Expressions.alwaysFalse();
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? Expressions.alwaysTrue() : Expressions.not((Expression)Expressions.isNull((String)columnName));
        }
        if (type instanceof ArrayType || type instanceof MapType || type instanceof RowType) {
            throw new UnsupportedOperationException("Unsupported type for expression: " + type);
        }
        if (type.isOrderable()) {
            List orderedRanges = domain.getValues().getRanges().getOrderedRanges();
            ArrayList<Object> icebergValues = new ArrayList<Object>();
            ArrayList<Expression> rangeExpressions = new ArrayList<Expression>();
            for (Range range : orderedRanges) {
                if (range.isSingleValue()) {
                    icebergValues.add(ExpressionConverter.getIcebergLiteralValue(type, range.getLowBoundedValue()));
                    continue;
                }
                rangeExpressions.add(ExpressionConverter.toIcebergExpression(columnName, range));
            }
            Expression ranges = ExpressionConverter.or(rangeExpressions);
            False values = icebergValues.isEmpty() ? Expressions.alwaysFalse() : Expressions.in((String)columnName, icebergValues);
            False nullExpression = domain.isNullAllowed() ? Expressions.isNull((String)columnName) : Expressions.alwaysFalse();
            return ExpressionConverter.or((Expression)nullExpression, ExpressionConverter.or((Expression)values, ranges));
        }
        throw new VerifyException(String.format("Unsupported type %s with domain values %s", type, domain));
    }

    private static Expression toIcebergExpression(String columnName, Range range) {
        Type type = range.getType();
        if (range.isSingleValue()) {
            Object icebergValue = ExpressionConverter.getIcebergLiteralValue(type, range.getSingleValue());
            return Expressions.equal((String)columnName, (Object)icebergValue);
        }
        ArrayList<Expression> conjuncts = new ArrayList<Expression>(2);
        if (!range.isLowUnbounded()) {
            Object icebergLow = ExpressionConverter.getIcebergLiteralValue(type, range.getLowBoundedValue());
            UnboundPredicate lowBound = range.isLowInclusive() ? Expressions.greaterThanOrEqual((String)columnName, (Object)icebergLow) : Expressions.greaterThan((String)columnName, (Object)icebergLow);
            conjuncts.add((Expression)lowBound);
        }
        if (!range.isHighUnbounded()) {
            Object icebergHigh = ExpressionConverter.getIcebergLiteralValue(type, range.getHighBoundedValue());
            UnboundPredicate highBound = range.isHighInclusive() ? Expressions.lessThanOrEqual((String)columnName, (Object)icebergHigh) : Expressions.lessThan((String)columnName, (Object)icebergHigh);
            conjuncts.add((Expression)highBound);
        }
        return ExpressionConverter.and(conjuncts);
    }

    private static Object getIcebergLiteralValue(Type type, Object trinoNativeValue) {
        Objects.requireNonNull(trinoNativeValue, "trinoNativeValue is null");
        if (type instanceof BooleanType) {
            return (boolean)((Boolean)trinoNativeValue);
        }
        if (type instanceof IntegerType) {
            return Math.toIntExact((Long)trinoNativeValue);
        }
        if (type instanceof BigintType) {
            return (long)((Long)trinoNativeValue);
        }
        if (type instanceof RealType) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)trinoNativeValue)));
        }
        if (type instanceof DoubleType) {
            return (double)((Double)trinoNativeValue);
        }
        if (type instanceof DateType) {
            return Math.toIntExact((Long)trinoNativeValue);
        }
        if (type.equals(TimeType.TIME_MICROS)) {
            return (Long)trinoNativeValue / 1000000L;
        }
        if (type.equals(TimestampType.TIMESTAMP_MICROS)) {
            return (long)((Long)trinoNativeValue);
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
            return Timestamps.timestampTzToMicros((LongTimestampWithTimeZone)trinoNativeValue);
        }
        if (type instanceof VarcharType) {
            return ((Slice)trinoNativeValue).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return ByteBuffer.wrap(((Slice)trinoNativeValue).getBytes());
        }
        if (type instanceof UuidType) {
            return UuidType.trinoUuidToJavaUuid((Slice)((Slice)trinoNativeValue));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (Decimals.isShortDecimal((Type)decimalType)) {
                return BigDecimal.valueOf((Long)trinoNativeValue).movePointLeft(decimalType.getScale());
            }
            return new BigDecimal(((Int128)trinoNativeValue).toBigInteger(), decimalType.getScale());
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static Expression and(List<Expression> expressions) {
        if (expressions.isEmpty()) {
            return Expressions.alwaysTrue();
        }
        return ExpressionConverter.combine(expressions, Expressions::and);
    }

    private static Expression or(Expression left, Expression right) {
        return Expressions.or((Expression)left, (Expression)right);
    }

    private static Expression or(List<Expression> expressions) {
        if (expressions.isEmpty()) {
            return Expressions.alwaysFalse();
        }
        return ExpressionConverter.combine(expressions, Expressions::or);
    }

    private static Expression combine(List<Expression> expressions, BiFunction<Expression, Expression, Expression> combiner) {
        ArrayDeque<Object> queue = new ArrayDeque<Expression>(expressions);
        while (queue.size() > 1) {
            ArrayDeque<Expression> buffer = new ArrayDeque<Expression>();
            while (queue.size() >= 2) {
                buffer.add(combiner.apply((Expression)queue.remove(), (Expression)queue.remove()));
            }
            if (!queue.isEmpty()) {
                buffer.add((Expression)queue.remove());
            }
            queue = buffer;
        }
        return (Expression)queue.remove();
    }
}

