/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.plugin.iceberg.IcebergAvroDataConversion;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergAvroPageSource
implements ConnectorPageSource {
    private final CloseableIterator<Record> recordIterator;
    private final List<String> columnNames;
    private final List<io.trino.spi.type.Type> columnTypes;
    private final Map<String, Type> icebergTypes;
    private final List<Boolean> rowIndexLocations;
    private final PageBuilder pageBuilder;
    private final AggregatedMemoryContext memoryUsage;
    private int rowId;
    private long readBytes;
    private long readTimeNanos;

    public IcebergAvroPageSource(FileIO fileIo, String path, long start, long length, Schema fileSchema, Optional<NameMapping> nameMapping, List<String> columnNames, List<io.trino.spi.type.Type> columnTypes, List<Boolean> rowIndexLocations, AggregatedMemoryContext memoryUsage) {
        Objects.requireNonNull(fileIo, "fileIo is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(fileSchema, "fileSchema is null");
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.rowIndexLocations = ImmutableList.copyOf((Collection)Objects.requireNonNull(rowIndexLocations, "rowIndexLocations is null"));
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        Preconditions.checkArgument((columnNames.size() == rowIndexLocations.size() && columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"names, rowIndexLocations, and types must correspond one-to-one-to-one");
        Schema readSchema = fileSchema.select(columnNames);
        Avro.ReadBuilder builder = Avro.read((InputFile)fileIo.newInputFile(path)).project(readSchema).createReaderFunc(DataReader::create).split(start, length);
        nameMapping.ifPresent(arg_0 -> ((Avro.ReadBuilder)builder).withNameMapping(arg_0));
        AvroIterable avroReader = builder.build();
        this.icebergTypes = (Map)readSchema.columns().stream().collect(ImmutableMap.toImmutableMap(Types.NestedField::name, Types.NestedField::type));
        this.pageBuilder = new PageBuilder(columnTypes);
        this.recordIterator = avroReader.iterator();
    }

    private boolean isIndexColumn(int column) {
        return this.rowIndexLocations.get(column);
    }

    public long getCompletedBytes() {
        return this.readBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return !this.recordIterator.hasNext();
    }

    public Page getNextPage() {
        if (!this.recordIterator.hasNext()) {
            return null;
        }
        long start = System.nanoTime();
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.recordIterator.hasNext()) {
            this.pageBuilder.declarePosition();
            Record record = (Record)this.recordIterator.next();
            for (int channel = 0; channel < this.columnTypes.size(); ++channel) {
                if (this.isIndexColumn(channel)) {
                    this.pageBuilder.getBlockBuilder(channel).writeLong((long)this.rowId);
                    continue;
                }
                String name = this.columnNames.get(channel);
                IcebergAvroDataConversion.serializeToTrinoBlock(this.columnTypes.get(channel), this.icebergTypes.get(name), this.pageBuilder.getBlockBuilder(channel), record.getField(name));
            }
            ++this.rowId;
        }
        Page page = this.pageBuilder.build();
        this.readBytes += page.getSizeInBytes();
        this.readTimeNanos += System.nanoTime() - start;
        return page;
    }

    public long getMemoryUsage() {
        return this.memoryUsage.getBytes();
    }

    public void close() {
        try {
            this.recordIterator.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

