/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveApplyProjectionUtil;
import io.trino.plugin.hive.HiveWrittenPartitions;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.ConstraintExtractor;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.FilesTable;
import io.trino.plugin.iceberg.HistoryTable;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergInputInfo;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.IcebergWritableTableHandle;
import io.trino.plugin.iceberg.ManifestsTable;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.PartitionTable;
import io.trino.plugin.iceberg.PropertiesTable;
import io.trino.plugin.iceberg.SnapshotsTable;
import io.trino.plugin.iceberg.TableStatisticsMaker;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.procedure.IcebergExpireSnapshotsHandle;
import io.trino.plugin.iceberg.procedure.IcebergOptimizeHandle;
import io.trino.plugin.iceberg.procedure.IcebergRemoveOrphanFilesHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableExecuteHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableProcedureId;
import io.trino.plugin.iceberg.util.DataFileWithDeleteFiles;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.UuidType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(IcebergMetadata.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("(.*)/[^/]+");
    private static final int OPTIMIZE_MAX_SUPPORTED_TABLE_VERSION = 2;
    private static final int CLEANING_UP_PROCEDURES_MAX_SUPPORTED_TABLE_VERSION = 2;
    private static final String RETENTION_THRESHOLD = "retention_threshold";
    public static final Set<String> UPDATABLE_TABLE_PROPERTIES = ImmutableSet.of((Object)"format", (Object)"format_version", (Object)"partitioning");
    public static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    public static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    private final TypeManager typeManager;
    private final TypeOperators typeOperators;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final TrinoCatalog catalog;
    private final HdfsEnvironment hdfsEnvironment;
    private final Map<String, Long> snapshotIds = new ConcurrentHashMap<String, Long>();
    private Transaction transaction;

    public IcebergMetadata(TypeManager typeManager, TypeOperators typeOperators, JsonCodec<CommitTaskData> commitTaskCodec, TrinoCatalog catalog, HdfsEnvironment hdfsEnvironment) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.catalog.listNamespaces(session);
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        return this.catalog.loadNamespaceMetadata(session, schemaName.getSchemaName());
    }

    public Optional<TrinoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        return this.catalog.getNamespacePrincipal(session, schemaName.getSchemaName());
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        throw new UnsupportedOperationException("This method is not supported because getTableHandle with versions is implemented instead");
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        Optional<Object> partitionSpec;
        Schema tableSchema;
        Optional<Long> tableSnapshotId;
        BaseTable table;
        if (startVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Read table with start version is not supported");
        }
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        if (name.getTableType() != TableType.DATA) {
            return null;
        }
        try {
            table = (BaseTable)this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), name.getTableName()));
        }
        catch (TableNotFoundException e) {
            return null;
        }
        if (name.getSnapshotId().isPresent() && endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Cannot specify end version both in table name and FOR clause");
        }
        if (endVersion.isPresent() || name.getSnapshotId().isPresent()) {
            long snapshotId = endVersion.map(connectorTableVersion -> IcebergMetadata.getSnapshotIdFromVersion((Table)table, connectorTableVersion)).orElseGet(() -> this.resolveSnapshotId((Table)table, name.getSnapshotId().get(), IcebergSessionProperties.isAllowLegacySnapshotSyntax(session)));
            tableSnapshotId = Optional.of(snapshotId);
            tableSchema = (Schema)table.schemas().get(table.snapshot(snapshotId).schemaId());
            partitionSpec = Optional.empty();
        } else {
            tableSnapshotId = Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId);
            tableSchema = table.schema();
            partitionSpec = Optional.of(table.spec());
        }
        Map tableProperties = table.properties();
        String nameMappingJson = (String)tableProperties.get("schema.name-mapping.default");
        return new IcebergTableHandle(tableName.getSchemaName(), name.getTableName(), name.getTableType(), tableSnapshotId, SchemaParser.toJson((Schema)tableSchema), partitionSpec.map(PartitionSpecParser::toJson), table.operations().current().formatVersion(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (Set<IcebergColumnHandle>)ImmutableSet.of(), Optional.ofNullable(nameMappingJson), table.location(), table.properties(), RetryMode.NO_RETRIES, (List<IcebergColumnHandle>)ImmutableList.of(), false, Optional.empty());
    }

    private static long getSnapshotIdFromVersion(Table table, ConnectorTableVersion version) {
        io.trino.spi.type.Type versionType = version.getVersionType();
        switch (version.getPointerType()) {
            case TEMPORAL: {
                if (!(versionType instanceof TimestampWithTimeZoneType)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for temporal table version: " + versionType.getDisplayName());
                }
                long epochMillis = ((TimestampWithTimeZoneType)versionType).isShort() ? DateTimeEncoding.unpackMillisUtc((long)((Long)version.getVersion())) : ((LongTimestampWithTimeZone)version.getVersion()).getEpochMillis();
                return IcebergUtil.getSnapshotIdAsOfTime(table, epochMillis);
            }
            case TARGET_ID: {
                if (versionType != BigintType.BIGINT) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for table version: " + versionType.getDisplayName());
                }
                long snapshotId = (Long)version.getVersion();
                if (table.snapshot(snapshotId) == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Iceberg snapshot ID does not exists: " + snapshotId);
                }
                return snapshotId;
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Version pointer type is not supported: " + version.getPointerType());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.getRawSystemTable(session, tableName).map(systemTable -> new ClassLoaderSafeSystemTable(systemTable, this.getClass().getClassLoader()));
    }

    private Optional<SystemTable> getRawSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        if (name.getTableType() == TableType.DATA) {
            return Optional.empty();
        }
        try {
            table = this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), name.getTableName()));
        }
        catch (TableNotFoundException e) {
            return Optional.empty();
        }
        catch (UnknownTableTypeException e) {
            return Optional.empty();
        }
        SchemaTableName systemTableName = new SchemaTableName(tableName.getSchemaName(), name.getTableNameWithType());
        switch (name.getTableType()) {
            case DATA: {
                break;
            }
            case HISTORY: {
                if (name.getSnapshotId().isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for history table: " + systemTableName);
                }
                return Optional.of(new HistoryTable(systemTableName, table));
            }
            case SNAPSHOTS: {
                if (name.getSnapshotId().isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for snapshots table: " + systemTableName);
                }
                return Optional.of(new SnapshotsTable(systemTableName, this.typeManager, table));
            }
            case PARTITIONS: {
                return Optional.of(new PartitionTable(systemTableName, this.typeManager, table, this.getSnapshotId(table, name.getSnapshotId(), IcebergSessionProperties.isAllowLegacySnapshotSyntax(session))));
            }
            case MANIFESTS: {
                return Optional.of(new ManifestsTable(systemTableName, table, this.getSnapshotId(table, name.getSnapshotId(), IcebergSessionProperties.isAllowLegacySnapshotSyntax(session))));
            }
            case FILES: {
                return Optional.of(new FilesTable(systemTableName, this.typeManager, table, this.getSnapshotId(table, name.getSnapshotId(), IcebergSessionProperties.isAllowLegacySnapshotSyntax(session))));
            }
            case PROPERTIES: {
                return Optional.of(new PropertiesTable(systemTableName, table));
            }
        }
        return Optional.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        if (table.getSnapshotId().isEmpty()) {
            return new ConnectorTableProperties(TupleDomain.none(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
        }
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Set<Integer> partitionSourceIds = IcebergMetadata.identityPartitionColumnsInAllSpecs(icebergTable);
        TupleDomain<IcebergColumnHandle> enforcedPredicate = table.getEnforcedPredicate();
        DiscretePredicates discretePredicates = null;
        if (!partitionSourceIds.isEmpty()) {
            Map columns = (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().filter(column -> partitionSourceIds.contains(column.getId())).collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
            com.google.common.base.Supplier lazyFiles = Suppliers.memoize(() -> {
                ImmutableList immutableList;
                block8: {
                    TableScan tableScan = (TableScan)((TableScan)icebergTable.newScan().useSnapshot(table.getSnapshotId().get().longValue()).filter(ExpressionConverter.toIcebergExpression(enforcedPredicate))).includeColumnStats();
                    CloseableIterable iterator = tableScan.planFiles();
                    try {
                        immutableList = ImmutableList.copyOf((Iterable)iterator);
                        if (iterator == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (iterator != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    iterator.close();
                }
                return immutableList;
            });
            Iterable files = () -> IcebergMetadata.lambda$getTableProperties$5((Supplier)lazyFiles);
            Iterable discreteTupleDomain = Iterables.transform(files, fileScan -> {
                Map<Integer, Optional<String>> partitionColumnValueStrings = IcebergUtil.getPartitionKeys(fileScan);
                Map partitionValues = (Map)partitionSourceIds.stream().filter(partitionColumnValueStrings::containsKey).collect(ImmutableMap.toImmutableMap(columns::get, columnId -> {
                    IcebergColumnHandle column = (IcebergColumnHandle)columns.get(columnId);
                    Object prestoValue = IcebergUtil.deserializePartitionValue(column.getType(), ((Optional)partitionColumnValueStrings.get(columnId)).orElse(null), column.getName());
                    return NullableValue.of((io.trino.spi.type.Type)column.getType(), (Object)prestoValue);
                }));
                return TupleDomain.fromFixedValues((Map)partitionValues);
            });
            discretePredicates = new DiscretePredicates((List)columns.values().stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), discreteTupleDomain);
        }
        return new ConnectorTableProperties(enforcedPredicate.transformKeys(ColumnHandle.class::cast), Optional.empty(), Optional.empty(), Optional.ofNullable(discretePredicates), (List)ImmutableList.of());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        IcebergTableHandle tableHandle = (IcebergTableHandle)table;
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        List<ColumnMetadata> columns = this.getColumnMetadatas(SchemaParser.fromJson((String)tableHandle.getTableSchemaJson()));
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columns, IcebergUtil.getIcebergTableProperties(icebergTable), IcebergUtil.getTableComment(icebergTable));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listTables(session, schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (IcebergColumnHandle columnHandle : IcebergUtil.getColumns(icebergTable.schema(), this.typeManager)) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        columnHandles.put((Object)IcebergMetadataColumn.FILE_PATH.getColumnName(), (Object)IcebergColumnHandle.pathColumnHandle());
        columnHandles.put((Object)IcebergMetadataColumn.FILE_MODIFIED_TIME.getColumnName(), (Object)IcebergColumnHandle.fileModifiedTimeColumnHandle());
        return columnHandles.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Object schemaTableNames = prefix.getTable().isEmpty() ? this.catalog.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        return schemaTableNames.stream().flatMap(tableName -> {
            try {
                if (this.redirectTable(session, (SchemaTableName)tableName).isPresent()) {
                    return Stream.of(TableColumnsMetadata.forRedirectedTable((SchemaTableName)tableName));
                }
                Table icebergTable = this.catalog.loadTable(session, (SchemaTableName)tableName);
                List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable.schema());
                return Stream.of(TableColumnsMetadata.forTable((SchemaTableName)tableName, columns));
            }
            catch (TableNotFoundException e) {
                return Stream.empty();
            }
            catch (UnknownTableTypeException e) {
                return Stream.empty();
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to access metadata of table %s during streaming table columns for %s", new Object[]{tableName, prefix});
                return Stream.empty();
            }
        }).iterator();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.catalog.createNamespace(session, schemaName, properties, owner);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.catalog.dropNamespace(session, schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.catalog.renameNamespace(session, source, target);
    }

    public void setSchemaAuthorization(ConnectorSession session, String schemaName, TrinoPrincipal principal) {
        this.catalog.setNamespacePrincipal(session, schemaName, principal);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional<ConnectorTableLayout> layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout, RetryMode.NO_RETRIES), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        this.catalog.updateTableComment(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), comment);
    }

    public void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        this.catalog.updateViewComment(session, viewName, comment);
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Schema schema = IcebergUtil.schemaFromMetadata(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        return this.getWriteLayout(schema, partitionSpec, false);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = IcebergUtil.newCreateTableTransaction(this.catalog, tableMetadata, session);
        String location = this.transaction.table().location();
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        try {
            Path path = new Path(location);
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, path);
            if (fileSystem.exists(path) && fileSystem.listFiles(path, true).hasNext()) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Cannot create a table on a non-empty location: %s, set 'iceberg.unique-table-location=true' in your Iceberg catalog properties to use unique table locations for every table.", location));
            }
            return new IcebergWritableTableHandle(tableMetadata.getTable(), SchemaParser.toJson((Schema)this.transaction.table().schema()), PartitionSpecParser.toJson((PartitionSpec)this.transaction.table().spec()), IcebergUtil.getColumns(this.transaction.table().schema(), this.typeManager), location, IcebergUtil.getFileFormat(this.transaction.table()), this.transaction.table().properties(), retryMode);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed checking new table's location: " + location, (Throwable)e);
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        if (fragments.isEmpty()) {
            this.transaction.newFastAppend().commit();
            this.transaction.commitTransaction();
            this.transaction = null;
            return Optional.empty();
        }
        return this.finishInsert(session, (IcebergWritableTableHandle)tableHandle, fragments, computedStatistics);
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        return this.getWriteLayout(icebergTable.schema(), icebergTable.spec(), false);
    }

    private Optional<ConnectorTableLayout> getWriteLayout(Schema tableSchema, PartitionSpec partitionSpec, boolean forceRepartitioning) {
        if (partitionSpec.isUnpartitioned()) {
            return Optional.empty();
        }
        Map columnById = (Map)IcebergUtil.getColumns(tableSchema, this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
        List partitioningColumns = (List)partitionSpec.fields().stream().sorted(Comparator.comparing(PartitionField::sourceId)).map(field -> Objects.requireNonNull((IcebergColumnHandle)columnById.get(field.sourceId()), () -> "Cannot find source column for partitioning field " + field)).distinct().collect(ImmutableList.toImmutableList());
        List partitioningColumnNames = (List)partitioningColumns.stream().map(IcebergColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (!forceRepartitioning && partitionSpec.fields().stream().allMatch(field -> field.transform().isIdentity())) {
            return Optional.of(new ConnectorTableLayout(partitioningColumnNames));
        }
        IcebergPartitioningHandle partitioningHandle = new IcebergPartitioningHandle(PartitionFields.toPartitionFields(partitionSpec), partitioningColumns);
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitioningColumnNames));
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, icebergTable);
        this.beginTransaction(icebergTable);
        return new IcebergWritableTableHandle(table.getSchemaTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), icebergTable.location(), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties(), retryMode);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        if (commitTasks.isEmpty()) {
            this.transaction = null;
            return Optional.empty();
        }
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(table.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.getPath());
        }
        if (table.getRetryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        appendFiles.commit();
        this.transaction.commitTransaction();
        this.transaction = null;
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    private void cleanExtraOutputFiles(HdfsEnvironment.HdfsContext hdfsContext, String queryId, String location, Set<String> filesToKeep) {
        ArrayDeque<String> filesToDelete = new ArrayDeque<String>();
        try {
            log.debug("Deleting failed attempt files from %s for query %s", new Object[]{location, queryId});
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, new Path(location));
            if (!fileSystem.exists(new Path(location))) {
                return;
            }
            RemoteIterator iterator = fileSystem.listFiles(new Path(location), false);
            while (iterator.hasNext()) {
                Path file = ((LocatedFileStatus)iterator.next()).getPath();
                if (!IcebergMetadata.isFileCreatedByQuery(file.getName(), queryId) || filesToKeep.contains(location + "/" + file.getName())) continue;
                filesToDelete.add(file.getName());
            }
            if (filesToDelete.isEmpty()) {
                return;
            }
            log.info("Found %s files to delete and %s to retain in location %s for query %s", new Object[]{filesToDelete.size(), filesToKeep.size(), location, queryId});
            ImmutableList.Builder deletedFilesBuilder = ImmutableList.builder();
            Iterator filesToDeleteIterator = filesToDelete.iterator();
            while (filesToDeleteIterator.hasNext()) {
                String fileName = (String)filesToDeleteIterator.next();
                log.debug("Deleting failed attempt file %s/%s for query %s", new Object[]{location, fileName, queryId});
                fileSystem.delete(new Path(location, fileName), false);
                deletedFilesBuilder.add((Object)fileName);
                filesToDeleteIterator.remove();
            }
            ImmutableList deletedFiles = deletedFilesBuilder.build();
            if (!deletedFiles.isEmpty()) {
                log.info("Deleted failed attempt files %s from %s for query %s", new Object[]{deletedFiles, location, queryId});
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Could not clean up extraneous output files; remaining files: %s", filesToDelete), (Throwable)e);
        }
    }

    private static boolean isFileCreatedByQuery(String fileName, String queryId) {
        Verify.verify((!queryId.contains("-") ? 1 : 0) != 0, (String)"queryId(%s) should not contain hyphens", (Object)queryId);
        return fileName.startsWith(queryId + "-");
    }

    private static Set<String> getOutputFilesLocations(Set<String> writtenFiles) {
        return (Set)writtenFiles.stream().map(IcebergMetadata::getLocation).collect(ImmutableSet.toImmutableSet());
    }

    private static String getLocation(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        Verify.verify((boolean)matcher.matches(), (String)"path %s does not match pattern", (Object)path);
        return matcher.group(1);
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle connectorTableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        IcebergTableProcedureId procedureId;
        IcebergTableHandle tableHandle = (IcebergTableHandle)connectorTableHandle;
        try {
            procedureId = IcebergTableProcedureId.valueOf(procedureName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
        }
        switch (procedureId) {
            case OPTIMIZE: {
                return this.getTableHandleForOptimize(session, tableHandle, executeProperties, retryMode);
            }
            case EXPIRE_SNAPSHOTS: {
                return this.getTableHandleForExpireSnapshots(session, tableHandle, executeProperties);
            }
            case REMOVE_ORPHAN_FILES: {
                return this.getTableHandleForRemoveOrphanFiles(session, tableHandle, executeProperties);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + procedureId);
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties, RetryMode retryMode) {
        DataSize maxScannedFileSize = (DataSize)executeProperties.get("file_size_threshold");
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.OPTIMIZE, new IcebergOptimizeHandle(tableHandle.getSnapshotId().orElseThrow(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties(), maxScannedFileSize, retryMode != RetryMode.NO_RETRIES), icebergTable.location()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForExpireSnapshots(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        Duration retentionThreshold = (Duration)executeProperties.get(RETENTION_THRESHOLD);
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.EXPIRE_SNAPSHOTS, new IcebergExpireSnapshotsHandle(retentionThreshold), icebergTable.location()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForRemoveOrphanFiles(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        Duration retentionThreshold = (Duration)executeProperties.get(RETENTION_THRESHOLD);
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.REMOVE_ORPHAN_FILES, new IcebergRemoveOrphanFilesHandle(retentionThreshold), icebergTable.location()));
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.getLayoutForOptimize(session, executeHandle);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private Optional<ConnectorTableLayout> getLayoutForOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        Table icebergTable = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        return this.getWriteLayout(icebergTable.schema(), icebergTable.spec(), true);
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        IcebergTableHandle table = (IcebergTableHandle)updatedSourceTableHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.beginOptimize(session, executeHandle, table);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, IcebergTableHandle table) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, icebergTable);
        int tableFormatVersion = ((BaseTable)icebergTable).operations().current().formatVersion();
        if (tableFormatVersion > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s is not supported for Iceberg table format version > %d. Table %s format version is %s.", IcebergTableProcedureId.OPTIMIZE.name(), 2, table.getSchemaTableName(), tableFormatVersion));
        }
        this.beginTransaction(icebergTable);
        return new BeginTableExecuteResult((Object)executeHandle, (Object)table.forOptimize(true, optimizeHandle.getMaxScannedFileSize()));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                this.finishOptimize(session, executeHandle, fragments, splitSourceInfo);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private void finishOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
        Table icebergTable = this.transaction.table();
        ImmutableSet.Builder scannedDataFilesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder scannedDeleteFilesBuilder = ImmutableSet.builder();
        splitSourceInfo.stream().map(DataFileWithDeleteFiles.class::cast).forEach(dataFileWithDeleteFiles -> {
            scannedDataFilesBuilder.add((Object)dataFileWithDeleteFiles.getDataFile());
            scannedDeleteFilesBuilder.addAll(dataFileWithDeleteFiles.getDeleteFiles());
        });
        ImmutableSet scannedDataFiles = scannedDataFilesBuilder.build();
        ImmutableSet fullyAppliedDeleteFiles = scannedDeleteFilesBuilder.build();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        HashSet<DataFile> newFiles = new HashSet<DataFile>();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(optimizeHandle.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            newFiles.add(builder.build());
        }
        if (scannedDataFiles.isEmpty() && fullyAppliedDeleteFiles.isEmpty() && newFiles.isEmpty()) {
            this.transaction = null;
            return;
        }
        if (optimizeHandle.isRetriesEnabled()) {
            this.cleanExtraOutputFiles(session, (Set)newFiles.stream().map(dataFile -> dataFile.path().toString()).collect(ImmutableSet.toImmutableSet()));
        }
        RewriteFiles rewriteFiles = this.transaction.newRewrite();
        rewriteFiles.rewriteFiles((Set)scannedDataFiles, (Set)fullyAppliedDeleteFiles, newFiles, (Set)ImmutableSet.of());
        Snapshot snapshot = Objects.requireNonNull(icebergTable.snapshot(optimizeHandle.getSnapshotId()), "snapshot is null");
        rewriteFiles.validateFromSnapshot(snapshot.snapshotId());
        rewriteFiles.commit();
        this.transaction.commitTransaction();
        this.transaction = null;
    }

    public void executeTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case EXPIRE_SNAPSHOTS: {
                this.executeExpireSnapshots(session, executeHandle);
                return;
            }
            case REMOVE_ORPHAN_FILES: {
                this.executeRemoveOrphanFiles(session, executeHandle);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private void executeExpireSnapshots(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergExpireSnapshotsHandle expireSnapshotsHandle = (IcebergExpireSnapshotsHandle)executeHandle.getProcedureHandle();
        Table table = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        Duration retention = Objects.requireNonNull(expireSnapshotsHandle.getRetentionThreshold(), "retention is null");
        IcebergMetadata.validateTableExecuteParameters(table, executeHandle.getSchemaTableName(), IcebergTableProcedureId.EXPIRE_SNAPSHOTS.name(), retention, IcebergSessionProperties.getExpireSnapshotMinRetention(session), "iceberg.expire_snapshots.min-retention", "expire_snapshots_min_retention");
        long expireTimestampMillis = session.getStart().toEpochMilli() - retention.toMillis();
        table.expireSnapshots().expireOlderThan(expireTimestampMillis).commit();
    }

    private static void validateTableExecuteParameters(Table table, SchemaTableName schemaTableName, String procedureName, Duration retentionThreshold, Duration minRetention, String minRetentionParameterName, String sessionMinRetentionParameterName) {
        int tableFormatVersion = ((BaseTable)table).operations().current().formatVersion();
        if (tableFormatVersion > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s is not supported for Iceberg table format version > %d. Table %s format version is %s.", procedureName, 2, schemaTableName, tableFormatVersion));
        }
        Map properties = table.properties();
        if (properties.containsKey("write.location-provider.impl")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + schemaTableName + " specifies " + (String)properties.get("write.location-provider.impl") + " as a location provider. Writing to Iceberg tables with custom location provider is not supported.");
        }
        Duration retention = Objects.requireNonNull(retentionThreshold, "retention is null");
        Procedures.checkProcedureArgument((retention.compareTo(minRetention) >= 0 ? 1 : 0) != 0, (String)"Retention specified (%s) is shorter than the minimum retention configured in the system (%s). Minimum retention can be changed with %s configuration property or iceberg.%s session property", (Object[])new Object[]{retention, minRetention, minRetentionParameterName, sessionMinRetentionParameterName});
    }

    public void executeRemoveOrphanFiles(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergRemoveOrphanFilesHandle removeOrphanFilesHandle = (IcebergRemoveOrphanFilesHandle)executeHandle.getProcedureHandle();
        Table table = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        Duration retention = Objects.requireNonNull(removeOrphanFilesHandle.getRetentionThreshold(), "retention is null");
        IcebergMetadata.validateTableExecuteParameters(table, executeHandle.getSchemaTableName(), IcebergTableProcedureId.REMOVE_ORPHAN_FILES.name(), retention, IcebergSessionProperties.getRemoveOrphanFilesMinRetention(session), "iceberg.remove_orphan_files.min-retention", "remove_orphan_files_min_retention");
        long expireTimestampMillis = session.getStart().toEpochMilli() - retention.toMillis();
        this.removeOrphanFiles(table, session, executeHandle.getSchemaTableName(), expireTimestampMillis);
        this.removeOrphanMetadataFiles(table, session, executeHandle.getSchemaTableName(), expireTimestampMillis);
    }

    private void removeOrphanFiles(Table table, ConnectorSession session, SchemaTableName schemaTableName, long expireTimestamp) {
        Set validDataFilePaths = (Set)Streams.stream((Iterable)table.snapshots()).map(Snapshot::snapshotId).flatMap(snapshotId -> Streams.stream((Iterable)table.newScan().useSnapshot(snapshotId.longValue()).planFiles())).map(fileScanTask -> URI.create(((DataFile)fileScanTask.file()).path().toString()).getPath()).collect(ImmutableSet.toImmutableSet());
        Set validDeleteFilePaths = Streams.stream((Iterable)table.snapshots()).map(Snapshot::snapshotId).flatMap(snapshotId -> Streams.stream((Iterable)table.newScan().useSnapshot(snapshotId.longValue()).planFiles())).flatMap(fileScanTask -> fileScanTask.deletes().stream().map(deleteFile -> URI.create(deleteFile.path().toString()).getPath())).collect(Collectors.toUnmodifiableSet());
        this.scanAndDeleteInvalidFiles(table, session, schemaTableName, expireTimestamp, (Set<String>)Sets.union((Set)validDataFilePaths, validDeleteFilePaths), "/data");
    }

    private void removeOrphanMetadataFiles(Table table, ConnectorSession session, SchemaTableName schemaTableName, long expireTimestamp) {
        ImmutableSet manifests = (ImmutableSet)Streams.stream((Iterable)table.snapshots()).flatMap(snapshot -> snapshot.allManifests(table.io()).stream()).map(ManifestFile::path).collect(ImmutableSet.toImmutableSet());
        List manifestLists = ReachableFileUtil.manifestListLocations((Table)table);
        List otherMetadataFiles = (List)Streams.concat((Stream[])new Stream[]{ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false).stream(), Stream.of(ReachableFileUtil.versionHintLocation((Table)table))}).collect(ImmutableList.toImmutableList());
        Set validMetadataFiles = (Set)Streams.concat((Stream[])new Stream[]{manifests.stream(), manifestLists.stream(), otherMetadataFiles.stream()}).map(path -> URI.create(path).getPath()).collect(ImmutableSet.toImmutableSet());
        this.scanAndDeleteInvalidFiles(table, session, schemaTableName, expireTimestamp, validMetadataFiles, "/metadata");
    }

    private void scanAndDeleteInvalidFiles(Table table, ConnectorSession session, SchemaTableName schemaTableName, long expireTimestamp, Set<String> validFiles, String subfolder) {
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(table.location()));
            RemoteIterator allFiles = fileSystem.listFiles(new Path(table.location() + subfolder), true);
            while (allFiles.hasNext()) {
                LocatedFileStatus file = (LocatedFileStatus)allFiles.next();
                if (!file.isFile()) continue;
                String normalizedPath = file.getPath().toUri().getPath();
                if (file.getModificationTime() < expireTimestamp && !validFiles.contains(normalizedPath)) {
                    log.debug("Deleting %s file while removing orphan files %s", new Object[]{file.getPath().toString(), schemaTableName.getTableName()});
                    fileSystem.delete(file.getPath(), false);
                    continue;
                }
                log.debug("%s file retained while removing orphan files %s", new Object[]{file.getPath().toString(), schemaTableName.getTableName()});
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed accessing data for table: " + schemaTableName, (Throwable)e);
        }
    }

    public Optional<Object> getInfo(ConnectorTableHandle tableHandle) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        Optional<Boolean> partitioned = icebergTableHandle.getPartitionSpecJson().map(partitionSpecJson -> PartitionSpecParser.fromJson((Schema)SchemaParser.fromJson((String)icebergTableHandle.getTableSchemaJson()), (String)partitionSpecJson).isPartitioned());
        return Optional.of(new IcebergInputInfo(icebergTableHandle.getSnapshotId(), partitioned, IcebergUtil.getFileFormat(icebergTableHandle.getStorageProperties()).name()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.catalog.dropTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        this.catalog.renameTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), newTable);
    }

    public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Optional<Object>> properties) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Sets.SetView unsupportedProperties = Sets.difference(properties.keySet(), UPDATABLE_TABLE_PROPERTIES);
        if (!unsupportedProperties.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The following properties cannot be updated: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)unsupportedProperties));
        }
        this.beginTransaction(icebergTable);
        UpdateProperties updateProperties = this.transaction.updateProperties();
        if (properties.containsKey("format")) {
            IcebergFileFormat fileFormat = (IcebergFileFormat)((Object)properties.get("format").orElseThrow(() -> new IllegalArgumentException("The format property cannot be empty")));
            updateProperties.defaultFormat(fileFormat.toIceberg());
        }
        if (properties.containsKey("format_version")) {
            int formatVersion = (Integer)properties.get("format_version").orElseThrow(() -> new IllegalArgumentException("The format_version property cannot be empty"));
            updateProperties.set("format-version", Integer.toString(formatVersion));
        }
        try {
            updateProperties.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set new property values", (Throwable)e);
        }
        if (properties.containsKey("partitioning")) {
            List partitionColumns = (List)properties.get("partitioning").orElseThrow(() -> new IllegalArgumentException("The partitioning property cannot be empty"));
            IcebergMetadata.updatePartitioning(icebergTable, this.transaction, partitionColumns);
        }
        try {
            this.transaction.commitTransaction();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to commit new table properties", (Throwable)e);
        }
    }

    private static void updatePartitioning(Table icebergTable, Transaction transaction, List<String> partitionColumns) {
        UpdatePartitionSpec updatePartitionSpec = transaction.updateSpec();
        Set existingPartitionFields = (Set)icebergTable.spec().fields().stream().collect(ImmutableSet.toImmutableSet());
        Schema schema = icebergTable.schema();
        if (partitionColumns.isEmpty()) {
            existingPartitionFields.stream().map(partitionField -> IcebergMetadata.toIcebergTerm(schema, partitionField)).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).removeField(arg_0));
        } else {
            ImmutableSet partitionFields = ImmutableSet.copyOf((Collection)PartitionFields.parsePartitionFields(schema, partitionColumns).fields());
            Sets.difference((Set)existingPartitionFields, (Set)partitionFields).stream().map(PartitionField::name).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).removeField(arg_0));
            Sets.difference((Set)partitionFields, (Set)existingPartitionFields).stream().map(partitionField -> IcebergMetadata.toIcebergTerm(schema, partitionField)).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).addField(arg_0));
        }
        try {
            updatePartitionSpec.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set new partitioning value", (Throwable)e);
        }
    }

    private static Term toIcebergTerm(Schema schema, PartitionField partitionField) {
        return Expressions.transform((String)schema.findColumnName(partitionField.sourceId()), (Transform)partitionField.transform());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        icebergTable.updateSchema().addColumn(column.getName(), TypeConverter.toIcebergType(column.getType()), column.getComment()).commit();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
    }

    private List<ColumnMetadata> getColumnMetadatas(Schema schema) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List schemaColumns = (List)schema.columns().stream().map(column -> ColumnMetadata.builder().setName(column.name()).setType(TypeConverter.toTrinoType(column.type(), this.typeManager)).setNullable(column.isOptional()).setComment(Optional.ofNullable(column.doc())).build()).collect(ImmutableList.toImmutableList());
        columns.addAll((Iterable)schemaColumns);
        columns.add((Object)IcebergColumnHandle.pathColumnMetadata());
        columns.add((Object)IcebergColumnHandle.fileModifiedTimeColumnMetadata());
        return columns.build();
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        IcebergMetadata.verifyTableVersionForUpdate(table);
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, icebergTable);
        this.beginTransaction(icebergTable);
        return table.withRetryMode(retryMode);
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        this.finishWrite(session, (IcebergTableHandle)tableHandle, fragments, false);
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return IcebergUtil.getColumnHandle(MetadataColumns.ROW_POSITION, this.typeManager);
    }

    public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        IcebergMetadata.verifyTableVersionForUpdate(table);
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, icebergTable);
        this.beginTransaction(icebergTable);
        return table.withRetryMode(retryMode).withUpdatedColumns((List)updatedColumns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList()));
    }

    public void finishUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        this.finishWrite(session, (IcebergTableHandle)tableHandle, fragments, true);
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        ArrayList<Types.NestedField> unmodifiedColumns = new ArrayList<Types.NestedField>();
        unmodifiedColumns.add(MetadataColumns.ROW_POSITION);
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Set updatedFields = (Set)updatedColumns.stream().map(IcebergColumnHandle.class::cast).map(IcebergColumnHandle::getId).collect(ImmutableSet.toImmutableSet());
        for (Types.NestedField column : SchemaParser.fromJson((String)table.getTableSchemaJson()).columns()) {
            if (updatedFields.contains(column.fieldId())) continue;
            unmodifiedColumns.add(column);
        }
        Types.NestedField icebergRowIdField = Types.NestedField.required((int)Integer.MIN_VALUE, (String)"$row_id", (Type)Types.StructType.of(unmodifiedColumns));
        return IcebergUtil.getColumnHandle(icebergRowIdField, this.typeManager);
    }

    private static void verifyTableVersionForUpdate(IcebergTableHandle table) {
        if (table.getFormatVersion() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg table updates require at least format version 2");
        }
    }

    private static void validateNotModifyingOldSnapshot(IcebergTableHandle table, Table icebergTable) {
        if (table.getSnapshotId().isPresent() && table.getSnapshotId().get().longValue() != icebergTable.currentSnapshot().snapshotId()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Modifying old snapshot is not supported in Iceberg.");
        }
    }

    private void finishWrite(ConnectorSession session, IcebergTableHandle table, Collection<Slice> fragments, boolean runUpdateValidations) {
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        if (commitTasks.isEmpty()) {
            this.transaction = null;
            return;
        }
        Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        Map<String, List<CommitTaskData>> deletesByFilePath = commitTasks.stream().filter(task -> task.getContent() == FileContent.POSITION_DELETES).collect(Collectors.groupingBy(task -> task.getReferencedDataFile().orElseThrow()));
        Map fullyDeletedFiles = (Map)deletesByFilePath.entrySet().stream().filter(entry -> IcebergMetadata.fileIsFullyDeleted((List)entry.getValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!deletesByFilePath.keySet().equals(fullyDeletedFiles.keySet()) || commitTasks.stream().anyMatch(task -> task.getContent() == FileContent.DATA)) {
            IsolationLevel isolationLevel;
            RowDelta rowDelta = this.transaction.newRowDelta();
            table.getSnapshotId().map(arg_0 -> ((Table)icebergTable).snapshot(arg_0)).ifPresent(s -> rowDelta.validateFromSnapshot(s.snapshotId()));
            if (!table.getEnforcedPredicate().isAll()) {
                rowDelta.conflictDetectionFilter(ExpressionConverter.toIcebergExpression(table.getEnforcedPredicate()));
            }
            if ((isolationLevel = IsolationLevel.fromName((String)icebergTable.properties().getOrDefault("write.delete.isolation-level", "serializable"))) == IsolationLevel.SERIALIZABLE) {
                rowDelta.validateNoConflictingDataFiles();
            }
            if (runUpdateValidations) {
                rowDelta.validateDeletedFiles();
                rowDelta.validateNoConflictingDeleteFiles();
            }
            ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
            ImmutableSet.Builder referencedDataFiles = ImmutableSet.builder();
            block10: for (CommitTaskData task2 : commitTasks) {
                PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)task2.getPartitionSpecJson());
                Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
                switch (task2.getContent()) {
                    case POSITION_DELETES: {
                        if (fullyDeletedFiles.containsKey(task2.getReferencedDataFile().orElseThrow())) continue block10;
                        FileMetadata.Builder deleteBuilder = FileMetadata.deleteFileBuilder((PartitionSpec)partitionSpec).withPath(task2.getPath()).withFormat(task2.getFileFormat().toIceberg()).ofPositionDeletes().withFileSizeInBytes(task2.getFileSizeInBytes()).withMetrics(task2.getMetrics().metrics());
                        if (!partitionSpec.fields().isEmpty()) {
                            String partitionDataJson = task2.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                            deleteBuilder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
                        }
                        rowDelta.addDeletes(deleteBuilder.build());
                        writtenFiles.add((Object)task2.getPath());
                        task2.getReferencedDataFile().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedDataFiles).add(arg_0));
                        continue block10;
                    }
                    case DATA: {
                        DataFiles.Builder builder = DataFiles.builder((PartitionSpec)partitionSpec).withPath(task2.getPath()).withFormat(task2.getFileFormat().toIceberg()).withFileSizeInBytes(task2.getFileSizeInBytes()).withMetrics(task2.getMetrics().metrics());
                        if (!icebergTable.spec().fields().isEmpty()) {
                            String partitionDataJson = task2.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                            builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
                        }
                        rowDelta.addRows(builder.build());
                        writtenFiles.add((Object)task2.getPath());
                        continue block10;
                    }
                }
                throw new UnsupportedOperationException("Unsupported task content: " + task2.getContent());
            }
            if (table.getRetryMode() != RetryMode.NO_RETRIES) {
                this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
            }
            rowDelta.validateDataFilesExist((Iterable)referencedDataFiles.build());
            try {
                rowDelta.commit();
            }
            catch (ValidationException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to commit Iceberg update to table: " + table.getSchemaTableName(), (Throwable)e);
            }
        }
        if (!fullyDeletedFiles.isEmpty()) {
            try {
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(table.getTableLocation()));
                for (List commitTasksToCleanUp : fullyDeletedFiles.values()) {
                    for (CommitTaskData commitTaskData : commitTasksToCleanUp) {
                        if (fileSystem.delete(new Path(commitTaskData.getPath()), false)) continue;
                        log.warn("Failed to clean up uncommitted position delete file: %s", new Object[]{commitTaskData.getPath()});
                    }
                }
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Failed to clean up uncommitted position delete files");
            }
        }
        try {
            if (!fullyDeletedFiles.isEmpty()) {
                DeleteFiles deleteFiles = this.transaction.newDelete();
                fullyDeletedFiles.keySet().forEach(arg_0 -> ((DeleteFiles)deleteFiles).deleteFile(arg_0));
                deleteFiles.commit();
            }
            this.transaction.commitTransaction();
        }
        catch (ValidationException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to commit Iceberg update to table: " + table.getSchemaTableName(), (Throwable)e);
        }
        this.transaction = null;
    }

    private static boolean fileIsFullyDeleted(List<CommitTaskData> positionDeletes) {
        Preconditions.checkArgument((!positionDeletes.isEmpty() ? 1 : 0) != 0, (Object)"Cannot call fileIsFullyDeletes with an empty list");
        String referencedDataFile = positionDeletes.get(0).getReferencedDataFile().orElseThrow();
        long fileRecordCount = positionDeletes.get(0).getFileRecordCount().orElseThrow();
        Preconditions.checkArgument((boolean)positionDeletes.stream().allMatch(positionDelete -> positionDelete.getReferencedDataFile().orElseThrow().equals(referencedDataFile) && positionDelete.getFileRecordCount().orElseThrow() == fileRecordCount), (Object)"All position deletes must be for the same file and have the same fileRecordCount");
        long deletedRowCount = positionDeletes.stream().map(CommitTaskData::getDeletedRowCount).mapToLong(Optional::orElseThrow).sum();
        Preconditions.checkState((deletedRowCount <= fileRecordCount ? 1 : 0) != 0, (Object)"Found more deleted rows than exist in the file");
        return fileRecordCount == deletedRowCount;
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        this.catalog.createView(session, viewName, definition, replace);
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.catalog.renameView(session, source, target);
    }

    public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        this.catalog.setViewPrincipal(session, viewName, principal);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropView(session, viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.getViews(session, schemaName);
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getView(session, viewName);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        icebergTable.newDelete().deleteFromRowFilter(ExpressionConverter.toIcebergExpression(handle.getEnforcedPredicate())).commit();
        Map summary = icebergTable.currentSnapshot().summary();
        String deletedRowsStr = (String)summary.get("deleted-records");
        if (deletedRowsStr == null) {
            return OptionalLong.empty();
        }
        long deletedRecords = Long.parseLong(deletedRowsStr);
        long removedPositionDeletes = Long.parseLong(summary.getOrDefault("removed-position-deletes", "0"));
        long removedEqualityDeletes = Long.parseLong(summary.getOrDefault("removed-equality-deletes", "0"));
        return OptionalLong.of(deletedRecords - removedPositionDeletes - removedEqualityDeletes);
    }

    public void rollback() {
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        TupleDomain remainingConstraint;
        TupleDomain newUnenforcedConstraint;
        TupleDomain newEnforcedConstraint;
        IcebergTableHandle table = (IcebergTableHandle)handle;
        ConstraintExtractor.ExtractionResult extractionResult = ConstraintExtractor.extractTupleDomain(constraint);
        TupleDomain<IcebergColumnHandle> predicate = extractionResult.getTupleDomain();
        if (predicate.isAll()) {
            return Optional.empty();
        }
        if (predicate.isNone()) {
            newEnforcedConstraint = TupleDomain.none();
            newUnenforcedConstraint = TupleDomain.all();
            remainingConstraint = TupleDomain.all();
        } else {
            Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
            Long snapshotId = table.getSnapshotId().orElseThrow(() -> new IllegalStateException("Snapshot id must be present"));
            Set partitionSpecIds = (Set)icebergTable.snapshot(snapshotId.longValue()).allManifests(icebergTable.io()).stream().map(ManifestFile::partitionSpecId).collect(ImmutableSet.toImmutableSet());
            LinkedHashMap unsupported = new LinkedHashMap();
            LinkedHashMap newEnforced = new LinkedHashMap();
            LinkedHashMap newUnenforced = new LinkedHashMap();
            Map domains = (Map)predicate.getDomains().orElseThrow(() -> new VerifyException("No domains"));
            domains.forEach((columnHandle, domain) -> {
                if (HiveUtil.isStructuralType((io.trino.spi.type.Type)columnHandle.getType()) || columnHandle.getType() == UuidType.UUID && !domain.isOnlyNull() && !domain.getValues().isAll()) {
                    unsupported.put(columnHandle, domain);
                } else if (IcebergUtil.canEnforceColumnConstraintInSpecs(this.typeOperators, icebergTable, partitionSpecIds, columnHandle, domain)) {
                    newEnforced.put(columnHandle, domain);
                } else if (IcebergMetadataColumn.isMetadataColumnId(columnHandle.getId())) {
                    if (columnHandle.isPathColumn()) {
                        newEnforced.put(columnHandle, domain);
                    } else {
                        unsupported.put(columnHandle, domain);
                    }
                } else {
                    newUnenforced.put(columnHandle, domain);
                }
            });
            newEnforcedConstraint = TupleDomain.withColumnDomains(newEnforced).intersect(table.getEnforcedPredicate());
            newUnenforcedConstraint = TupleDomain.withColumnDomains(newUnenforced).intersect(table.getUnenforcedPredicate());
            remainingConstraint = TupleDomain.withColumnDomains(newUnenforced).intersect(TupleDomain.withColumnDomains(unsupported));
        }
        if (newEnforcedConstraint.equals(table.getEnforcedPredicate()) && newUnenforcedConstraint.equals(table.getUnenforcedPredicate())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)new IcebergTableHandle(table.getSchemaName(), table.getTableName(), table.getTableType(), table.getSnapshotId(), table.getTableSchemaJson(), table.getPartitionSpecJson(), table.getFormatVersion(), (TupleDomain<IcebergColumnHandle>)newUnenforcedConstraint, (TupleDomain<IcebergColumnHandle>)newEnforcedConstraint, table.getProjectedColumns(), table.getNameMappingJson(), table.getTableLocation(), table.getStorageProperties(), table.getRetryMode(), table.getUpdatedColumns(), table.isRecordScannedFiles(), table.getMaxScannedFileSize()), remainingConstraint.transformKeys(ColumnHandle.class::cast), extractionResult.getRemainingExpression(), false));
    }

    private static Set<Integer> identityPartitionColumnsInAllSpecs(Table table) {
        return (Set)table.spec().fields().stream().filter(field -> field.transform().isIdentity()).filter(field -> table.specs().values().stream().allMatch(spec -> spec.fields().contains(field))).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet());
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        if (!IcebergSessionProperties.isProjectionPushdownEnabled(session)) {
            return Optional.empty();
        }
        Set projectedExpressions = (Set)projections.stream().flatMap(expression -> HiveApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)expression).stream()).collect(ImmutableSet.toImmutableSet());
        Map columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), HiveApplyProjectionUtil::createProjectedColumnRepresentation));
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)handle;
        if (columnProjections.values().stream().allMatch(HiveApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) {
            Set projectedColumns = (Set)assignments.values().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableSet.toImmutableSet());
            if (icebergTableHandle.getProjectedColumns().equals(projectedColumns)) {
                return Optional.empty();
            }
            List assignmentsList = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((IcebergColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns(projectedColumns), projections, assignmentsList, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            HiveApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (HiveApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            IcebergColumnHandle baseColumnHandle = (IcebergColumnHandle)assignments.get(projectedColumn.getVariable().getName());
            IcebergColumnHandle projectedColumnHandle = IcebergMetadata.createProjectedColumnHandle(baseColumnHandle, projectedColumn.getDereferenceIndices(), expression2.getType());
            String projectedColumnName = projectedColumnHandle.getQualifiedName();
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, (ColumnHandle)projectedColumnHandle, expression2.getType());
            newAssignments.putIfAbsent(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.buildOrThrow();
        List newProjections = (List)projections.stream().map(arg_0 -> IcebergMetadata.lambda$applyProjection$55((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        List outputAssignments = (List)newAssignments.values().stream().collect(ImmutableList.toImmutableList());
        return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns((Set<IcebergColumnHandle>)projectedColumnsBuilder.build()), newProjections, outputAssignments, false));
    }

    private static IcebergColumnHandle createProjectedColumnHandle(IcebergColumnHandle column, List<Integer> indices, io.trino.spi.type.Type projectedColumnType) {
        if (indices.isEmpty()) {
            return column;
        }
        ImmutableList.Builder fullPath = ImmutableList.builder();
        fullPath.addAll(column.getPath());
        ColumnIdentity projectedColumnIdentity = column.getColumnIdentity();
        for (int index : indices) {
            projectedColumnIdentity = projectedColumnIdentity.getChildren().get(index);
            fullPath.add((Object)projectedColumnIdentity.getId());
        }
        return new IcebergColumnHandle(column.getBaseColumnIdentity(), column.getBaseType(), (List<Integer>)fullPath.build(), projectedColumnType, Optional.empty());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!IcebergSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        return TableStatisticsMaker.getTableStatistics(this.typeManager, handle, icebergTable);
    }

    public void setTableAuthorization(ConnectorSession session, SchemaTableName tableName, TrinoPrincipal principal) {
        this.catalog.setTablePrincipal(session, tableName, principal);
    }

    private Optional<Long> getSnapshotId(Table table, Optional<Long> snapshotId, boolean allowLegacySnapshotSyntax) {
        return snapshotId.map(id -> this.resolveSnapshotId(table, (long)id, allowLegacySnapshotSyntax)).or(() -> Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId));
    }

    private long resolveSnapshotId(Table table, long id, boolean allowLegacySnapshotSyntax) {
        return this.snapshotIds.computeIfAbsent(table.name() + "@" + id, ignored -> IcebergUtil.resolveSnapshotId(table, id, allowLegacySnapshotSyntax));
    }

    Table getIcebergTable(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.catalog.loadTable(session, schemaTableName);
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        this.catalog.createMaterializedView(session, viewName, definition, replace, ignoreExisting);
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropMaterializedView(session, viewName);
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        return false;
    }

    public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        this.beginTransaction(icebergTable);
        return new IcebergWritableTableHandle(table.getSchemaTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), icebergTable.location(), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties(), retryMode);
    }

    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<ConnectorTableHandle> sourceTableHandles) {
        this.executeDelete(session, tableHandle);
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(table.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.getPath());
        }
        String dependencies = sourceTableHandles.stream().map(handle -> (IcebergTableHandle)handle).filter(handle -> handle.getSnapshotId().isPresent()).map(handle -> handle.getSchemaTableName() + "=" + handle.getSnapshotId().get()).distinct().collect(Collectors.joining(","));
        if (table.getRetryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        appendFiles.set("dependsOnTables", dependencies);
        appendFiles.commit();
        this.transaction.commitTransaction();
        this.transaction = null;
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    private void cleanExtraOutputFiles(ConnectorSession session, Set<String> writtenFiles) {
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        Set<String> locations = IcebergMetadata.getOutputFilesLocations(writtenFiles);
        for (String location : locations) {
            this.cleanExtraOutputFiles(hdfsContext, session.getQueryId(), location, writtenFiles);
        }
    }

    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listMaterializedViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorMaterializedViewDefinition> getMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        HashMap<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new HashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();
        for (SchemaTableName name : this.listMaterializedViews(session, schemaName)) {
            try {
                this.getMaterializedView(session, name).ifPresent(view -> materializedViews.put(name, (ConnectorMaterializedViewDefinition)view));
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to access metadata of materialized view %s during listing", new Object[]{name});
            }
        }
        return materializedViews;
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getMaterializedView(session, viewName);
    }

    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        if (!source.getSchemaName().equals(target.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized View rename across schemas is not supported");
        }
        this.catalog.renameMaterializedView(session, source, target);
    }

    public Optional<TableToken> getTableToken(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        return Optional.ofNullable(icebergTable.currentSnapshot()).map(snapshot -> new TableToken(snapshot.snapshotId()));
    }

    public boolean isTableCurrent(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<TableToken> tableToken) {
        Optional<TableToken> currentToken = this.getTableToken(session, tableHandle);
        if (tableToken.isEmpty() || currentToken.isEmpty()) {
            return false;
        }
        return tableToken.get().getSnapshotId() == currentToken.get().getSnapshotId();
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName materializedViewName) {
        Map<String, Optional<TableToken>> refreshStateMap = this.getMaterializedViewToken(session, materializedViewName);
        if (refreshStateMap.isEmpty()) {
            return new MaterializedViewFreshness(false);
        }
        for (Map.Entry<String, Optional<TableToken>> entry : refreshStateMap.entrySet()) {
            List strings = Splitter.on((String)".").splitToList((CharSequence)entry.getKey());
            if (strings.size() == 3) {
                strings = strings.subList(1, 3);
            } else if (strings.size() != 2) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Invalid table name in '%s' property: %s'", "dependsOnTables", strings));
            }
            String schema = (String)strings.get(0);
            String name = (String)strings.get(1);
            SchemaTableName schemaTableName = new SchemaTableName(schema, name);
            ConnectorTableHandle tableHandle = this.getTableHandle(session, schemaTableName, Optional.empty(), Optional.empty());
            if (tableHandle == null) {
                throw new MaterializedViewNotFoundException(materializedViewName);
            }
            if (this.isTableCurrent(session, tableHandle, entry.getValue())) continue;
            return new MaterializedViewFreshness(false);
        }
        return new MaterializedViewFreshness(true);
    }

    public boolean supportsReportingWrittenBytes(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        return true;
    }

    public boolean supportsReportingWrittenBytes(ConnectorSession session, SchemaTableName fullTableName, Map<String, Object> tableProperties) {
        return true;
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        this.catalog.updateColumnComment(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), ((IcebergColumnHandle)column).getColumnIdentity(), comment);
    }

    private Map<String, Optional<TableToken>> getMaterializedViewToken(ConnectorSession session, SchemaTableName name) {
        HashMap<String, Optional<TableToken>> viewToken = new HashMap<String, Optional<TableToken>>();
        Optional<ConnectorMaterializedViewDefinition> materializedViewDefinition = this.getMaterializedView(session, name);
        if (materializedViewDefinition.isEmpty()) {
            return viewToken;
        }
        SchemaTableName storageTableName = materializedViewDefinition.get().getStorageTable().map(CatalogSchemaTableName::getSchemaTableName).orElseThrow(() -> new IllegalStateException("Storage table missing in definition of materialized view " + name));
        Table icebergTable = this.catalog.loadTable(session, storageTableName);
        String dependsOnTables = icebergTable.currentSnapshot().summary().getOrDefault("dependsOnTables", "");
        if (!dependsOnTables.isEmpty()) {
            Map tableToSnapshotIdMap = Splitter.on((char)',').withKeyValueSeparator('=').split((CharSequence)dependsOnTables);
            for (Map.Entry entry : tableToSnapshotIdMap.entrySet()) {
                viewToken.put((String)entry.getKey(), Optional.of(new TableToken(Long.parseLong((String)entry.getValue()))));
            }
        }
        return viewToken;
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        return this.catalog.redirectTable(session, tableName);
    }

    private void beginTransaction(Table icebergTable) {
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = icebergTable.newTransaction();
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$55(Map newVariables, ConnectorExpression expression) {
        return HiveApplyProjectionUtil.replaceWithNewVariables((ConnectorExpression)expression, (Map)newVariables);
    }

    private static /* synthetic */ Iterator lambda$getTableProperties$5(Supplier lazyFiles) {
        return ((List)lazyFiles.get()).iterator();
    }

    private static class TableToken {
        private final long snapshotId;

        public TableToken(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long getSnapshotId() {
            return this.snapshotId;
        }
    }
}

