/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.plugin.iceberg.IcebergBucketFunction;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import org.apache.iceberg.Schema;

public class IcebergNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;
    private final NodeManager nodeManager;

    @Inject
    public IcebergNodePartitioningProvider(TypeManager typeManager, NodeManager nodeManager) {
        this.typeOperators = Objects.requireNonNull(typeManager, "typeManager is null").getTypeOperators();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return ConnectorBucketNodeMap.createBucketNodeMap((int)this.nodeManager.getRequiredWorkerNodes().size());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return split -> {
            throw new UnsupportedOperationException();
        };
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        IcebergPartitioningHandle handle = (IcebergPartitioningHandle)partitioningHandle;
        Schema schema = IcebergUtil.schemaFromHandles(handle.getPartitioningColumns());
        return new IcebergBucketFunction(this.typeOperators, PartitionFields.parsePartitionFields(schema, handle.getPartitioning()), handle.getPartitioningColumns(), bucketCount);
    }
}

