/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergPageSink;
import io.trino.plugin.iceberg.delete.IcebergPositionDeletePageSink;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;

public class IcebergPageSource
implements UpdatablePageSource {
    private final Schema schema;
    private final int[] expectedColumnIndexes;
    private final ConnectorPageSource delegate;
    private final Optional<ReaderProjectionsAdapter> projectionsAdapter;
    private final Optional<RowPredicate> deletePredicate;
    private final Supplier<IcebergPositionDeletePageSink> positionDeleteSinkSupplier;
    private final Supplier<IcebergPageSink> updatedRowPageSinkSupplier;
    private int[] updateRowIdChildColumnIndexes = new int[0];
    private int updateRowIdColumnIndex = -1;
    private Map<Integer, Integer> icebergIdToRowIdColumnIndex = ImmutableMap.of();
    private Map<Integer, Integer> icebergIdToUpdatedColumnIndex = ImmutableMap.of();
    @Nullable
    private IcebergPositionDeletePageSink positionDeleteSink;
    @Nullable
    private IcebergPageSink updatedRowPageSink;

    public IcebergPageSource(Schema schema, List<IcebergColumnHandle> expectedColumns, List<IcebergColumnHandle> requiredColumns, ConnectorPageSource delegate, Optional<ReaderProjectionsAdapter> projectionsAdapter, Optional<RowPredicate> deletePredicate, Supplier<IcebergPositionDeletePageSink> positionDeleteSinkSupplier, Supplier<IcebergPageSink> updatedRowPageSinkSupplier, List<IcebergColumnHandle> updatedColumns) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(expectedColumns, "expectedColumns is null");
        Objects.requireNonNull(requiredColumns, "requiredColumns is null");
        this.expectedColumnIndexes = new int[expectedColumns.size()];
        for (int i = 0; i < expectedColumns.size(); ++i) {
            IcebergColumnHandle expectedColumn = expectedColumns.get(i);
            Preconditions.checkArgument((boolean)expectedColumn.equals(requiredColumns.get(i)), (Object)"Expected columns must be a prefix of required columns");
            this.expectedColumnIndexes[i] = i;
            if (!expectedColumn.isUpdateRowIdColumn()) continue;
            this.updateRowIdColumnIndex = i;
            Map<Integer, Integer> fieldIdToColumnIndex = IcebergPageSource.mapFieldIdsToIndex(requiredColumns);
            List<ColumnIdentity> rowIdFields = expectedColumn.getColumnIdentity().getChildren();
            ImmutableMap.Builder fieldIdToRowIdIndex = ImmutableMap.builder();
            this.updateRowIdChildColumnIndexes = new int[rowIdFields.size()];
            for (int columnIndex = 0; columnIndex < rowIdFields.size(); ++columnIndex) {
                int fieldId = rowIdFields.get(columnIndex).getId();
                this.updateRowIdChildColumnIndexes[columnIndex] = Objects.requireNonNull(fieldIdToColumnIndex.get(fieldId), () -> String.format("Column %s not found in requiredColumns", fieldId));
                fieldIdToRowIdIndex.put((Object)fieldId, (Object)columnIndex);
            }
            this.icebergIdToRowIdColumnIndex = fieldIdToRowIdIndex.buildOrThrow();
        }
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.projectionsAdapter = Objects.requireNonNull(projectionsAdapter, "projectionsAdapter is null");
        this.deletePredicate = Objects.requireNonNull(deletePredicate, "deletePredicate is null");
        this.positionDeleteSinkSupplier = Objects.requireNonNull(positionDeleteSinkSupplier, "positionDeleteSinkSupplier is null");
        this.updatedRowPageSinkSupplier = Objects.requireNonNull(updatedRowPageSinkSupplier, "updatedRowPageSinkSupplier is null");
        Objects.requireNonNull(updatedColumns, "updatedColumnFieldIds is null");
        if (!updatedColumns.isEmpty()) {
            this.icebergIdToUpdatedColumnIndex = IcebergPageSource.mapFieldIdsToIndex(updatedColumns);
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            if (this.deletePredicate.isPresent()) {
                dataPage = this.deletePredicate.get().filterPage(dataPage);
            }
            if (this.projectionsAdapter.isPresent()) {
                dataPage = this.projectionsAdapter.get().adaptPage(dataPage);
            }
            dataPage = this.setUpdateRowIdBlock(dataPage);
            dataPage = dataPage.getColumns(this.expectedColumnIndexes);
            return dataPage;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
        }
    }

    private Page setUpdateRowIdBlock(Page page) {
        if (this.updateRowIdColumnIndex == -1) {
            return page;
        }
        Block[] rowIdFields = new Block[this.updateRowIdChildColumnIndexes.length];
        for (int childIndex = 0; childIndex < this.updateRowIdChildColumnIndexes.length; ++childIndex) {
            rowIdFields[childIndex] = page.getBlock(this.updateRowIdChildColumnIndexes[childIndex]);
        }
        Block[] fullPage = new Block[page.getChannelCount()];
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            fullPage[channel] = channel == this.updateRowIdColumnIndex ? RowBlock.fromFieldBlocks((int)page.getPositionCount(), Optional.empty(), (Block[])rowIdFields) : page.getBlock(channel);
        }
        return new Page(page.getPositionCount(), fullPage);
    }

    public void deleteRows(Block rowIds) {
        if (this.positionDeleteSink == null) {
            this.positionDeleteSink = this.positionDeleteSinkSupplier.get();
            Verify.verify((this.positionDeleteSink != null ? 1 : 0) != 0);
        }
        this.positionDeleteSink.appendPage(new Page(new Block[]{rowIds})).join();
    }

    public void updateRows(Page page, List<Integer> columnValueAndRowIdChannels) {
        int rowIdChannel = columnValueAndRowIdChannels.get(columnValueAndRowIdChannels.size() - 1);
        List<Integer> columnChannelMapping = columnValueAndRowIdChannels.subList(0, columnValueAndRowIdChannels.size() - 1);
        if (this.positionDeleteSink == null) {
            this.positionDeleteSink = this.positionDeleteSinkSupplier.get();
            Verify.verify((this.positionDeleteSink != null ? 1 : 0) != 0);
        }
        if (this.updatedRowPageSink == null) {
            this.updatedRowPageSink = this.updatedRowPageSinkSupplier.get();
            Verify.verify((this.updatedRowPageSink != null ? 1 : 0) != 0);
        }
        ColumnarRow rowIdColumns = ColumnarRow.toColumnarRow((Block)page.getBlock(rowIdChannel));
        this.positionDeleteSink.appendPage(new Page(new Block[]{rowIdColumns.getField(0)})).join();
        List columns = this.schema.columns();
        Block[] fullPage = new Block[columns.size()];
        Set<Integer> updatedColumnFieldIds = this.icebergIdToUpdatedColumnIndex.keySet();
        for (int targetChannel = 0; targetChannel < columns.size(); ++targetChannel) {
            Types.NestedField column = (Types.NestedField)columns.get(targetChannel);
            fullPage[targetChannel] = updatedColumnFieldIds.contains(column.fieldId()) ? page.getBlock(columnChannelMapping.get(this.icebergIdToUpdatedColumnIndex.get(column.fieldId())).intValue()) : rowIdColumns.getField(this.icebergIdToRowIdColumnIndex.get(column.fieldId()).intValue());
        }
        this.updatedRowPageSink.appendPage(new Page(page.getPositionCount(), fullPage)).join();
    }

    public CompletableFuture<Collection<Slice>> finish() {
        CompletionStage<Object> fragments = CompletableFuture.completedFuture(ImmutableList.of());
        BiFunction<Collection, Collection, Collection> combineSliceCollections = (collection1, collection2) -> ImmutableList.builder().addAll((Iterable)collection1).addAll((Iterable)collection2).build();
        if (this.positionDeleteSink != null) {
            fragments = fragments.thenCombine(this.positionDeleteSink.finish(), combineSliceCollections);
        }
        if (this.updatedRowPageSink != null) {
            fragments = fragments.thenCombine(this.updatedRowPageSink.finish(), combineSliceCollections);
        }
        return fragments;
    }

    public void abort() {
        if (this.positionDeleteSink != null) {
            this.positionDeleteSink.abort();
        }
        if (this.updatedRowPageSink != null) {
            this.updatedRowPageSink.abort();
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getMemoryUsage() {
        long memoryUsage = this.delegate.getMemoryUsage();
        if (this.positionDeleteSink != null) {
            memoryUsage += this.positionDeleteSink.getMemoryUsage();
        }
        return memoryUsage;
    }

    public Metrics getMetrics() {
        return this.delegate.getMetrics();
    }

    protected void closeWithSuppression(Throwable throwable) {
        Closables.closeAllSuppress((Throwable)throwable, (AutoCloseable[])new AutoCloseable[]{this});
    }

    private static Map<Integer, Integer> mapFieldIdsToIndex(List<IcebergColumnHandle> columns) {
        ImmutableMap.Builder fieldIdsToIndex = ImmutableMap.builder();
        for (int i = 0; i < columns.size(); ++i) {
            fieldIdsToIndex.put((Object)columns.get(i).getId(), (Object)i);
        }
        return fieldIdsToIndex.buildOrThrow();
    }
}

