/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.graph.Traverser;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.TupleDomainOrcPredicate;
import io.trino.orc.metadata.OrcType;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.predicate.Predicate;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.base.classloader.ClassLoaderSafeUpdatablePageSource;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.parquet.HdfsParquetDataSource;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.ConstantPopulatingPageSource;
import io.trino.plugin.iceberg.FileIoProvider;
import io.trino.plugin.iceberg.IcebergAvroPageSource;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileWriterFactory;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergPageSink;
import io.trino.plugin.iceberg.IcebergPageSource;
import io.trino.plugin.iceberg.IcebergParquetColumnIOConverter;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.delete.DeleteFilter;
import io.trino.plugin.iceberg.delete.EqualityDeleteFilter;
import io.trino.plugin.iceberg.delete.IcebergPositionDeletePageSink;
import io.trino.plugin.iceberg.delete.PositionDeleteFilter;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final String AVRO_FIELD_ID = "field-id";
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final OrcReaderOptions orcReaderOptions;
    private final ParquetReaderOptions parquetReaderOptions;
    private final TypeManager typeManager;
    private final FileIoProvider fileIoProvider;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final IcebergFileWriterFactory fileWriterFactory;
    private final PageIndexerFactory pageIndexerFactory;
    private final int maxOpenPartitions;

    @Inject
    public IcebergPageSourceProvider(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats fileFormatDataSourceStats, OrcReaderConfig orcReaderConfig, ParquetReaderConfig parquetReaderConfig, TypeManager typeManager, FileIoProvider fileIoProvider, JsonCodec<CommitTaskData> jsonCodec, IcebergFileWriterFactory fileWriterFactory, PageIndexerFactory pageIndexerFactory, IcebergConfig icebergConfig) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.orcReaderOptions = Objects.requireNonNull(orcReaderConfig, "orcReaderConfig is null").toOrcReaderOptions();
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderConfig, "parquetReaderConfig is null").toParquetReaderOptions();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.fileIoProvider = Objects.requireNonNull(fileIoProvider, "fileIoProvider is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        Objects.requireNonNull(icebergConfig, "icebergConfig is null");
        this.maxOpenPartitions = icebergConfig.getMaxPartitionsPerWriter();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        IcebergSplit split = (IcebergSplit)connectorSplit;
        IcebergTableHandle table = (IcebergTableHandle)connectorTable;
        List icebergColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        org.apache.iceberg.Schema tableSchema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        List<DeleteFilter> deleteFilters = this.readDeletes(session, tableSchema, split.getPath(), split.getDeletes());
        Set deleteFilterRequiredColumns = (Set)deleteFilters.stream().flatMap(filter -> IcebergUtil.getColumns(filter.schema(), this.typeManager).stream()).collect(ImmutableSet.toImmutableSet());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((org.apache.iceberg.Schema)tableSchema, (String)split.getPartitionSpecJson());
        Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(tableSchema.findType(field.sourceId()))).toArray(Type[]::new);
        PartitionData partitionData = PartitionData.fromJson(split.getPartitionDataJson(), partitionColumnTypes);
        Map<Integer, Optional<String>> partitionKeys = IcebergUtil.getPartitionKeys(partitionData, partitionSpec);
        ArrayList<IcebergColumnHandle> requiredColumns = new ArrayList<IcebergColumnHandle>(icebergColumns);
        deleteFilterRequiredColumns.stream().filter(java.util.function.Predicate.not(icebergColumns::contains)).forEach(requiredColumns::add);
        icebergColumns.stream().filter(IcebergColumnHandle::isUpdateRowIdColumn).findFirst().ifPresent(updateRowIdColumn -> {
            Set alreadyRequiredColumnIds = (Set)requiredColumns.stream().map(IcebergColumnHandle::getId).collect(ImmutableSet.toImmutableSet());
            for (ColumnIdentity requiredColumnIdentity : updateRowIdColumn.getColumnIdentity().getChildren()) {
                if (alreadyRequiredColumnIds.contains(requiredColumnIdentity.getId())) continue;
                if (requiredColumnIdentity.getId() == MetadataColumns.ROW_POSITION.fieldId()) {
                    requiredColumns.add(new IcebergColumnHandle(requiredColumnIdentity, (io.trino.spi.type.Type)BigintType.BIGINT, (List<Integer>)ImmutableList.of(), (io.trino.spi.type.Type)BigintType.BIGINT, Optional.empty()));
                    continue;
                }
                requiredColumns.add(IcebergUtil.getColumnHandle(tableSchema.findField(requiredColumnIdentity.getId()), this.typeManager));
            }
        });
        TupleDomain effectivePredicate = table.getUnenforcedPredicate().intersect(dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast)).simplify(1000);
        if (effectivePredicate.isNone()) {
            return new EmptyPageSource();
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        long fileSize = split.getFileSize();
        if (!IcebergSessionProperties.isUseFileSizeFromMetadata(session)) {
            fileSize = this.fileIoProvider.createFileIo(hdfsContext, session.getQueryId()).newInputFile(split.getPath()).getLength();
        }
        OptionalLong fileModifiedTime = OptionalLong.empty();
        if (requiredColumns.stream().anyMatch(IcebergColumnHandle::isFileModifiedTimeColumn)) {
            try {
                FileStatus fileStatus = (FileStatus)this.hdfsEnvironment.doAs(session.getIdentity(), () -> this.hdfsEnvironment.getFileSystem(hdfsContext, new Path(split.getPath())).getFileStatus(new Path(split.getPath())));
                fileModifiedTime = OptionalLong.of(fileStatus.getModificationTime());
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, (Throwable)e);
            }
        }
        ReaderPageSource dataPageSource = this.createDataPageSource(session, hdfsContext, split.getPath(), split.getStart(), split.getLength(), fileSize, fileModifiedTime, split.getFileFormat(), split.getSchemaAsJson().map(SchemaParser::fromJson), requiredColumns, (TupleDomain<IcebergColumnHandle>)effectivePredicate, table.getNameMappingJson().map(NameMappingParser::fromJson), partitionKeys);
        Optional<ReaderProjectionsAdapter> projectionsAdapter = dataPageSource.getReaderColumns().map(readerColumns -> new ReaderProjectionsAdapter(requiredColumns, readerColumns, column -> ((IcebergColumnHandle)column).getType(), IcebergPageSourceProvider::applyProjection));
        List readColumns = dataPageSource.getReaderColumns().map(readerColumns -> readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(Collectors.toList())).orElse(requiredColumns);
        Optional<RowPredicate> deletePredicate = deleteFilters.stream().map(filter -> filter.createPredicate(readColumns)).reduce(RowPredicate::and);
        Optional<Object> partition = partitionSpec.isUnpartitioned() ? Optional.empty() : Optional.of(partitionData);
        LocationProvider locationProvider = IcebergUtil.getLocationProvider(table.getSchemaTableName(), table.getTableLocation(), table.getStorageProperties());
        Supplier<IcebergPositionDeletePageSink> positionDeleteSink = () -> new IcebergPositionDeletePageSink(split.getPath(), partitionSpec, partition, locationProvider, this.fileWriterFactory, this.hdfsEnvironment, hdfsContext, this.fileIoProvider, this.jsonCodec, session, split.getFileFormat(), table.getStorageProperties(), split.getFileRecordCount());
        Supplier<IcebergPageSink> updatedRowPageSinkSupplier = () -> new IcebergPageSink(tableSchema, PartitionSpecParser.fromJson((org.apache.iceberg.Schema)tableSchema, (String)table.getPartitionSpecJson().orElseThrow(() -> new VerifyException("Partition spec missing in the table handle"))), locationProvider, this.fileWriterFactory, this.pageIndexerFactory, this.hdfsEnvironment, hdfsContext, this.fileIoProvider, (List)tableSchema.columns().stream().map(column -> IcebergUtil.getColumnHandle(column, this.typeManager)).collect(ImmutableList.toImmutableList()), this.jsonCodec, session, split.getFileFormat(), table.getStorageProperties(), this.maxOpenPartitions);
        return new ClassLoaderSafeUpdatablePageSource((UpdatablePageSource)new IcebergPageSource(tableSchema, icebergColumns, requiredColumns, dataPageSource.get(), projectionsAdapter, deletePredicate, positionDeleteSink, updatedRowPageSinkSupplier, table.getUpdatedColumns()), this.getClass().getClassLoader());
    }

    private List<DeleteFilter> readDeletes(ConnectorSession session, org.apache.iceberg.Schema schema, String dataFilePath, List<DeleteFile> deleteFiles) {
        Slice targetPath = Slices.utf8Slice((String)dataFilePath);
        ArrayList<DeleteFilter> filters = new ArrayList<DeleteFilter>();
        Roaring64Bitmap deletedRows = new Roaring64Bitmap();
        IcebergColumnHandle deleteFilePath = IcebergUtil.getColumnHandle(MetadataColumns.DELETE_FILE_PATH, this.typeManager);
        IcebergColumnHandle deleteFilePos = IcebergUtil.getColumnHandle(MetadataColumns.DELETE_FILE_POS, this.typeManager);
        ImmutableList deleteColumns = ImmutableList.of((Object)deleteFilePath, (Object)deleteFilePos);
        TupleDomain deleteDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)deleteFilePath, (Object)NullableValue.of((io.trino.spi.type.Type)VarcharType.VARCHAR, (Object)targetPath)));
        for (DeleteFile delete : deleteFiles) {
            if (delete.content() == FileContent.POSITION_DELETES) {
                try {
                    ConnectorPageSource pageSource = this.openDeletes(session, delete, (List<IcebergColumnHandle>)deleteColumns, (TupleDomain<IcebergColumnHandle>)deleteDomain);
                    try {
                        PositionDeleteFilter.readPositionDeletes(pageSource, targetPath, (LongBitmapDataProvider)deletedRows);
                        continue;
                    }
                    finally {
                        if (pageSource == null) continue;
                        pageSource.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (delete.content() == FileContent.EQUALITY_DELETES) {
                List<Integer> fieldIds = delete.equalityFieldIds();
                Verify.verify((!fieldIds.isEmpty() ? 1 : 0) != 0, (String)"equality field IDs are missing", (Object[])new Object[0]);
                List columns = (List)fieldIds.stream().map(id -> IcebergUtil.getColumnHandle(schema.findField(id.intValue()), this.typeManager)).collect(ImmutableList.toImmutableList());
                try {
                    ConnectorPageSource pageSource = this.openDeletes(session, delete, columns, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
                    try {
                        filters.add(EqualityDeleteFilter.readEqualityDeletes(pageSource, columns, schema));
                        continue;
                    }
                    finally {
                        if (pageSource == null) continue;
                        pageSource.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            throw new VerifyException("Unknown delete content: " + delete.content());
        }
        if (!deletedRows.isEmpty()) {
            filters.add(new PositionDeleteFilter((ImmutableLongBitmapDataProvider)deletedRows));
        }
        return filters;
    }

    private ConnectorPageSource openDeletes(ConnectorSession session, DeleteFile delete, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> tupleDomain) {
        return this.createDataPageSource(session, new HdfsEnvironment.HdfsContext(session), delete.path().toString(), 0L, delete.fileSizeInBytes(), delete.fileSizeInBytes(), OptionalLong.empty(), IcebergFileFormat.fromIceberg(delete.format()), Optional.of(IcebergUtil.schemaFromHandles(columns)), columns, tupleDomain, Optional.empty(), (Map<Integer, Optional<String>>)ImmutableMap.of()).get();
    }

    public ReaderPageSource createDataPageSource(ConnectorSession session, HdfsEnvironment.HdfsContext hdfsContext, String path, long start, long length, long fileSize, OptionalLong fileModifiedTime, IcebergFileFormat fileFormat, Optional<org.apache.iceberg.Schema> fileSchema, List<IcebergColumnHandle> dataColumns, TupleDomain<IcebergColumnHandle> predicate, Optional<NameMapping> nameMapping, Map<Integer, Optional<String>> partitionKeys) {
        Path hadoopPath = new Path(IcebergPageSourceProvider.hadoopPath(path));
        switch (fileFormat) {
            case ORC: {
                return IcebergPageSourceProvider.createOrcPageSource(this.hdfsEnvironment, session.getIdentity(), this.hdfsEnvironment.getConfiguration(hdfsContext, hadoopPath), path, hadoopPath, start, length, fileSize, fileModifiedTime, dataColumns, predicate, this.orcReaderOptions.withMaxMergeDistance(IcebergSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(IcebergSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(IcebergSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(IcebergSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(IcebergSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(IcebergSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(IcebergSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(IcebergSessionProperties.isOrcBloomFiltersEnabled(session)), this.fileFormatDataSourceStats, this.typeManager, nameMapping, partitionKeys);
            }
            case PARQUET: {
                return IcebergPageSourceProvider.createParquetPageSource(this.hdfsEnvironment, session.getIdentity(), this.hdfsEnvironment.getConfiguration(hdfsContext, hadoopPath), path, hadoopPath, start, length, fileSize, fileModifiedTime, dataColumns, this.parquetReaderOptions.withMaxReadBlockSize(IcebergSessionProperties.getParquetMaxReadBlockSize(session)), predicate, this.fileFormatDataSourceStats, nameMapping, partitionKeys);
            }
            case AVRO: {
                return this.createAvroPageSource(this.fileIoProvider.createFileIo(hdfsContext, session.getQueryId()), path, hadoopPath, start, length, fileModifiedTime, fileSchema.orElseThrow(), nameMapping, dataColumns);
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + fileFormat);
    }

    private static ReaderPageSource createOrcPageSource(HdfsEnvironment hdfsEnvironment, ConnectorIdentity identity, Configuration configuration, String path, Path hadoopPath, long start, long length, long fileSize, OptionalLong fileModifiedTime, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> effectivePredicate, OrcReaderOptions options, FileFormatDataSourceStats stats, TypeManager typeManager, Optional<NameMapping> nameMapping, Map<Integer, Optional<String>> partitionKeys) {
        HdfsOrcDataSource orcDataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(identity, hadoopPath, configuration);
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(identity, () -> fileSystem.open(hadoopPath));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(hadoopPath.toString()), fileSize, options, inputStream, stats);
            OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "ORC file is zero length"));
            List fileColumns = reader.getRootColumn().getNestedColumns();
            if (nameMapping.isPresent() && !IcebergPageSourceProvider.hasIds(reader.getRootColumn())) {
                fileColumns = (List)fileColumns.stream().map(orcColumn -> IcebergPageSourceProvider.setMissingFieldIds(orcColumn, (NameMapping)nameMapping.get(), (List<String>)ImmutableList.of((Object)orcColumn.getColumnName()))).collect(ImmutableList.toImmutableList());
            }
            Map<Integer, OrcColumn> fileColumnsByIcebergId = IcebergPageSourceProvider.mapIdsToOrcFileColumns(fileColumns);
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled());
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            Optional<ReaderColumns> columnProjections = IcebergPageSourceProvider.projectColumns(columns);
            Map projectionsByFieldId = columns.stream().collect(Collectors.groupingBy(column -> column.getBaseColumnIdentity().getId(), Collectors.mapping(IcebergColumnHandle::getPath, Collectors.toUnmodifiableList())));
            List<IcebergColumnHandle> readColumns = columnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(columns);
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>(readColumns.size());
            ArrayList<io.trino.spi.type.Type> fileReadTypes = new ArrayList<io.trino.spi.type.Type>(readColumns.size());
            ArrayList<OrcReader.ProjectedLayout> projectedLayouts = new ArrayList<OrcReader.ProjectedLayout>(readColumns.size());
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(readColumns.size());
            for (IcebergColumnHandle column2 : readColumns) {
                Verify.verify((boolean)column2.isBaseColumn(), (String)"Column projections must be based from a root column", (Object[])new Object[0]);
                OrcColumn orcColumn2 = fileColumnsByIcebergId.get(column2.getId());
                if (column2.isIsDeletedColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)BooleanType.BOOLEAN, (Object)false)));
                    continue;
                }
                if (partitionKeys.containsKey(column2.getId())) {
                    io.trino.spi.type.Type trinoType = column2.getType();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column2.getId()).orElse(null), column2.getName()))));
                    continue;
                }
                if (column2.isPathColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)path))));
                    continue;
                }
                if (column2.isFileModifiedTimeColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime.orElseThrow(), (TimeZoneKey)TimeZoneKey.UTC_KEY))));
                    continue;
                }
                if (column2.isUpdateRowIdColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn((io.trino.spi.type.Type)column2.getType()));
                    continue;
                }
                if (column2.isRowPositionColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.positionColumn());
                    continue;
                }
                if (orcColumn2 != null) {
                    io.trino.spi.type.Type readType = IcebergPageSourceProvider.getOrcReadType(column2.getType(), typeManager);
                    if (column2.getType() == UuidType.UUID && !"UUID".equals(orcColumn2.getAttributes().get("iceberg.binary-type"))) {
                        throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, String.format("Expected ORC column for UUID data to be annotated with %s=UUID: %s", "iceberg.binary-type", orcColumn2));
                    }
                    List<List<Integer>> fieldIdProjections = projectionsByFieldId.get(column2.getId());
                    OrcReader.ProjectedLayout projectedLayout = IcebergOrcProjectedLayout.createProjectedLayout(orcColumn2, fieldIdProjections);
                    int sourceIndex = fileReadColumns.size();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn((int)sourceIndex));
                    fileReadColumns.add(orcColumn2);
                    fileReadTypes.add(readType);
                    projectedLayouts.add(projectedLayout);
                    for (Map.Entry domainEntry : effectivePredicateDomains.entrySet()) {
                        IcebergColumnHandle predicateColumn = (IcebergColumnHandle)domainEntry.getKey();
                        OrcColumn predicateOrcColumn = fileColumnsByIcebergId.get(predicateColumn.getId());
                        if (predicateOrcColumn == null || !column2.getColumnIdentity().equals(predicateColumn.getBaseColumnIdentity())) continue;
                        predicateBuilder.addColumn(predicateOrcColumn.getColumnId(), (Domain)domainEntry.getValue());
                    }
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn((io.trino.spi.type.Type)column2.getType()));
            }
            AggregatedMemoryContext memoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            OrcDataSourceId orcDataSourceId = orcDataSource.getId();
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, projectedLayouts, (OrcPredicate)predicateBuilder.build(), start, length, DateTimeZone.UTC, memoryUsage, 1, exception -> IcebergPageSourceProvider.handleException(orcDataSourceId, exception), (OrcReader.FieldMapperFactory)new IdBasedFieldMapperFactory(readColumns));
            return new ReaderPageSource((ConnectorPageSource)new OrcPageSource(recordReader, columnAdaptations, (OrcDataSource)orcDataSource, Optional.empty(), Optional.empty(), memoryUsage, stats, reader.getCompressionKind()), columnProjections);
        }
        catch (IOException | RuntimeException e) {
            block18: {
                if (orcDataSource != null) {
                    try {
                        orcDataSource.close();
                    }
                    catch (IOException ex) {
                        if (e.equals(ex)) break block18;
                        e.addSuppressed(ex);
                    }
                }
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", hadoopPath, start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static boolean hasIds(OrcColumn column) {
        if (column.getAttributes().containsKey("iceberg.id")) {
            return true;
        }
        return column.getNestedColumns().stream().anyMatch(IcebergPageSourceProvider::hasIds);
    }

    private static OrcColumn setMissingFieldIds(OrcColumn column, NameMapping nameMapping, List<String> qualifiedPath) {
        MappedField mappedField = nameMapping.find(qualifiedPath);
        ImmutableMap.Builder attributes = ImmutableMap.builder().putAll(column.getAttributes());
        if (mappedField != null && mappedField.id() != null) {
            attributes.put((Object)"iceberg.id", (Object)String.valueOf(mappedField.id()));
        }
        return new OrcColumn(column.getPath(), column.getColumnId(), column.getColumnName(), column.getColumnType(), column.getOrcDataSourceId(), (List)column.getNestedColumns().stream().map(nestedColumn -> {
            ImmutableList.Builder nextQualifiedPath = ImmutableList.builder().addAll((Iterable)qualifiedPath);
            if (column.getColumnType() == OrcType.OrcTypeKind.LIST) {
                nextQualifiedPath.add((Object)"element");
            } else {
                nextQualifiedPath.add((Object)nestedColumn.getColumnName());
            }
            return IcebergPageSourceProvider.setMissingFieldIds(nestedColumn, nameMapping, (List<String>)nextQualifiedPath.build());
        }).collect(ImmutableList.toImmutableList()), (Map)attributes.buildOrThrow());
    }

    private static List<Integer> applyProjection(ColumnHandle expectedColumnHandle, ColumnHandle readColumnHandle) {
        IcebergColumnHandle expectedColumn = (IcebergColumnHandle)expectedColumnHandle;
        IcebergColumnHandle readColumn = (IcebergColumnHandle)readColumnHandle;
        Preconditions.checkState((boolean)readColumn.isBaseColumn(), (Object)"Read column path must be a base column");
        ImmutableList.Builder dereferenceChain = ImmutableList.builder();
        ColumnIdentity columnIdentity = readColumn.getColumnIdentity();
        for (Integer fieldId : expectedColumn.getPath()) {
            ColumnIdentity nextChild = columnIdentity.getChildByFieldId(fieldId);
            dereferenceChain.add((Object)columnIdentity.getChildIndexByFieldId(fieldId));
            columnIdentity = nextChild;
        }
        return dereferenceChain.build();
    }

    private static Map<Integer, OrcColumn> mapIdsToOrcFileColumns(List<OrcColumn> columns) {
        ImmutableMap.Builder columnsById = ImmutableMap.builder();
        Traverser.forTree(OrcColumn::getNestedColumns).depthFirstPreOrder(columns).forEach(column -> {
            String fieldId = (String)column.getAttributes().get("iceberg.id");
            if (fieldId != null) {
                columnsById.put((Object)Integer.parseInt(fieldId), column);
            }
        });
        return columnsById.buildOrThrow();
    }

    private static Integer getIcebergFieldId(OrcColumn column) {
        String icebergId = (String)column.getAttributes().get("iceberg.id");
        Verify.verify((icebergId != null ? 1 : 0) != 0, (String)String.format("column %s does not have %s property", column, "iceberg.id"), (Object[])new Object[0]);
        return Integer.valueOf(icebergId);
    }

    private static io.trino.spi.type.Type getOrcReadType(io.trino.spi.type.Type columnType, TypeManager typeManager) {
        if (columnType == UuidType.UUID) {
            return VarbinaryType.VARBINARY;
        }
        if (columnType instanceof ArrayType) {
            return new ArrayType(IcebergPageSourceProvider.getOrcReadType(((ArrayType)columnType).getElementType(), typeManager));
        }
        if (columnType instanceof MapType) {
            MapType mapType = (MapType)columnType;
            io.trino.spi.type.Type keyType = IcebergPageSourceProvider.getOrcReadType(mapType.getKeyType(), typeManager);
            io.trino.spi.type.Type valueType = IcebergPageSourceProvider.getOrcReadType(mapType.getValueType(), typeManager);
            return new MapType(keyType, valueType, typeManager.getTypeOperators());
        }
        if (columnType instanceof RowType) {
            return RowType.from((List)((List)((RowType)columnType).getFields().stream().map(field -> new RowType.Field(field.getName(), IcebergPageSourceProvider.getOrcReadType(field.getType(), typeManager))).collect(ImmutableList.toImmutableList())));
        }
        return columnType;
    }

    private static ReaderPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, ConnectorIdentity identity, Configuration configuration, String path, Path hadoopPath, long start, long length, long fileSize, OptionalLong fileModifiedTime, List<IcebergColumnHandle> regularColumns, ParquetReaderOptions options, TupleDomain<IcebergColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats, Optional<NameMapping> nameMapping, Map<Integer, Optional<String>> partitionKeys) {
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        HdfsParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(identity, hadoopPath, configuration);
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(identity, () -> fileSystem.open(hadoopPath));
            HdfsParquetDataSource theDataSource = dataSource = new HdfsParquetDataSource(new ParquetDataSourceId(hadoopPath.toString()), fileSize, inputStream, fileFormatDataSourceStats, options);
            ParquetMetadata parquetMetadata = (ParquetMetadata)hdfsEnvironment.doAs(identity, () -> IcebergPageSourceProvider.lambda$createParquetPageSource$25((ParquetDataSource)theDataSource));
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            if (nameMapping.isPresent() && !ParquetSchemaUtil.hasIds((MessageType)fileSchema)) {
                fileSchema = ParquetSchemaUtil.applyNameMapping((MessageType)fileSchema, (NameMapping)IcebergPageSourceProvider.convertToLowercase(nameMapping.get()));
            }
            Map parquetIdToField = (Map)fileSchema.getFields().stream().filter(field -> field.getId() != null).collect(ImmutableMap.toImmutableMap(field -> field.getId().intValue(), Function.identity()));
            Optional<ReaderColumns> columnProjections = IcebergPageSourceProvider.projectColumns(regularColumns);
            List<IcebergColumnHandle> readColumns = columnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(regularColumns);
            List parquetFields = readColumns.stream().map(column -> (org.apache.parquet.schema.Type)parquetIdToField.get(column.getId())).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), (List)parquetFields.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath, (DateTimeZone)DateTimeZone.UTC);
            long nextStart = 0L;
            ImmutableList.Builder blockStarts = ImmutableList.builder();
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (start <= firstDataPage && firstDataPage < start + length && PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain)) {
                    blocks.add(block);
                    blockStarts.add((Object)nextStart);
                }
                nextStart += block.getRowCount();
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), messageColumnIO, blocks, (List)blockStarts.build(), (ParquetDataSource)dataSource, DateTimeZone.UTC, memoryContext, options);
            ConstantPopulatingPageSource.Builder constantPopulatingPageSourceBuilder = ConstantPopulatingPageSource.builder();
            int parquetSourceChannel = 0;
            ImmutableList.Builder trinoTypes = ImmutableList.builder();
            ImmutableList.Builder internalFields = ImmutableList.builder();
            ImmutableList.Builder rowIndexChannels = ImmutableList.builder();
            for (int columnIndex = 0; columnIndex < readColumns.size(); ++columnIndex) {
                IcebergColumnHandle column2 = readColumns.get(columnIndex);
                if (column2.isIsDeletedColumn()) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)BooleanType.BOOLEAN, (Object)false));
                    continue;
                }
                if (partitionKeys.containsKey(column2.getId())) {
                    io.trino.spi.type.Type trinoType = column2.getType();
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column2.getId()).orElse(null), column2.getName())));
                    continue;
                }
                if (column2.isPathColumn()) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)path)));
                    continue;
                }
                if (column2.isFileModifiedTimeColumn()) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime.orElseThrow(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
                    continue;
                }
                if (column2.isUpdateRowIdColumn()) {
                    trinoTypes.add((Object)column2.getType());
                    internalFields.add(Optional.empty());
                    rowIndexChannels.add((Object)false);
                    constantPopulatingPageSourceBuilder.addDelegateColumn(parquetSourceChannel);
                    ++parquetSourceChannel;
                    continue;
                }
                if (column2.isRowPositionColumn()) {
                    trinoTypes.add((Object)BigintType.BIGINT);
                    internalFields.add(Optional.empty());
                    rowIndexChannels.add((Object)true);
                    constantPopulatingPageSourceBuilder.addDelegateColumn(parquetSourceChannel);
                    ++parquetSourceChannel;
                    continue;
                }
                rowIndexChannels.add((Object)false);
                org.apache.parquet.schema.Type parquetField = (org.apache.parquet.schema.Type)parquetFields.get(columnIndex);
                io.trino.spi.type.Type trinoType = column2.getBaseType();
                trinoTypes.add((Object)trinoType);
                if (parquetField == null) {
                    internalFields.add(Optional.empty());
                } else {
                    ColumnIO columnIO = messageColumnIO.getChild(parquetField.getName());
                    internalFields.add(IcebergParquetColumnIOConverter.constructField(new IcebergParquetColumnIOConverter.FieldContext(trinoType, column2.getColumnIdentity()), columnIO));
                }
                constantPopulatingPageSourceBuilder.addDelegateColumn(parquetSourceChannel);
                ++parquetSourceChannel;
            }
            return new ReaderPageSource(constantPopulatingPageSourceBuilder.build((ConnectorPageSource)new ParquetPageSource(parquetReader, (List)trinoTypes.build(), (List)rowIndexChannels.build(), (List)internalFields.build())), columnProjections);
        }
        catch (IOException | RuntimeException e) {
            block20: {
                try {
                    if (dataSource != null) {
                        dataSource.close();
                    }
                }
                catch (IOException ex) {
                    if (e.equals(ex)) break block20;
                    e.addSuppressed(ex);
                }
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", hadoopPath, start, length, e.getMessage());
            if (e instanceof ParquetCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, message, (Throwable)e);
            }
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private ReaderPageSource createAvroPageSource(FileIO fileIo, String path, Path hadoopPath, long start, long length, OptionalLong fileModifiedTime, org.apache.iceberg.Schema fileSchema, Optional<NameMapping> nameMapping, List<IcebergColumnHandle> columns) {
        ReaderPageSource readerPageSource;
        ConstantPopulatingPageSource.Builder constantPopulatingPageSourceBuilder = ConstantPopulatingPageSource.builder();
        int avroSourceChannel = 0;
        Optional<ReaderColumns> columnProjections = IcebergPageSourceProvider.projectColumns(columns);
        List<IcebergColumnHandle> readColumns = columnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(columns);
        DataFileStream avroFileReader = new DataFileStream((InputStream)fileIo.newInputFile(hadoopPath.toString()).newStream(), (DatumReader)new GenericDatumReader());
        try {
            Schema avroSchema = avroFileReader.getSchema();
            List fileFields = avroSchema.getFields();
            if (nameMapping.isPresent() && fileFields.stream().noneMatch(IcebergPageSourceProvider::hasId)) {
                fileFields = (List)fileFields.stream().map(field -> IcebergPageSourceProvider.setMissingFieldId(field, (NameMapping)nameMapping.get(), (List<String>)ImmutableList.of((Object)field.name()))).collect(ImmutableList.toImmutableList());
            }
            Map<Integer, Schema.Field> fileColumnsByIcebergId = IcebergPageSourceProvider.mapIdsToAvroFields(fileFields);
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder rowIndexChannels = ImmutableList.builder();
            for (IcebergColumnHandle column : readColumns) {
                Verify.verify((boolean)column.isBaseColumn(), (String)"Column projections must be based from a root column", (Object[])new Object[0]);
                Schema.Field field2 = fileColumnsByIcebergId.get(column.getId());
                if (column.isPathColumn()) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)path)));
                    continue;
                }
                if (column.isFileModifiedTimeColumn()) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime.orElseThrow(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
                    continue;
                }
                if (column.isRowPositionColumn()) {
                    rowIndexChannels.add((Object)true);
                    columnNames.add((Object)MetadataColumns.ROW_POSITION.name());
                    columnTypes.add((Object)BigintType.BIGINT);
                    constantPopulatingPageSourceBuilder.addDelegateColumn(avroSourceChannel);
                    ++avroSourceChannel;
                    continue;
                }
                if (field2 == null) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)column.getType(), null));
                    continue;
                }
                rowIndexChannels.add((Object)false);
                columnNames.add((Object)column.getName());
                columnTypes.add((Object)column.getType());
                constantPopulatingPageSourceBuilder.addDelegateColumn(avroSourceChannel);
                ++avroSourceChannel;
            }
            readerPageSource = new ReaderPageSource(constantPopulatingPageSourceBuilder.build(new IcebergAvroPageSource(fileIo, hadoopPath.toString(), start, length, fileSchema, nameMapping, (List<String>)columnNames.build(), (List<io.trino.spi.type.Type>)columnTypes.build(), (List<Boolean>)rowIndexChannels.build(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext())), columnProjections);
        }
        catch (Throwable throwable) {
            try {
                try {
                    avroFileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
        }
        avroFileReader.close();
        return readerPageSource;
    }

    private static boolean hasId(Schema.Field field) {
        return AvroSchemaUtil.hasFieldId((Schema.Field)field);
    }

    private static Schema.Field setMissingFieldId(Schema.Field field, NameMapping nameMapping, List<String> qualifiedPath) {
        MappedField mappedField = nameMapping.find(qualifiedPath);
        Schema schema = field.schema();
        if (mappedField != null && mappedField.id() != null) {
            field.addProp(AVRO_FIELD_ID, (Object)mappedField.id());
        }
        return new Schema.Field(field, schema);
    }

    private static Map<Integer, Schema.Field> mapIdsToAvroFields(List<Schema.Field> fields) {
        ImmutableMap.Builder fieldsById = ImmutableMap.builder();
        for (Schema.Field field : fields) {
            if (!AvroSchemaUtil.hasFieldId((Schema.Field)field)) continue;
            fieldsById.put((Object)AvroSchemaUtil.getFieldId((Schema.Field)field), (Object)field);
        }
        return fieldsById.buildOrThrow();
    }

    private static NameMapping convertToLowercase(NameMapping nameMapping) {
        return NameMapping.of(IcebergPageSourceProvider.convertToLowercase(nameMapping.asMappedFields().fields()));
    }

    private static MappedFields convertToLowercase(MappedFields mappedFields) {
        if (mappedFields == null) {
            return null;
        }
        return MappedFields.of(IcebergPageSourceProvider.convertToLowercase(mappedFields.fields()));
    }

    private static List<MappedField> convertToLowercase(List<MappedField> fields) {
        return (List)fields.stream().map(mappedField -> {
            Set lowercaseNames = (Set)mappedField.names().stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            return MappedField.of((Integer)mappedField.id(), (Iterable)lowercaseNames, (MappedFields)IcebergPageSourceProvider.convertToLowercase(mappedField.nestedMapping()));
        }).collect(ImmutableList.toImmutableList());
    }

    public static Optional<ReaderColumns> projectColumns(List<IcebergColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(IcebergColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<Integer, Integer> mappedFieldIds = new HashMap<Integer, Integer>();
        int projectedColumnCount = 0;
        for (IcebergColumnHandle column : columns) {
            int baseColumnId = column.getBaseColumnIdentity().getId();
            Integer mapped = (Integer)mappedFieldIds.get(baseColumnId);
            if (mapped == null) {
                projectedColumns.add((Object)column.getBaseColumn());
                mappedFieldIds.put(baseColumnId, projectedColumnCount);
                outputColumnMapping.add((Object)projectedColumnCount);
                ++projectedColumnCount;
                continue;
            }
            outputColumnMapping.add((Object)mapped);
        }
        return Optional.of(new ReaderColumns((List)projectedColumns.build(), (List)outputColumnMapping.build()));
    }

    private static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<IcebergColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().orElseThrow()).forEach((columnHandle, domain) -> {
            RichColumnDescriptor descriptor;
            String baseType = columnHandle.getType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row") || (descriptor = (RichColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()))) == null)) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    private static TrinoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)exception;
        }
        if (exception instanceof OrcCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }

    private static String hadoopPath(String path) {
        Path hadoopPath = new Path(path);
        if ("s3".equals(hadoopPath.toUri().getScheme()) && !path.equals(hadoopPath.toString())) {
            if (hadoopPath.toUri().getFragment() != null) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "Unexpected URI fragment in path: " + path);
            }
            URI uri = URI.create(path);
            return uri + "#" + URLEncoder.encode(uri.getPath(), StandardCharsets.UTF_8);
        }
        return path;
    }

    private static /* synthetic */ ParquetMetadata lambda$createParquetPageSource$25(ParquetDataSource theDataSource) throws IOException {
        return MetadataReader.readFooter((ParquetDataSource)theDataSource);
    }

    private static class IcebergOrcProjectedLayout
    implements OrcReader.ProjectedLayout {
        private final Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId;

        private IcebergOrcProjectedLayout(Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId) {
            this.projectedLayoutForFieldId = ImmutableMap.copyOf(Objects.requireNonNull(projectedLayoutForFieldId, "projectedLayoutForFieldId is null"));
        }

        public static OrcReader.ProjectedLayout createProjectedLayout(OrcColumn root, List<List<Integer>> fieldIdDereferences) {
            if (fieldIdDereferences.stream().anyMatch(List::isEmpty)) {
                return OrcReader.fullyProjectedLayout();
            }
            Map dereferencesByField = fieldIdDereferences.stream().collect(Collectors.groupingBy(sequence -> (Integer)sequence.get(0), Collectors.mapping(sequence -> sequence.subList(1, sequence.size()), Collectors.toUnmodifiableList())));
            ImmutableMap.Builder fieldLayouts = ImmutableMap.builder();
            for (OrcColumn nestedColumn : root.getNestedColumns()) {
                Integer fieldId = IcebergPageSourceProvider.getIcebergFieldId(nestedColumn);
                if (!dereferencesByField.containsKey(fieldId)) continue;
                fieldLayouts.put((Object)fieldId, (Object)IcebergOrcProjectedLayout.createProjectedLayout(nestedColumn, dereferencesByField.get(fieldId)));
            }
            return new IcebergOrcProjectedLayout((Map<Integer, OrcReader.ProjectedLayout>)fieldLayouts.buildOrThrow());
        }

        public OrcReader.ProjectedLayout getFieldLayout(OrcColumn orcColumn) {
            int fieldId = IcebergPageSourceProvider.getIcebergFieldId(orcColumn);
            return this.projectedLayoutForFieldId.getOrDefault(fieldId, OrcReader.fullyProjectedLayout());
        }
    }

    private static class IdBasedFieldMapperFactory
    implements OrcReader.FieldMapperFactory {
        private final Map<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns;

        public IdBasedFieldMapperFactory(List<IcebergColumnHandle> columns) {
            Objects.requireNonNull(columns, "columns is null");
            ImmutableMap.Builder mapping = ImmutableMap.builder();
            for (IcebergColumnHandle column : columns) {
                if (column.isUpdateRowIdColumn()) continue;
                IdBasedFieldMapperFactory.populateMapping(column.getColumnIdentity(), (ImmutableMap.Builder<Integer, Map<String, Integer>>)mapping);
            }
            this.fieldNameToIdMappingForTableColumns = mapping.buildOrThrow();
        }

        public OrcReader.FieldMapper create(OrcColumn column) {
            ImmutableMap nestedColumns = Maps.uniqueIndex((Iterable)column.getNestedColumns(), x$0 -> IcebergPageSourceProvider.getIcebergFieldId(x$0));
            int icebergId = IcebergPageSourceProvider.getIcebergFieldId(column);
            return new IdBasedFieldMapper((Map<Integer, OrcColumn>)nestedColumns, this.fieldNameToIdMappingForTableColumns.get(icebergId));
        }

        private static void populateMapping(ColumnIdentity identity, ImmutableMap.Builder<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns) {
            List<ColumnIdentity> children = identity.getChildren();
            fieldNameToIdMappingForTableColumns.put((Object)identity.getId(), (Object)((Map)children.stream().collect(ImmutableMap.toImmutableMap(child -> child.getName().toLowerCase(Locale.ENGLISH), ColumnIdentity::getId))));
            for (ColumnIdentity child2 : children) {
                IdBasedFieldMapperFactory.populateMapping(child2, fieldNameToIdMappingForTableColumns);
            }
        }
    }

    private static class IdBasedFieldMapper
    implements OrcReader.FieldMapper {
        private final Map<Integer, OrcColumn> idToColumnMappingForFile;
        private final Map<String, Integer> nameToIdMappingForTableColumns;

        public IdBasedFieldMapper(Map<Integer, OrcColumn> idToColumnMappingForFile, Map<String, Integer> nameToIdMappingForTableColumns) {
            this.idToColumnMappingForFile = Objects.requireNonNull(idToColumnMappingForFile, "idToColumnMappingForFile is null");
            this.nameToIdMappingForTableColumns = Objects.requireNonNull(nameToIdMappingForTableColumns, "nameToIdMappingForTableColumns is null");
        }

        public OrcColumn get(String fieldName) {
            int fieldId = Objects.requireNonNull(this.nameToIdMappingForTableColumns.get(fieldName), () -> String.format("Id mapping for field %s not found", fieldName));
            return this.idToColumnMappingForFile.get(fieldId);
        }
    }
}

