/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.TypeManager;
import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

@Immutable
final class IcebergStatistics {
    private final long recordCount;
    private final long fileCount;
    private final long size;
    private final Map<Integer, Object> minValues;
    private final Map<Integer, Object> maxValues;
    private final Map<Integer, Long> nullCounts;
    private final Map<Integer, Long> nanCounts;
    private final Map<Integer, Long> columnSizes;

    private IcebergStatistics(long recordCount, long fileCount, long size, Map<Integer, Object> minValues, Map<Integer, Object> maxValues, Map<Integer, Long> nullCounts, Map<Integer, Long> nanCounts, Map<Integer, Long> columnSizes) {
        this.recordCount = recordCount;
        this.fileCount = fileCount;
        this.size = size;
        this.minValues = ImmutableMap.copyOf(Objects.requireNonNull(minValues, "minValues is null"));
        this.maxValues = ImmutableMap.copyOf(Objects.requireNonNull(maxValues, "maxValues is null"));
        this.nullCounts = ImmutableMap.copyOf(Objects.requireNonNull(nullCounts, "nullCounts is null"));
        this.nanCounts = ImmutableMap.copyOf(Objects.requireNonNull(nanCounts, "nanCounts is null"));
        this.columnSizes = ImmutableMap.copyOf(Objects.requireNonNull(columnSizes, "columnSizes is null"));
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getSize() {
        return this.size;
    }

    public Map<Integer, Object> getMinValues() {
        return this.minValues;
    }

    public Map<Integer, Object> getMaxValues() {
        return this.maxValues;
    }

    public Map<Integer, Long> getNullCounts() {
        return this.nullCounts;
    }

    public Map<Integer, Long> getNanCounts() {
        return this.nanCounts;
    }

    public Map<Integer, Long> getColumnSizes() {
        return this.columnSizes;
    }

    private static class ColumnStatistics {
        private final MethodHandle comparisonHandle;
        private Optional<Object> min;
        private Optional<Object> max;

        public ColumnStatistics(MethodHandle comparisonHandle, Object initialMin, Object initialMax) {
            this.comparisonHandle = Objects.requireNonNull(comparisonHandle, "comparisonHandle is null");
            this.min = Optional.ofNullable(initialMin);
            this.max = Optional.ofNullable(initialMax);
        }

        public Optional<Object> getMin() {
            return this.min;
        }

        public Optional<Object> getMax() {
            return this.max;
        }

        public void updateMinMax(Object lowerBound, Object upperBound) {
            if (this.min.isPresent()) {
                if (lowerBound == null) {
                    this.min = Optional.empty();
                } else if (this.compareTrinoValue(lowerBound, this.min.get()) < 0L) {
                    this.min = Optional.of(lowerBound);
                }
            }
            if (this.max.isPresent()) {
                if (upperBound == null) {
                    this.max = Optional.empty();
                } else if (this.compareTrinoValue(upperBound, this.max.get()) > 0L) {
                    this.max = Optional.of(upperBound);
                }
            }
        }

        private long compareTrinoValue(Object value, Object otherValue) {
            try {
                return this.comparisonHandle.invoke(value, otherValue);
            }
            catch (Throwable throwable) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to compare Iceberg min/max values", throwable);
            }
        }
    }

    public static class Builder {
        private final List<Types.NestedField> columns;
        private final TypeManager typeManager;
        private final Map<Integer, Optional<Long>> nullCounts = new HashMap<Integer, Optional<Long>>();
        private final Map<Integer, Optional<Long>> nanCounts = new HashMap<Integer, Optional<Long>>();
        private final Map<Integer, ColumnStatistics> columnStatistics = new HashMap<Integer, ColumnStatistics>();
        private final Map<Integer, Long> columnSizes = new HashMap<Integer, Long>();
        private final Map<Integer, io.trino.spi.type.Type> fieldIdToTrinoType;
        private long recordCount;
        private long fileCount;
        private long size;

        public Builder(List<Types.NestedField> columns, TypeManager typeManager) {
            this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.fieldIdToTrinoType = (Map)columns.stream().collect(ImmutableMap.toImmutableMap(Types.NestedField::fieldId, column -> TypeConverter.toTrinoType(column.type(), typeManager)));
        }

        public void acceptDataFile(DataFile dataFile, PartitionSpec partitionSpec) {
            ++this.fileCount;
            this.recordCount += dataFile.recordCount();
            this.size += dataFile.fileSizeInBytes();
            Map newColumnSizes = dataFile.columnSizes();
            if (newColumnSizes != null) {
                for (Types.NestedField column : this.columns) {
                    int id = column.fieldId();
                    Long addedSize = (Long)newColumnSizes.get(id);
                    if (addedSize == null) continue;
                    this.columnSizes.merge(id, addedSize, Long::sum);
                }
            }
            Set identityPartitionFieldIds = (Set)partitionSpec.fields().stream().filter(field -> field.transform().isIdentity()).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet());
            Map<Integer, Optional<String>> partitionValues = IcebergUtil.getPartitionKeys(dataFile.partition(), partitionSpec);
            Optional<Map> nanValueCounts = Optional.ofNullable(dataFile.nanValueCounts());
            for (Types.NestedField column : partitionSpec.schema().columns()) {
                int id = column.fieldId();
                io.trino.spi.type.Type trinoType = this.fieldIdToTrinoType.get(id);
                this.updateNanCountStats(id, nanValueCounts.map(map -> (Long)map.get(id)));
                if (identityPartitionFieldIds.contains(id)) {
                    Verify.verify((boolean)partitionValues.containsKey(id), (String)("Unable to find value for partition column with field id " + id), (Object[])new Object[0]);
                    Optional<String> partitionValue = partitionValues.get(id);
                    if (partitionValue.isPresent()) {
                        Object trinoValue = IcebergUtil.deserializePartitionValue(trinoType, partitionValue.get(), column.name());
                        this.updateMinMaxStats(id, trinoType, trinoValue, trinoValue, Optional.of(0L), dataFile.recordCount());
                        this.updateNullCountStats(id, Optional.of(0L));
                        continue;
                    }
                    this.updateNullCountStats(id, Optional.of(dataFile.recordCount()));
                    continue;
                }
                Object lowerBound = IcebergTypes.convertIcebergValueToTrino(column.type(), Conversions.fromByteBuffer((Type)column.type(), (ByteBuffer)Optional.ofNullable(dataFile.lowerBounds()).map(a -> (ByteBuffer)a.get(id)).orElse(null)));
                Object upperBound = IcebergTypes.convertIcebergValueToTrino(column.type(), Conversions.fromByteBuffer((Type)column.type(), (ByteBuffer)Optional.ofNullable(dataFile.upperBounds()).map(a -> (ByteBuffer)a.get(id)).orElse(null)));
                Optional<Long> nullCount = Optional.ofNullable(dataFile.nullValueCounts()).map(nullCounts -> (Long)nullCounts.get(id));
                this.updateMinMaxStats(id, trinoType, lowerBound, upperBound, nullCount, dataFile.recordCount());
                this.updateNullCountStats(id, nullCount);
            }
        }

        public IcebergStatistics build() {
            ImmutableMap.Builder minValues = ImmutableMap.builder();
            ImmutableMap.Builder maxValues = ImmutableMap.builder();
            this.columnStatistics.forEach((fieldId, statistics) -> {
                statistics.getMin().ifPresent(min -> minValues.put(fieldId, min));
                statistics.getMax().ifPresent(max -> maxValues.put(fieldId, max));
            });
            Map nullCounts = (Map)this.nullCounts.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Long)((Optional)entry.getValue()).orElseThrow()));
            Map nanCounts = (Map)this.nanCounts.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Long)((Optional)entry.getValue()).orElseThrow()));
            return new IcebergStatistics(this.recordCount, this.fileCount, this.size, (Map<Integer, Object>)minValues.buildOrThrow(), (Map<Integer, Object>)maxValues.buildOrThrow(), nullCounts, nanCounts, (Map<Integer, Long>)ImmutableMap.copyOf(this.columnSizes));
        }

        private void updateNullCountStats(int id, Optional<Long> nullCount) {
            this.nullCounts.merge(id, nullCount, (existingCount, newCount) -> existingCount.isPresent() && newCount.isPresent() ? Optional.of((Long)existingCount.get() + (Long)newCount.get()) : Optional.empty());
        }

        private void updateNanCountStats(int id, Optional<Long> nanCount) {
            this.nanCounts.merge(id, nanCount, (existingCount, newCount) -> existingCount.isPresent() && newCount.isPresent() ? Optional.of((Long)existingCount.get() + (Long)newCount.get()) : Optional.empty());
        }

        private void updateMinMaxStats(int id, io.trino.spi.type.Type type, @Nullable Object lowerBound, @Nullable Object upperBound, Optional<Long> nullCount, long recordCount) {
            if (type.isOrderable() && (nullCount.isEmpty() || nullCount.get() != recordCount)) {
                this.columnStatistics.computeIfAbsent(id, ignored -> {
                    MethodHandle comparisonHandle = this.typeManager.getTypeOperators().getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
                    return new ColumnStatistics(comparisonHandle, lowerBound, upperBound);
                }).updateMinMax(lowerBound, upperBound);
            }
        }
    }
}

