/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class IcebergTableProperties {
    public static final String FILE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONING_PROPERTY = "partitioning";
    public static final String LOCATION_PROPERTY = "location";
    public static final String FORMAT_VERSION_PROPERTY = "format_version";
    public static final String ORC_BLOOM_FILTER_COLUMNS = "orc_bloom_filter_columns";
    public static final String ORC_BLOOM_FILTER_FPP = "orc_bloom_filter_fpp";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public IcebergTableProperties(IcebergConfig icebergConfig, OrcWriterConfig orcWriterConfig) {
        this.tableProperties = ImmutableList.builder().add((Object)PropertyMetadata.enumProperty((String)FILE_FORMAT_PROPERTY, (String)"File format for the table", IcebergFileFormat.class, (Enum)icebergConfig.getFileFormat(), (boolean)false)).add((Object)new PropertyMetadata(PARTITIONING_PROPERTY, "Partition transforms", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).add((Object)PropertyMetadata.stringProperty((String)LOCATION_PROPERTY, (String)"File system location URI for the table", null, (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)FORMAT_VERSION_PROPERTY, (String)"Iceberg table format version", (Integer)icebergConfig.getFormatVersion(), IcebergTableProperties::validateFormatVersion, (boolean)false)).add((Object)new PropertyMetadata(ORC_BLOOM_FILTER_COLUMNS, "ORC Bloom filter index columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).add((Object)PropertyMetadata.doubleProperty((String)ORC_BLOOM_FILTER_FPP, (String)"ORC Bloom filter false positive probability", (Double)orcWriterConfig.getDefaultBloomFilterFpp(), IcebergTableProperties::validateOrcBloomFilterFpp, (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static IcebergFileFormat getFileFormat(Map<String, Object> tableProperties) {
        return (IcebergFileFormat)((Object)tableProperties.get(FILE_FORMAT_PROPERTY));
    }

    public static List<String> getPartitioning(Map<String, Object> tableProperties) {
        List partitioning = (List)tableProperties.get(PARTITIONING_PROPERTY);
        return partitioning == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitioning);
    }

    public static Optional<String> getTableLocation(Map<String, Object> tableProperties) {
        return Optional.ofNullable((String)tableProperties.get(LOCATION_PROPERTY));
    }

    public static int getFormatVersion(Map<String, Object> tableProperties) {
        return (Integer)tableProperties.get(FORMAT_VERSION_PROPERTY);
    }

    private static void validateFormatVersion(int version) {
        if (version < 1 || version > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("format_version must be between %d and %d", 1, 2));
        }
    }

    public static List<String> getOrcBloomFilterColumns(Map<String, Object> tableProperties) {
        List orcBloomFilterColumns = (List)tableProperties.get(ORC_BLOOM_FILTER_COLUMNS);
        return orcBloomFilterColumns == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)orcBloomFilterColumns);
    }

    public static Double getOrcBloomFilterFpp(Map<String, Object> tableProperties) {
        return (Double)tableProperties.get(ORC_BLOOM_FILTER_FPP);
    }

    private static void validateOrcBloomFilterFpp(double fpp) {
        if (fpp < 0.0 || fpp > 1.0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Bloom filter fpp value must be between 0.0 and 1.0");
        }
    }
}

