/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IcebergWritableTableHandle
implements ConnectorInsertTableHandle,
ConnectorOutputTableHandle {
    private final SchemaTableName name;
    private final String schemaAsJson;
    private final String partitionSpecAsJson;
    private final List<IcebergColumnHandle> inputColumns;
    private final String outputPath;
    private final IcebergFileFormat fileFormat;
    private final Map<String, String> storageProperties;
    private final RetryMode retryMode;

    @JsonCreator
    public IcebergWritableTableHandle(@JsonProperty(value="name") SchemaTableName name, @JsonProperty(value="schemaAsJson") String schemaAsJson, @JsonProperty(value="partitionSpecAsJson") String partitionSpecAsJson, @JsonProperty(value="inputColumns") List<IcebergColumnHandle> inputColumns, @JsonProperty(value="outputPath") String outputPath, @JsonProperty(value="fileFormat") IcebergFileFormat fileFormat, @JsonProperty(value="properties") Map<String, String> storageProperties, @JsonProperty(value="retryMode") RetryMode retryMode) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.schemaAsJson = Objects.requireNonNull(schemaAsJson, "schemaAsJson is null");
        this.partitionSpecAsJson = Objects.requireNonNull(partitionSpecAsJson, "partitionSpecAsJson is null");
        this.inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        this.outputPath = Objects.requireNonNull(outputPath, "outputPath is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.storageProperties = Objects.requireNonNull(storageProperties, "storageProperties is null");
        this.retryMode = Objects.requireNonNull(retryMode, "retryMode is null");
    }

    @JsonProperty
    public SchemaTableName getName() {
        return this.name;
    }

    @JsonProperty
    public String getSchemaAsJson() {
        return this.schemaAsJson;
    }

    @JsonProperty
    public String getPartitionSpecAsJson() {
        return this.partitionSpecAsJson;
    }

    @JsonProperty
    public List<IcebergColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public String getOutputPath() {
        return this.outputPath;
    }

    @JsonProperty
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public Map<String, String> getStorageProperties() {
        return this.storageProperties;
    }

    @JsonProperty
    public RetryMode getRetryMode() {
        return this.retryMode;
    }

    public String toString() {
        return this.name.toString();
    }
}

