/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergStatistics;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;

public class TableStatisticsMaker {
    private final TypeManager typeManager;
    private final Table icebergTable;

    private TableStatisticsMaker(TypeManager typeManager, Table icebergTable) {
        this.typeManager = typeManager;
        this.icebergTable = icebergTable;
    }

    public static TableStatistics getTableStatistics(TypeManager typeManager, IcebergTableHandle tableHandle, Table icebergTable) {
        return new TableStatisticsMaker(typeManager, icebergTable).makeTableStatistics(tableHandle);
    }

    private TableStatistics makeTableStatistics(IcebergTableHandle tableHandle) {
        if (tableHandle.getSnapshotId().isEmpty()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        TupleDomain<IcebergColumnHandle> enforcedPredicate = tableHandle.getEnforcedPredicate();
        if (enforcedPredicate.isNone()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        Schema icebergTableSchema = this.icebergTable.schema();
        List columns = icebergTableSchema.columns();
        List<IcebergColumnHandle> columnHandles = IcebergUtil.getColumns(icebergTableSchema, this.typeManager);
        Map idToColumnHandle = columnHandles.stream().collect(Collectors.toUnmodifiableMap(IcebergColumnHandle::getId, Function.identity()));
        TableScan tableScan = (TableScan)((TableScan)this.icebergTable.newScan().filter(ExpressionConverter.toIcebergExpression(enforcedPredicate))).useSnapshot(tableHandle.getSnapshotId().get().longValue()).includeColumnStats();
        IcebergStatistics.Builder icebergStatisticsBuilder = new IcebergStatistics.Builder(columns, this.typeManager);
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(fileScanTask -> icebergStatisticsBuilder.acceptDataFile((DataFile)fileScanTask.file(), fileScanTask.spec()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        IcebergStatistics summary = icebergStatisticsBuilder.build();
        if (summary.getFileCount() == 0L) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        ImmutableMap.Builder columnHandleBuilder = ImmutableMap.builder();
        double recordCount = summary.getRecordCount();
        for (IcebergColumnHandle columnHandle : idToColumnHandle.values()) {
            Long columnSize;
            int fieldId = columnHandle.getId();
            ColumnStatistics.Builder columnBuilder = new ColumnStatistics.Builder();
            Long nullCount = summary.getNullCounts().get(fieldId);
            if (nullCount != null) {
                columnBuilder.setNullsFraction(Estimate.of((double)((double)nullCount.longValue() / recordCount)));
            }
            if (summary.getColumnSizes() != null && (columnSize = summary.getColumnSizes().get(fieldId)) != null) {
                columnBuilder.setDataSize(Estimate.of((double)columnSize.longValue()));
            }
            Object min = summary.getMinValues().get(fieldId);
            Object max = summary.getMaxValues().get(fieldId);
            if (min != null && max != null) {
                columnBuilder.setRange(DoubleRange.from((Type)columnHandle.getType(), (Object)min, (Object)max));
            }
            columnHandleBuilder.put((Object)columnHandle, (Object)columnBuilder.build());
        }
        return new TableStatistics(Estimate.of((double)recordCount), (Map)columnHandleBuilder.buildOrThrow());
    }
}

