/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.hive.metastore.DecoratedHiveMetastoreModule;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.SharedHiveMetastoreCache;
import io.trino.plugin.iceberg.CatalogType;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.file.IcebergFileMetastoreCatalogModule;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogModule;
import io.trino.plugin.iceberg.catalog.hms.IcebergHiveMetastoreCatalogModule;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalogFactory;
import java.util.Objects;
import java.util.Optional;

public class IcebergCatalogModule
extends AbstractConfigurationAwareModule {
    private final Optional<HiveMetastore> metastore;

    public IcebergCatalogModule(Optional<HiveMetastore> metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).toInstance((Object)HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastore.get()));
            binder.bind(MetastoreValidator.class).asEagerSingleton();
            this.install((Module)new DecoratedHiveMetastoreModule());
            binder.bind(IcebergTableOperationsProvider.class).to(FileMetastoreTableOperationsProvider.class).in(Scopes.SINGLETON);
            binder.bind(TrinoCatalogFactory.class).to(TrinoHiveCatalogFactory.class).in(Scopes.SINGLETON);
        } else {
            this.bindCatalogModule(CatalogType.HIVE_METASTORE, (Module)new IcebergHiveMetastoreCatalogModule());
            this.bindCatalogModule(CatalogType.TESTING_FILE_METASTORE, (Module)new IcebergFileMetastoreCatalogModule());
            this.bindCatalogModule(CatalogType.GLUE, (Module)new IcebergGlueCatalogModule());
        }
    }

    private void bindCatalogModule(CatalogType catalogType, Module module) {
        this.install(ConditionalModule.conditionalModule(IcebergConfig.class, config -> config.getCatalogType() == catalogType, (Module)module));
    }

    public static class MetastoreValidator {
        @Inject
        public MetastoreValidator(SharedHiveMetastoreCache metastoreCache) {
            if (metastoreCache.isEnabled()) {
                throw new RuntimeException("Hive metastore caching must not be enabled for Iceberg");
            }
        }
    }
}

