/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.file;

import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.iceberg.FileIoProvider;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperations;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class FileMetastoreTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final FileIoProvider fileIoProvider;

    @Inject
    public FileMetastoreTableOperationsProvider(FileIoProvider fileIoProvider) {
        this.fileIoProvider = Objects.requireNonNull(fileIoProvider, "fileIoProvider is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new FileMetastoreTableOperations(this.fileIoProvider.createFileIo(new HdfsEnvironment.HdfsContext(session), session.getQueryId()), ((TrinoHiveCatalog)catalog).getMetastore(), session, database, table, owner, location);
    }
}

