/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glue.AWSGlueAsync;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.iceberg.FileIoProvider;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergTableOperations;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class GlueIcebergTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final FileIoProvider fileIoProvider;
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;

    @Inject
    public GlueIcebergTableOperationsProvider(FileIoProvider fileIoProvider, GlueMetastoreStats stats, GlueHiveMetastoreConfig glueConfig, AWSCredentialsProvider credentialsProvider) {
        this.fileIoProvider = Objects.requireNonNull(fileIoProvider, "fileIoProvider is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(glueConfig, "glueConfig is null");
        Objects.requireNonNull(credentialsProvider, "credentialsProvider is null");
        this.glueClient = GlueHiveMetastore.createAsyncGlueClient((GlueHiveMetastoreConfig)glueConfig, (AWSCredentialsProvider)credentialsProvider, Optional.empty(), (RequestMetricCollector)stats.newRequestMetricsCollector());
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new GlueIcebergTableOperations(this.glueClient, this.stats, this.fileIoProvider.createFileIo(new HdfsEnvironment.HdfsContext(session), session.getQueryId()), session, database, table, owner, location);
    }
}

