/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.glue.AwsSdkUtil;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreApiStats;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.io.FileIO;

public class TrinoGlueCatalog
extends AbstractTrinoCatalog {
    private static final Logger LOG = Logger.get(TrinoGlueCatalog.class);
    private final HdfsEnvironment hdfsEnvironment;
    private final Optional<String> defaultSchemaLocation;
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;
    private final Map<SchemaTableName, TableMetadata> tableMetadataCache = new ConcurrentHashMap<SchemaTableName, TableMetadata>();

    public TrinoGlueCatalog(CatalogName catalogName, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, String trinoVersion, AWSGlueAsync glueClient, GlueMetastoreStats stats, Optional<String> defaultSchemaLocation, boolean useUniqueTableLocation) {
        super(catalogName, typeManager, tableOperationsProvider, trinoVersion, useUniqueTableLocation);
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.defaultSchemaLocation = Objects.requireNonNull(defaultSchemaLocation, "defaultSchemaLocation is null");
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        try {
            return (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getDatabases(arg_0), (Object)new GetDatabasesRequest(), GetDatabasesRequest::setNextToken, GetDatabasesResult::getNextToken, (GlueMetastoreApiStats)this.stats.getGetDatabases()).map(GetDatabasesResult::getDatabaseList).flatMap(Collection::stream).map(Database::getName).collect(ImmutableList.toImmutableList());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        try {
            this.stats.getDeleteDatabase().call(() -> this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(namespace)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        try {
            GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName(namespace);
            Database database = (Database)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(getDatabaseRequest).getDatabase());
            ImmutableMap.Builder metadata = ImmutableMap.builder();
            if (database.getLocationUri() != null) {
                metadata.put((Object)"location", (Object)database.getLocationUri());
            }
            if (database.getParameters() != null) {
                metadata.putAll(database.getParameters());
            }
            return metadata.buildOrThrow();
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((owner.getType() == PrincipalType.USER ? 1 : 0) != 0, (Object)"Owner type must be USER");
        Preconditions.checkArgument((boolean)owner.getName().equals(session.getUser()), (Object)"Explicit schema owner is not supported");
        try {
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(new CreateDatabaseRequest().withDatabaseInput(this.createDatabaseInput(namespace, properties))));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(namespace);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    private DatabaseInput createDatabaseInput(String namespace, Map<String, Object> properties) {
        DatabaseInput databaseInput = new DatabaseInput().withName(namespace);
        Object location = properties.get("location");
        if (location != null) {
            databaseInput.setLocationUri((String)location);
        }
        return databaseInput;
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg Glue catalogs");
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> namespace) {
        ImmutableList.Builder tables = ImmutableList.builder();
        try {
            List namespaces = namespace.map(List::of).orElseGet(() -> this.listNamespaces(session));
            for (String glueNamespace : namespaces) {
                try {
                    tables.addAll((Iterable)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), (Object)new GetTablesRequest().withDatabaseName(glueNamespace), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, (GlueMetastoreApiStats)this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).map(table -> new SchemaTableName(glueNamespace, table.getName())).collect(ImmutableList.toImmutableList()));
                }
                catch (EntityNotFoundException entityNotFoundException) {}
            }
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
        return tables.build();
    }

    @Override
    public Table loadTable(ConnectorSession session, SchemaTableName table) {
        TableMetadata metadata = this.tableMetadataCache.computeIfAbsent(table, ignore -> {
            IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, table.getSchemaName(), table.getTableName(), Optional.empty(), Optional.empty());
            return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table)).operations().current();
        });
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, table, metadata);
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = (BaseTable)this.loadTable(session, schemaTableName);
        IcebergUtil.validateTableCanBeDropped((Table)table);
        try {
            this.deleteTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)table.operations().current());
        this.deleteTableDirectory(session, schemaTableName, this.hdfsEnvironment, new Path(table.location()));
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, String location, Map<String, String> properties) {
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        boolean newTableCreated = false;
        try {
            Optional<com.amazonaws.services.glue.model.Table> table = this.getTable(from);
            if (table.isEmpty()) {
                throw new TableNotFoundException(from);
            }
            TableInput tableInput = GlueIcebergUtil.getTableInput(to.getTableName(), Optional.ofNullable(table.get().getOwner()), table.get().getParameters());
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(to.getSchemaName()).withTableInput(tableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.deleteTable(from.getSchemaName(), from.getTableName());
        }
        catch (RuntimeException e) {
            block6: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(to.getSchemaName(), to.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block6;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    private Optional<com.amazonaws.services.glue.model.Table> getTable(SchemaTableName schemaTableName) {
        try {
            return Optional.of((com.amazonaws.services.glue.model.Table)this.stats.getGetTable().call(() -> this.glueClient.getTable(new GetTableRequest().withDatabaseName(schemaTableName.getSchemaName()).withName(schemaTableName.getTableName())).getTable()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
    }

    private void createTable(String schemaName, TableInput tableInput) {
        this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withDatabaseName(schemaName).withTableInput(tableInput)));
    }

    private void deleteTable(String schema, String table) {
        this.stats.getDeleteTable().call(() -> this.glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(schema).withName(table)));
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        Path location;
        GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName(schemaTableName.getSchemaName());
        String databaseLocation = (String)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(getDatabaseRequest).getDatabase().getLocationUri());
        String tableName = this.createNewTableName(schemaTableName.getTableName());
        if (databaseLocation == null) {
            if (this.defaultSchemaLocation.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Schema '%s' location cannot be determined. Either set the 'location' property when creating the schema, or set the 'hive.metastore.glue.default-warehouse-dir' catalog property.", schemaTableName.getSchemaName()));
            }
            String schemaDirectoryName = schemaTableName.getSchemaName() + ".db";
            location = new Path(new Path(this.defaultSchemaLocation.get(), schemaDirectoryName), tableName);
        } else {
            location = new Path(databaseLocation, tableName);
        }
        return location.toString();
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(schemaViewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)definition), session.getUser(), this.createViewProperties(session));
        Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxRetries(3).withDelay(Duration.ofMillis(100L)).abortIf(throwable -> !replace || throwable instanceof ViewAlreadyExistsException)}).run(() -> this.doCreateView(schemaViewName, viewTableInput, replace));
    }

    private void doCreateView(SchemaTableName schemaViewName, TableInput viewTableInput, boolean replace) {
        Optional<com.amazonaws.services.glue.model.Table> existing = this.getTable(schemaViewName);
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isPrestoView((Map)existing.get().getParameters())) {
                throw new ViewAlreadyExistsException(schemaViewName);
            }
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(schemaViewName.getSchemaName()).withTableInput(viewTableInput)));
            return;
        }
        try {
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withDatabaseName(schemaViewName.getSchemaName()).withTableInput(viewTableInput)));
        }
        catch (AlreadyExistsException e) {
            throw new ViewAlreadyExistsException(schemaViewName);
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            Optional<com.amazonaws.services.glue.model.Table> existingView = this.getTable(source);
            if (existingView.isEmpty()) {
                throw new TableNotFoundException(source);
            }
            TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(target.getTableName(), existingView.get().getViewOriginalText(), existingView.get().getOwner(), this.createViewProperties(session));
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(target.getSchemaName()).withTableInput(viewTableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (Exception e) {
            block6: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (Exception cleanupException) {
                        if (cleanupException.equals(e)) break block6;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        if (this.getView(session, schemaViewName).isEmpty()) {
            throw new ViewNotFoundException(schemaViewName);
        }
        try {
            this.deleteTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        try {
            List namespaces = namespace.map(List::of).orElseGet(() -> this.listNamespaces(session));
            return (List)namespaces.stream().flatMap(glueNamespace -> {
                try {
                    return AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), (Object)new GetTablesRequest().withDatabaseName(glueNamespace), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, (GlueMetastoreApiStats)this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).filter(table -> ViewReaderUtil.isPrestoView((Map)table.getParameters())).map(table -> new SchemaTableName(glueNamespace, table.getName()));
                }
                catch (EntityNotFoundException e) {
                    return Stream.empty();
                }
            }).collect(ImmutableList.toImmutableList());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        Optional<com.amazonaws.services.glue.model.Table> table = this.getTable(viewName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        com.amazonaws.services.glue.model.Table viewDefinition = table.get();
        return this.getView(viewName, Optional.ofNullable(viewDefinition.getViewOriginalText()), viewDefinition.getTableType(), viewDefinition.getParameters(), Optional.ofNullable(viewDefinition.getOwner()));
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        ConnectorViewDefinition definition = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), comment, definition.getOwner(), definition.isRunAsInvoker());
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(viewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)newDefinition), session.getUser(), this.createViewProperties(session));
        try {
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(viewName.getSchemaName()).withTableInput(viewTableInput)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> namespace) {
        try {
            List namespaces = namespace.map(List::of).orElseGet(() -> this.listNamespaces(session));
            return (List)namespaces.stream().flatMap(glueNamespace -> {
                try {
                    return AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), (Object)new GetTablesRequest().withDatabaseName(glueNamespace), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, (GlueMetastoreApiStats)this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).filter(table -> ViewReaderUtil.isTrinoMaterializedView((String)table.getTableType(), (Map)table.getParameters())).map(table -> new SchemaTableName(glueNamespace, table.getName()));
                }
                catch (EntityNotFoundException e) {
                    return Stream.empty();
                }
            }).collect(ImmutableList.toImmutableList());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        Optional<com.amazonaws.services.glue.model.Table> existing = this.getTable(viewName);
        if (existing.isPresent()) {
            if (!ViewReaderUtil.isTrinoMaterializedView((String)existing.get().getTableType(), (Map)existing.get().getParameters())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Existing table is not a Materialized View: " + viewName);
            }
            if (!replace) {
                if (ignoreExisting) {
                    return;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + viewName);
            }
        }
        SchemaTableName storageTable = this.createMaterializedViewStorageTable(session, viewName, definition);
        TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)), session.getUser(), this.createMaterializedViewProperties(session, storageTable));
        if (existing.isPresent()) {
            block10: {
                try {
                    this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(viewName.getSchemaName()).withTableInput(materializedViewTableInput)));
                }
                catch (RuntimeException e) {
                    try {
                        this.dropTable(session, storageTable);
                    }
                    catch (RuntimeException suppressed) {
                        LOG.warn((Throwable)suppressed, "Failed to drop new storage table '%s' for materialized view '%s'", new Object[]{storageTable, viewName});
                        if (e == suppressed) break block10;
                        e.addSuppressed(suppressed);
                    }
                }
            }
            this.dropStorageTable(session, existing.get());
        } else {
            this.createTable(viewName.getSchemaName(), materializedViewTableInput);
        }
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        com.amazonaws.services.glue.model.Table view = this.getTable(viewName).orElseThrow(() -> new MaterializedViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoMaterializedView((String)view.getTableType(), (Map)view.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + view.getDatabaseName() + "." + view.getName());
        }
        this.dropStorageTable(session, view);
        this.deleteTable(view.getDatabaseName(), view.getName());
    }

    private void dropStorageTable(ConnectorSession session, com.amazonaws.services.glue.model.Table view) {
        String storageTableName = (String)view.getParameters().get("storage_table");
        if (storageTableName != null) {
            String storageSchema = Optional.ofNullable((String)view.getParameters().get("storage_schema")).orElse(view.getDatabaseName());
            try {
                this.dropTable(session, new SchemaTableName(storageSchema, storageTableName));
            }
            catch (TrinoException e) {
                LOG.warn((Throwable)e, "Failed to drop storage table '%s.%s' for materialized view '%s'", new Object[]{storageSchema, storageTableName, view.getName()});
            }
        }
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        Table icebergTable;
        Optional<com.amazonaws.services.glue.model.Table> maybeTable = this.getTable(viewName);
        if (maybeTable.isEmpty()) {
            return Optional.empty();
        }
        com.amazonaws.services.glue.model.Table table = maybeTable.get();
        if (!ViewReaderUtil.isTrinoMaterializedView((String)table.getTableType(), (Map)table.getParameters())) {
            return Optional.empty();
        }
        Map materializedViewParameters = table.getParameters();
        String storageTable = (String)materializedViewParameters.get("storage_table");
        Preconditions.checkState((storageTable != null ? 1 : 0) != 0, (Object)("Storage table missing in definition of materialized view " + viewName));
        String storageSchema = Optional.ofNullable((String)materializedViewParameters.get("storage_schema")).orElse(viewName.getSchemaName());
        SchemaTableName storageTableName = new SchemaTableName(storageSchema, storageTable);
        try {
            icebergTable = this.loadTable(session, storageTableName);
        }
        catch (RuntimeException e) {
            throw new AbstractTrinoCatalog.MaterializedViewMayBeBeingRemovedException(e);
        }
        String viewOriginalText = table.getViewOriginalText();
        if (viewOriginalText == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Materialized view did not have original text " + viewName);
        }
        return Optional.of(this.getMaterializedViewDefinition(icebergTable, Optional.ofNullable(table.getOwner()), viewOriginalText, storageTableName));
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            Optional<com.amazonaws.services.glue.model.Table> table = this.getTable(source);
            if (table.isEmpty()) {
                throw new TableNotFoundException(source);
            }
            com.amazonaws.services.glue.model.Table glueTable = table.get();
            if (!ViewReaderUtil.isTrinoMaterializedView((String)glueTable.getTableType(), (Map)glueTable.getParameters())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + source);
            }
            TableInput tableInput = GlueIcebergUtil.getMaterializedViewTableInput(target.getTableName(), glueTable.getViewOriginalText(), glueTable.getOwner(), glueTable.getParameters());
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(target.getSchemaName()).withTableInput(tableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (RuntimeException e) {
            block7: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block7;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<String> targetCatalogName = IcebergSessionProperties.getHiveCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional<com.amazonaws.services.glue.model.Table> table = this.getTable(new SchemaTableName(tableNameBase.getSchemaName(), tableNameBase.getTableName()));
        if (table.isEmpty() || TableType.VIRTUAL_VIEW.name().equals(table.get().getTableType())) {
            return Optional.empty();
        }
        if (!HiveUtil.isIcebergTable((Map)table.get().getParameters())) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, tableName));
        }
        return Optional.empty();
    }
}

