/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.iceberg.FileIoProvider;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.hms.HiveMetastoreTableOperations;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class HiveMetastoreTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final FileIoProvider fileIoProvider;
    private final ThriftMetastoreFactory thriftMetastoreFactory;

    @Inject
    public HiveMetastoreTableOperationsProvider(FileIoProvider fileIoProvider, ThriftMetastoreFactory thriftMetastoreFactory) {
        this.fileIoProvider = Objects.requireNonNull(fileIoProvider, "fileIoProvider is null");
        this.thriftMetastoreFactory = Objects.requireNonNull(thriftMetastoreFactory, "thriftMetastoreFactory is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new HiveMetastoreTableOperations(this.fileIoProvider.createFileIo(new HdfsEnvironment.HdfsContext(session), session.getQueryId()), ((TrinoHiveCatalog)catalog).getMetastore(), this.thriftMetastoreFactory.createMetastore(Optional.of(session.getIdentity())), session, database, table, owner, location);
    }
}

