/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergSecurityConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class TrinoHiveCatalogFactory
implements TrinoCatalogFactory {
    private final CatalogName catalogName;
    private final HiveMetastoreFactory metastoreFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final String trinoVersion;
    private final boolean isUniqueTableLocation;
    private final boolean isUsingSystemSecurity;
    private final boolean deleteSchemaLocationsFallback;

    @Inject
    public TrinoHiveCatalogFactory(IcebergConfig config, CatalogName catalogName, HiveMetastoreFactory metastoreFactory, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, NodeVersion nodeVersion, IcebergSecurityConfig securityConfig) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationProvider is null");
        this.trinoVersion = Objects.requireNonNull(nodeVersion, "trinoVersion is null").toString();
        Objects.requireNonNull(config, "config is null");
        this.isUniqueTableLocation = config.isUniqueTableLocation();
        Objects.requireNonNull(securityConfig, "securityConfig is null");
        this.isUsingSystemSecurity = securityConfig.getSecuritySystem() == IcebergSecurityConfig.IcebergSecurity.SYSTEM;
        this.deleteSchemaLocationsFallback = config.isDeleteSchemaLocationsFallback();
    }

    @Override
    public TrinoCatalog create(ConnectorIdentity identity) {
        return new TrinoHiveCatalog(this.catalogName, CachingHiveMetastore.memoizeMetastore((HiveMetastore)this.metastoreFactory.createMetastore(Optional.of(identity)), (long)1000L), this.hdfsEnvironment, this.typeManager, this.tableOperationsProvider, this.trinoVersion, this.isUniqueTableLocation, this.isUsingSystemSecurity, this.deleteSchemaLocationsFallback);
    }
}

