/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Preconditions;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.spi.type.DecimalType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;

public final class ParquetTypeUtils {
    private ParquetTypeUtils() {
    }

    public static List<PrimitiveColumnIO> getColumns(MessageType fileSchema, MessageType requestedSchema) {
        return new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true).getLeaves();
    }

    public static MessageColumnIO getColumnIO(MessageType fileSchema, MessageType requestedSchema) {
        return new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true);
    }

    public static GroupColumnIO getMapKeyValueColumn(GroupColumnIO groupColumnIO) {
        while (groupColumnIO.getChildrenCount() == 1) {
            groupColumnIO = (GroupColumnIO)groupColumnIO.getChild(0);
        }
        return groupColumnIO;
    }

    public static ColumnIO getArrayElementColumn(ColumnIO columnIO) {
        while (columnIO instanceof GroupColumnIO && !columnIO.getType().isRepetition(Type.Repetition.REPEATED)) {
            columnIO = ((GroupColumnIO)columnIO).getChild(0);
        }
        if (columnIO instanceof GroupColumnIO && columnIO.getType().getOriginalType() == null && ((GroupColumnIO)columnIO).getChildrenCount() == 1 && !columnIO.getName().equals("array") && !columnIO.getName().equals(columnIO.getParent().getName() + "_tuple")) {
            return ((GroupColumnIO)columnIO).getChild(0);
        }
        return columnIO;
    }

    public static Map<List<String>, RichColumnDescriptor> getDescriptors(MessageType fileSchema, MessageType requestedSchema) {
        HashMap<List<String>, RichColumnDescriptor> descriptorsByPath = new HashMap<List<String>, RichColumnDescriptor>();
        List<PrimitiveColumnIO> columns = ParquetTypeUtils.getColumns(fileSchema, requestedSchema);
        for (String[] paths : fileSchema.getPaths()) {
            List<String> columnPath = Arrays.asList(paths);
            ParquetTypeUtils.getDescriptor(columns, columnPath).ifPresent(richColumnDescriptor -> descriptorsByPath.put(columnPath, (RichColumnDescriptor)((Object)richColumnDescriptor)));
        }
        return descriptorsByPath;
    }

    public static Optional<RichColumnDescriptor> getDescriptor(List<PrimitiveColumnIO> columns, List<String> path) {
        Preconditions.checkArgument((path.size() >= 1 ? 1 : 0) != 0, (Object)"Parquet nested path should have at least one component");
        int index = ParquetTypeUtils.getPathIndex(columns, path);
        if (index == -1) {
            return Optional.empty();
        }
        PrimitiveColumnIO columnIO = columns.get(index);
        return Optional.of(new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType()));
    }

    private static int getPathIndex(List<PrimitiveColumnIO> columns, List<String> path) {
        int maxLevel = path.size();
        int index = -1;
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            ColumnIO[] fields = columns.get(columnIndex).getPath();
            if (fields.length <= maxLevel || !fields[maxLevel].getName().equalsIgnoreCase(path.get(maxLevel - 1))) continue;
            boolean match = true;
            for (int level = 0; level < maxLevel - 1; ++level) {
                if (fields[level + 1].getName().equalsIgnoreCase(path.get(level))) continue;
                match = false;
            }
            if (!match) continue;
            index = columnIndex;
        }
        return index;
    }

    public static ParquetEncoding getParquetEncoding(Encoding encoding) {
        switch (encoding) {
            case PLAIN: {
                return ParquetEncoding.PLAIN;
            }
            case RLE: {
                return ParquetEncoding.RLE;
            }
            case BYTE_STREAM_SPLIT: {
                throw new ParquetDecodingException("Unsupported Parquet encoding: " + encoding);
            }
            case BIT_PACKED: {
                return ParquetEncoding.BIT_PACKED;
            }
            case PLAIN_DICTIONARY: {
                return ParquetEncoding.PLAIN_DICTIONARY;
            }
            case DELTA_BINARY_PACKED: {
                return ParquetEncoding.DELTA_BINARY_PACKED;
            }
            case DELTA_LENGTH_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY;
            }
            case DELTA_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_BYTE_ARRAY;
            }
            case RLE_DICTIONARY: {
                return ParquetEncoding.RLE_DICTIONARY;
            }
        }
        throw new ParquetDecodingException("Unsupported Parquet encoding: " + encoding);
    }

    public static Type getParquetTypeByName(String columnName, GroupType groupType) {
        if (groupType.containsField(columnName)) {
            return groupType.getType(columnName);
        }
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(columnName)) continue;
            return type;
        }
        return null;
    }

    public static ColumnIO lookupColumnByName(GroupColumnIO groupColumnIO, String columnName) {
        ColumnIO columnIO = groupColumnIO.getChild(columnName);
        if (columnIO != null) {
            return columnIO;
        }
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            if (!groupColumnIO.getChild(i).getName().equalsIgnoreCase(columnName)) continue;
            return groupColumnIO.getChild(i);
        }
        return null;
    }

    @Nullable
    public static ColumnIO lookupColumnById(GroupColumnIO groupColumnIO, int columnId) {
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            ColumnIO child = groupColumnIO.getChild(i);
            if (child.getType().getId().intValue() != columnId) continue;
            return child;
        }
        return null;
    }

    public static Optional<DecimalType> createDecimalType(RichColumnDescriptor descriptor) {
        if (descriptor.getPrimitiveType().getOriginalType() != OriginalType.DECIMAL) {
            return Optional.empty();
        }
        DecimalMetadata decimalMetadata = descriptor.getPrimitiveType().getDecimalMetadata();
        return Optional.of(DecimalType.createDecimalType((int)decimalMetadata.getPrecision(), (int)decimalMetadata.getScale()));
    }

    public static boolean isValueNull(boolean required, int definitionLevel, int maxDefinitionLevel) {
        return !required && definitionLevel == maxDefinitionLevel - 1;
    }

    public static long getShortDecimalValue(byte[] bytes) {
        return ParquetTypeUtils.getShortDecimalValue(bytes, 0, bytes.length);
    }

    public static long getShortDecimalValue(byte[] bytes, int startOffset, int length) {
        int i;
        long value = 0L;
        if (bytes[startOffset] < 0) {
            for (i = 0; i < 8 - length; ++i) {
                value |= 255L << 8 * (7 - i);
            }
        }
        for (i = 0; i < length; ++i) {
            value |= ((long)bytes[startOffset + length - i - 1] & 0xFFL) << 8 * i;
        }
        return value;
    }
}

