/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import org.apache.parquet.io.api.Binary;

public class BinaryColumnReader
extends PrimitiveColumnReader {
    public BinaryColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        Binary binary = this.valuesReader.readBytes();
        Slice value = binary.length() == 0 ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])binary.getBytes());
        if (type instanceof VarcharType) {
            value = Varchars.truncateToLength((Slice)value, (Type)type);
        }
        if (type instanceof CharType) {
            value = Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type);
        }
        type.writeSlice(blockBuilder, value);
    }
}

