/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.trino2rel.parsetree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.linkedin.coral.common.HiveTypeSystem;
import com.linkedin.coral.common.calcite.CalciteUtil;
import com.linkedin.coral.trino.trino2rel.parsetree.ParserVisitorContext;
import com.linkedin.coral.trino.trino2rel.parsetree.UnhandledASTNodeException;
import coral.shading.io.trino.sql.tree.AddColumn;
import coral.shading.io.trino.sql.tree.AliasedRelation;
import coral.shading.io.trino.sql.tree.AllColumns;
import coral.shading.io.trino.sql.tree.AllRows;
import coral.shading.io.trino.sql.tree.Analyze;
import coral.shading.io.trino.sql.tree.ArithmeticBinaryExpression;
import coral.shading.io.trino.sql.tree.ArithmeticUnaryExpression;
import coral.shading.io.trino.sql.tree.ArrayConstructor;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.AtTimeZone;
import coral.shading.io.trino.sql.tree.BetweenPredicate;
import coral.shading.io.trino.sql.tree.BinaryLiteral;
import coral.shading.io.trino.sql.tree.BindExpression;
import coral.shading.io.trino.sql.tree.BooleanLiteral;
import coral.shading.io.trino.sql.tree.Call;
import coral.shading.io.trino.sql.tree.CallArgument;
import coral.shading.io.trino.sql.tree.Cast;
import coral.shading.io.trino.sql.tree.CharLiteral;
import coral.shading.io.trino.sql.tree.CoalesceExpression;
import coral.shading.io.trino.sql.tree.ColumnDefinition;
import coral.shading.io.trino.sql.tree.Comment;
import coral.shading.io.trino.sql.tree.Commit;
import coral.shading.io.trino.sql.tree.ComparisonExpression;
import coral.shading.io.trino.sql.tree.CreateMaterializedView;
import coral.shading.io.trino.sql.tree.CreateRole;
import coral.shading.io.trino.sql.tree.CreateSchema;
import coral.shading.io.trino.sql.tree.CreateTable;
import coral.shading.io.trino.sql.tree.CreateTableAsSelect;
import coral.shading.io.trino.sql.tree.CreateView;
import coral.shading.io.trino.sql.tree.Cube;
import coral.shading.io.trino.sql.tree.CurrentPath;
import coral.shading.io.trino.sql.tree.CurrentTime;
import coral.shading.io.trino.sql.tree.CurrentUser;
import coral.shading.io.trino.sql.tree.DateTimeDataType;
import coral.shading.io.trino.sql.tree.Deallocate;
import coral.shading.io.trino.sql.tree.DecimalLiteral;
import coral.shading.io.trino.sql.tree.Delete;
import coral.shading.io.trino.sql.tree.DereferenceExpression;
import coral.shading.io.trino.sql.tree.DescribeInput;
import coral.shading.io.trino.sql.tree.DescribeOutput;
import coral.shading.io.trino.sql.tree.DoubleLiteral;
import coral.shading.io.trino.sql.tree.DropColumn;
import coral.shading.io.trino.sql.tree.DropMaterializedView;
import coral.shading.io.trino.sql.tree.DropRole;
import coral.shading.io.trino.sql.tree.DropSchema;
import coral.shading.io.trino.sql.tree.DropTable;
import coral.shading.io.trino.sql.tree.DropView;
import coral.shading.io.trino.sql.tree.Except;
import coral.shading.io.trino.sql.tree.Execute;
import coral.shading.io.trino.sql.tree.ExistsPredicate;
import coral.shading.io.trino.sql.tree.Explain;
import coral.shading.io.trino.sql.tree.ExplainOption;
import coral.shading.io.trino.sql.tree.Extract;
import coral.shading.io.trino.sql.tree.FetchFirst;
import coral.shading.io.trino.sql.tree.FieldReference;
import coral.shading.io.trino.sql.tree.Format;
import coral.shading.io.trino.sql.tree.FrameBound;
import coral.shading.io.trino.sql.tree.FunctionCall;
import coral.shading.io.trino.sql.tree.GenericDataType;
import coral.shading.io.trino.sql.tree.GenericLiteral;
import coral.shading.io.trino.sql.tree.Grant;
import coral.shading.io.trino.sql.tree.GrantRoles;
import coral.shading.io.trino.sql.tree.GroupBy;
import coral.shading.io.trino.sql.tree.GroupingOperation;
import coral.shading.io.trino.sql.tree.GroupingSets;
import coral.shading.io.trino.sql.tree.Identifier;
import coral.shading.io.trino.sql.tree.IfExpression;
import coral.shading.io.trino.sql.tree.InListExpression;
import coral.shading.io.trino.sql.tree.InPredicate;
import coral.shading.io.trino.sql.tree.Insert;
import coral.shading.io.trino.sql.tree.Intersect;
import coral.shading.io.trino.sql.tree.IntervalDayTimeDataType;
import coral.shading.io.trino.sql.tree.IntervalLiteral;
import coral.shading.io.trino.sql.tree.IsNotNullPredicate;
import coral.shading.io.trino.sql.tree.IsNullPredicate;
import coral.shading.io.trino.sql.tree.Isolation;
import coral.shading.io.trino.sql.tree.Join;
import coral.shading.io.trino.sql.tree.JoinCriteria;
import coral.shading.io.trino.sql.tree.JoinOn;
import coral.shading.io.trino.sql.tree.JoinUsing;
import coral.shading.io.trino.sql.tree.LambdaArgumentDeclaration;
import coral.shading.io.trino.sql.tree.LambdaExpression;
import coral.shading.io.trino.sql.tree.Lateral;
import coral.shading.io.trino.sql.tree.LikeClause;
import coral.shading.io.trino.sql.tree.LikePredicate;
import coral.shading.io.trino.sql.tree.Limit;
import coral.shading.io.trino.sql.tree.LogicalBinaryExpression;
import coral.shading.io.trino.sql.tree.LongLiteral;
import coral.shading.io.trino.sql.tree.Merge;
import coral.shading.io.trino.sql.tree.MergeDelete;
import coral.shading.io.trino.sql.tree.MergeInsert;
import coral.shading.io.trino.sql.tree.MergeUpdate;
import coral.shading.io.trino.sql.tree.NaturalJoin;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.NotExpression;
import coral.shading.io.trino.sql.tree.NullIfExpression;
import coral.shading.io.trino.sql.tree.NullLiteral;
import coral.shading.io.trino.sql.tree.NumericParameter;
import coral.shading.io.trino.sql.tree.Offset;
import coral.shading.io.trino.sql.tree.OrderBy;
import coral.shading.io.trino.sql.tree.Parameter;
import coral.shading.io.trino.sql.tree.PathElement;
import coral.shading.io.trino.sql.tree.PathSpecification;
import coral.shading.io.trino.sql.tree.Prepare;
import coral.shading.io.trino.sql.tree.Property;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.QuantifiedComparisonExpression;
import coral.shading.io.trino.sql.tree.Query;
import coral.shading.io.trino.sql.tree.QuerySpecification;
import coral.shading.io.trino.sql.tree.RefreshMaterializedView;
import coral.shading.io.trino.sql.tree.RenameColumn;
import coral.shading.io.trino.sql.tree.RenameSchema;
import coral.shading.io.trino.sql.tree.RenameTable;
import coral.shading.io.trino.sql.tree.RenameView;
import coral.shading.io.trino.sql.tree.ResetSession;
import coral.shading.io.trino.sql.tree.Revoke;
import coral.shading.io.trino.sql.tree.RevokeRoles;
import coral.shading.io.trino.sql.tree.Rollback;
import coral.shading.io.trino.sql.tree.Rollup;
import coral.shading.io.trino.sql.tree.Row;
import coral.shading.io.trino.sql.tree.RowDataType;
import coral.shading.io.trino.sql.tree.SampledRelation;
import coral.shading.io.trino.sql.tree.SearchedCaseExpression;
import coral.shading.io.trino.sql.tree.Select;
import coral.shading.io.trino.sql.tree.SetPath;
import coral.shading.io.trino.sql.tree.SetRole;
import coral.shading.io.trino.sql.tree.SetSchemaAuthorization;
import coral.shading.io.trino.sql.tree.SetSession;
import coral.shading.io.trino.sql.tree.SetTableAuthorization;
import coral.shading.io.trino.sql.tree.SetViewAuthorization;
import coral.shading.io.trino.sql.tree.ShowCatalogs;
import coral.shading.io.trino.sql.tree.ShowColumns;
import coral.shading.io.trino.sql.tree.ShowCreate;
import coral.shading.io.trino.sql.tree.ShowFunctions;
import coral.shading.io.trino.sql.tree.ShowGrants;
import coral.shading.io.trino.sql.tree.ShowRoleGrants;
import coral.shading.io.trino.sql.tree.ShowRoles;
import coral.shading.io.trino.sql.tree.ShowSchemas;
import coral.shading.io.trino.sql.tree.ShowSession;
import coral.shading.io.trino.sql.tree.ShowStats;
import coral.shading.io.trino.sql.tree.ShowTables;
import coral.shading.io.trino.sql.tree.SimpleCaseExpression;
import coral.shading.io.trino.sql.tree.SimpleGroupBy;
import coral.shading.io.trino.sql.tree.SingleColumn;
import coral.shading.io.trino.sql.tree.SortItem;
import coral.shading.io.trino.sql.tree.StartTransaction;
import coral.shading.io.trino.sql.tree.StringLiteral;
import coral.shading.io.trino.sql.tree.SubqueryExpression;
import coral.shading.io.trino.sql.tree.SubscriptExpression;
import coral.shading.io.trino.sql.tree.SymbolReference;
import coral.shading.io.trino.sql.tree.Table;
import coral.shading.io.trino.sql.tree.TableSubquery;
import coral.shading.io.trino.sql.tree.TimeLiteral;
import coral.shading.io.trino.sql.tree.TimestampLiteral;
import coral.shading.io.trino.sql.tree.TransactionAccessMode;
import coral.shading.io.trino.sql.tree.TransactionMode;
import coral.shading.io.trino.sql.tree.TryExpression;
import coral.shading.io.trino.sql.tree.TypeParameter;
import coral.shading.io.trino.sql.tree.Union;
import coral.shading.io.trino.sql.tree.Unnest;
import coral.shading.io.trino.sql.tree.Update;
import coral.shading.io.trino.sql.tree.UpdateAssignment;
import coral.shading.io.trino.sql.tree.Use;
import coral.shading.io.trino.sql.tree.Values;
import coral.shading.io.trino.sql.tree.WhenClause;
import coral.shading.io.trino.sql.tree.Window;
import coral.shading.io.trino.sql.tree.WindowDefinition;
import coral.shading.io.trino.sql.tree.WindowFrame;
import coral.shading.io.trino.sql.tree.WindowReference;
import coral.shading.io.trino.sql.tree.WindowSpecification;
import coral.shading.io.trino.sql.tree.With;
import coral.shading.io.trino.sql.tree.WithQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlArrayTypeSpec;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMapTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.commons.lang3.ObjectUtils;

public class ParseTreeBuilder
extends AstVisitor<SqlNode, ParserVisitorContext> {
    private static final String UNSUPPORTED_EXCEPTION_MSG = "%s at line %d column %d is not supported in the visit.";
    private static final String DDL_NOT_SUPPORT_MSG = "DDL %s at line %d column %d is not supported.";
    private static final String LAMBDA_NOT_SUPPORT_MSG = "Lambda expression %s at line %d column %d is not supported.";
    private static final ImmutableMap<Join.Type, JoinType> JOIN_TYPE_MAP = ImmutableMap.of((Object)Join.Type.LEFT, (Object)JoinType.LEFT, (Object)Join.Type.RIGHT, (Object)JoinType.RIGHT, (Object)Join.Type.FULL, (Object)JoinType.FULL, (Object)Join.Type.INNER, (Object)JoinType.INNER, (Object)Join.Type.CROSS, (Object)JoinType.CROSS);
    private static final ImmutableMap<String, TimeUnit> TIME_UNIT_MAP = ImmutableMap.builder().put((Object)Extract.Field.YEAR.name(), (Object)TimeUnit.YEAR).put((Object)Extract.Field.QUARTER.name(), (Object)TimeUnit.QUARTER).put((Object)Extract.Field.MONTH.name(), (Object)TimeUnit.MONTH).put((Object)Extract.Field.WEEK.name(), (Object)TimeUnit.WEEK).put((Object)Extract.Field.DAY.name(), (Object)TimeUnit.DAY).put((Object)Extract.Field.DAY_OF_MONTH.name(), (Object)TimeUnit.DAY).put((Object)Extract.Field.DAY_OF_WEEK.name(), (Object)TimeUnit.DOW).put((Object)Extract.Field.DOW.name(), (Object)TimeUnit.DOW).put((Object)Extract.Field.DAY_OF_YEAR.name(), (Object)TimeUnit.DOY).put((Object)Extract.Field.DOY.name(), (Object)TimeUnit.DOY).put((Object)Extract.Field.HOUR.name(), (Object)TimeUnit.HOUR).put((Object)Extract.Field.MINUTE.name(), (Object)TimeUnit.MINUTE).put((Object)Extract.Field.SECOND.name(), (Object)TimeUnit.SECOND).build();
    private static final ImmutableMap<String, SqlOperator> OPERATOR_MAP = ImmutableMap.builder().put((Object)ArithmeticBinaryExpression.Operator.ADD.getValue(), (Object)SqlStdOperatorTable.PLUS).put((Object)ArithmeticBinaryExpression.Operator.DIVIDE.getValue(), (Object)SqlStdOperatorTable.DIVIDE).put((Object)ArithmeticBinaryExpression.Operator.SUBTRACT.getValue(), (Object)SqlStdOperatorTable.MINUS).put((Object)ArithmeticBinaryExpression.Operator.MULTIPLY.getValue(), (Object)SqlStdOperatorTable.MULTIPLY).put((Object)ArithmeticBinaryExpression.Operator.MODULUS.getValue(), (Object)SqlStdOperatorTable.PERCENT_REMAINDER).put((Object)ComparisonExpression.Operator.EQUAL.getValue(), (Object)SqlStdOperatorTable.EQUALS).put((Object)ComparisonExpression.Operator.LESS_THAN.getValue(), (Object)SqlStdOperatorTable.LESS_THAN).put((Object)ComparisonExpression.Operator.LESS_THAN_OR_EQUAL.getValue(), (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL).put((Object)ComparisonExpression.Operator.GREATER_THAN.getValue(), (Object)SqlStdOperatorTable.GREATER_THAN).put((Object)ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL.getValue(), (Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL).put((Object)ComparisonExpression.Operator.NOT_EQUAL.getValue(), (Object)SqlStdOperatorTable.NOT_EQUALS).put((Object)ComparisonExpression.Operator.IS_DISTINCT_FROM.getValue(), (Object)SqlStdOperatorTable.IS_DISTINCT_FROM).build();
    private static final ImmutableMap<ComparisonExpression.Operator, SqlOperator> ALL_COMPARISON_OPERATOR = ImmutableMap.builder().put((Object)ComparisonExpression.Operator.EQUAL, (Object)SqlStdOperatorTable.ALL_EQ).put((Object)ComparisonExpression.Operator.NOT_EQUAL, (Object)SqlStdOperatorTable.ALL_NE).put((Object)ComparisonExpression.Operator.LESS_THAN, (Object)SqlStdOperatorTable.ALL_LT).put((Object)ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.ALL_LE).put((Object)ComparisonExpression.Operator.GREATER_THAN, (Object)SqlStdOperatorTable.ALL_GT).put((Object)ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.ALL_GE).build();
    private static final ImmutableMap<ComparisonExpression.Operator, SqlOperator> SOME_COMPARISON_OPERATOR = ImmutableMap.builder().put((Object)ComparisonExpression.Operator.EQUAL, (Object)SqlStdOperatorTable.SOME_EQ).put((Object)ComparisonExpression.Operator.NOT_EQUAL, (Object)SqlStdOperatorTable.SOME_NE).put((Object)ComparisonExpression.Operator.LESS_THAN, (Object)SqlStdOperatorTable.SOME_LT).put((Object)ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.SOME_LE).put((Object)ComparisonExpression.Operator.GREATER_THAN, (Object)SqlStdOperatorTable.SOME_GT).put((Object)ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.SOME_GE).build();
    private static final ImmutableSet<SqlKind> NULL_CARED_OPERATOR = ImmutableSet.of((Object)SqlKind.FIRST_VALUE, (Object)SqlKind.LAST_VALUE, (Object)SqlKind.LEAD, (Object)SqlKind.LAG);
    private final SqlTypeFactoryImpl sqlTypeFactory = new SqlTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystem());

    private SqlParserPos getPos(Node node) {
        if (node.getLocation().isPresent()) {
            return new SqlParserPos(((NodeLocation)node.getLocation().get()).getLineNumber(), ((NodeLocation)node.getLocation().get()).getColumnNumber());
        }
        return SqlParserPos.ZERO;
    }

    private SqlNode processOptional(Optional<? extends Node> node, ParserVisitorContext context) {
        return node.map(value -> (SqlNode)this.process((Node)value, context)).orElse(null);
    }

    private List<SqlNode> getChildren(Node node, ParserVisitorContext context) {
        return this.toListOfSqlNode(node.getChildren(), context);
    }

    private SqlNodeList getChildSqlNodeList(Node node, ParserVisitorContext context) {
        return new SqlNodeList(this.getChildren(node, context), this.getPos(node));
    }

    private List<SqlNode> toListOfSqlNode(List<? extends Node> nodes, ParserVisitorContext context) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        return nodes.stream().map(n -> (SqlNode)this.process((Node)n, context)).collect(Collectors.toList());
    }

    private SqlNodeList toSqlNodeList(List<? extends Node> nodes, ParserVisitorContext context, SqlParserPos pos) {
        return CalciteUtil.createSqlNodeList(this.toListOfSqlNode(nodes, context), (SqlParserPos)pos);
    }

    private SqlNode parseExpression(String expression) {
        try {
            return CalciteUtil.parseStatement((String)expression);
        }
        catch (SqlParseException e) {
            throw new RuntimeException(String.format("Failed to parse the expression %s.", expression), e);
        }
    }

    private SqlIdentifier convertQualifiedName(QualifiedName name, SqlParserPos pos) {
        return CalciteUtil.createSqlIdentifier((SqlParserPos)pos, (String[])new ArrayList(name.getOriginalParts().stream().map(Identifier::getValue).collect(Collectors.toList())).toArray(new String[0]));
    }

    private SqlCall getUnresolvedFunction(String functionName, List<SqlNode> operands) {
        SqlIdentifier functionIdentifier = CalciteUtil.createSqlIdentifier((SqlParserPos)SqlParserPos.ZERO, (String[])new String[]{functionName});
        return CalciteUtil.createCall((SqlOperator)new SqlUnresolvedFunction(functionIdentifier, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), operands);
    }

    private SqlCall getCall(SqlOperator operator, Node node, ParserVisitorContext context) {
        if (operator == null) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return operator.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    protected SqlNode visitCurrentTime(CurrentTime node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos((Node)node);
        switch (node.getFunction()) {
            case TIME: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, Collections.emptyList(), (SqlParserPos)pos);
            }
            case DATE: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, Collections.emptyList(), (SqlParserPos)pos);
            }
            case LOCALTIME: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.LOCALTIME, Collections.emptyList(), (SqlParserPos)pos);
            }
            case TIMESTAMP: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, Collections.emptyList(), (SqlParserPos)pos);
            }
            case LOCALTIMESTAMP: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, Collections.emptyList(), (SqlParserPos)pos);
            }
        }
        return this.getUnresolvedFunction(node.getFunction().getName(), Collections.emptyList());
    }

    protected SqlNode visitExtract(Extract node, ParserVisitorContext context) {
        TimeUnit unit = (TimeUnit)TIME_UNIT_MAP.get((Object)node.getField().name());
        if (unit == null) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.EXTRACT, Arrays.asList(new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO), (SqlNode)this.process((Node)node.getExpression(), context)));
    }

    protected SqlNode visitArithmeticBinary(ArithmeticBinaryExpression node, ParserVisitorContext context) {
        return this.getCall((SqlOperator)OPERATOR_MAP.get((Object)node.getOperator().getValue()), (Node)node, context);
    }

    protected SqlNode visitBetweenPredicate(BetweenPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.BETWEEN.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitCoalesceExpression(CoalesceExpression node, ParserVisitorContext context) {
        return SqlStdOperatorTable.COALESCE.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitComparisonExpression(ComparisonExpression node, ParserVisitorContext context) {
        return this.getCall((SqlOperator)OPERATOR_MAP.get((Object)node.getOperator().getValue()), (Node)node, context);
    }

    protected SqlNode visitDoubleLiteral(DoubleLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber((double)node.getValue(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitDecimalLiteral(DecimalLiteral node, ParserVisitorContext context) {
        return SqlNumericLiteral.createExactNumeric((String)node.getValue(), (SqlParserPos)this.getPos((Node)node));
    }

    private SqlNode getFinalQuery(SqlParserPos pos, SqlNode query, SqlNodeList orderByList, SqlNode fetch, SqlNode offset) {
        if (!orderByList.getList().isEmpty() || fetch != null || offset != null) {
            return new SqlOrderBy(pos, query, orderByList, offset, fetch);
        }
        return query;
    }

    protected SqlNode visitQuery(Query node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos((Node)node);
        SqlNode query = (SqlNode)node.getQueryBody().accept((AstVisitor)this, (Object)context);
        SqlNodeList orderByList = (SqlNodeList)ObjectUtils.defaultIfNull((Object)((SqlNodeList)this.processOptional(node.getOrderBy(), context)), (Object)CalciteUtil.createSqlNodeList(Collections.emptyList(), (SqlParserPos)SqlParserPos.ZERO));
        SqlNode fetch = this.processOptional(node.getLimit(), context);
        SqlNode offset = this.processOptional(node.getOffset(), context);
        if (node.getWith().isPresent()) {
            SqlNodeList withItems = this.visitWith((With)node.getWith().get(), context);
            return this.getFinalQuery(pos, (SqlNode)new SqlWith(pos, withItems, query), orderByList, fetch, offset);
        }
        return this.getFinalQuery(pos, query, orderByList, fetch, offset);
    }

    protected SqlNode visitGenericLiteral(GenericLiteral node, ParserVisitorContext context) {
        return this.parseExpression(node.toString());
    }

    private String formatTime(String time) {
        if (time.split(":").length == 2) {
            return time + ":00";
        }
        if (time.split(":").length == 1) {
            return time + ":00:00";
        }
        return time;
    }

    protected SqlNode visitTimeLiteral(TimeLiteral node, ParserVisitorContext context) {
        return SqlLiteral.createTime((TimeString)new TimeString(this.formatTime(node.getValue())), (int)1, (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNodeList visitWith(With node, ParserVisitorContext context) {
        if (node.isRecursive()) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return this.getChildSqlNodeList((Node)node, context);
    }

    protected SqlNode visitWithQuery(WithQuery node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos((Node)node);
        SqlIdentifier alias = this.visitIdentifier(node.getName(), context);
        SqlNode query = this.visitQuery(node.getQuery(), context);
        SqlNodeList columns = null;
        if (node.getColumnNames().isPresent()) {
            columns = this.toSqlNodeList((List)node.getColumnNames().get(), context, pos);
        }
        return new SqlWithItem(pos, alias, columns, query);
    }

    protected SqlNodeList visitSelect(Select node, ParserVisitorContext context) {
        return this.getChildSqlNodeList((Node)node, context);
    }

    protected SqlNodeList visitOrderBy(OrderBy node, ParserVisitorContext context) {
        return this.getChildSqlNodeList((Node)node, context);
    }

    protected SqlNode visitOffset(Offset node, ParserVisitorContext context) {
        return (SqlNode)this.process((Node)node.getRowCount(), context);
    }

    protected SqlNode visitQuerySpecification(QuerySpecification node, ParserVisitorContext context) {
        SqlNodeList selectList = this.visitSelect(node.getSelect(), context);
        SqlNodeList keywords = node.getSelect().isDistinct() ? new SqlNodeList((Collection)ImmutableList.of((Object)SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO)), SqlParserPos.ZERO) : null;
        SqlNode from = this.processOptional(node.getFrom(), context);
        SqlNode where = this.processOptional(node.getWhere(), context);
        SqlNodeList groupBy = (SqlNodeList)this.processOptional(node.getGroupBy(), context);
        SqlNode having = this.processOptional(node.getHaving(), context);
        SqlNodeList orderBy = (SqlNodeList)ObjectUtils.defaultIfNull((Object)((SqlNodeList)this.processOptional(node.getOrderBy(), context)), (Object)CalciteUtil.createSqlNodeList(Collections.emptyList(), (SqlParserPos)SqlParserPos.ZERO));
        SqlNode limit = this.processOptional(node.getLimit(), context);
        SqlNode offset = this.processOptional(node.getOffset(), context);
        SqlSelect select = new SqlSelect(this.getPos((Node)node), keywords, selectList, from, where, groupBy, having, null, null, null, null);
        if (!orderBy.getList().isEmpty() || offset != null || limit != null) {
            return new SqlOrderBy(this.getPos((Node)node), (SqlNode)select, orderBy, offset, limit);
        }
        return select;
    }

    protected SqlNode visitUnion(Union node, ParserVisitorContext context) {
        if (node.isDistinct()) {
            return SqlStdOperatorTable.UNION.createCall(this.getChildSqlNodeList((Node)node, context));
        }
        return SqlStdOperatorTable.UNION_ALL.createCall(this.getChildSqlNodeList((Node)node, context));
    }

    protected SqlNode visitIntersect(Intersect node, ParserVisitorContext context) {
        return SqlStdOperatorTable.INTERSECT.createCall(this.getChildSqlNodeList((Node)node, context));
    }

    protected SqlNode visitExcept(Except node, ParserVisitorContext context) {
        return SqlStdOperatorTable.EXCEPT.createCall(this.getChildSqlNodeList((Node)node, context));
    }

    protected SqlNode visitTimestampLiteral(TimestampLiteral node, ParserVisitorContext context) {
        return SqlLiteral.createTimestamp((TimestampString)new TimestampString(this.formatTime(node.getValue())), (int)1, (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitWhenClause(WhenClause node, ParserVisitorContext context) {
        context.whenClauses.add((SqlNode)this.process((Node)node.getOperand(), context));
        context.thenClauses.add((SqlNode)this.process((Node)node.getResult(), context));
        return null;
    }

    protected SqlNode visitIntervalLiteral(IntervalLiteral node, ParserVisitorContext context) {
        TimeUnit startUnit = TimeUnit.valueOf((String)node.getStartField().toString());
        TimeUnit endUnit = node.getEndField().isPresent() ? TimeUnit.valueOf((String)node.getEndField().toString()) : null;
        SqlIntervalQualifier qualifier = new SqlIntervalQualifier(startUnit, endUnit, SqlParserPos.ZERO);
        return SqlLiteral.createInterval((int)node.getSign().multiplier(), (String)node.getValue(), (SqlIntervalQualifier)qualifier, (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitInPredicate(InPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.IN.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitFunctionCall(FunctionCall node, ParserVisitorContext context) {
        SqlLiteral functionQualifier;
        SqlUnresolvedFunction unresolvedFunction;
        SqlCall call;
        if (node.getFilter().isPresent()) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        SqlParserPos pos = this.getPos((Node)node);
        List operands = node.getArguments().stream().map(arg -> (SqlNode)this.process((Node)arg, context)).collect(Collectors.toList());
        SqlIdentifier functionName = this.convertQualifiedName(node.getName(), this.getPos((Node)node));
        if (node.getName().toString().equalsIgnoreCase("COUNT") && operands.isEmpty()) {
            operands.add(CalciteUtil.createStarIdentifier((SqlParserPos)SqlParserPos.ZERO));
        }
        if (NULL_CARED_OPERATOR.contains((Object)(call = CalciteUtil.createCall((SqlOperator)(unresolvedFunction = new SqlUnresolvedFunction(functionName, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION)), operands, (SqlLiteral)(functionQualifier = node.isDistinct() ? SqlLiteral.createSymbol((Enum)SqlSelectKeyword.DISTINCT, (SqlParserPos)SqlParserPos.ZERO) : null))).getKind()) && node.getNullTreatment().isPresent()) {
            call = ((FunctionCall.NullTreatment)node.getNullTreatment().get()).equals((Object)FunctionCall.NullTreatment.IGNORE) ? SqlStdOperatorTable.IGNORE_NULLS.createCall(pos, new SqlNode[]{call}) : SqlStdOperatorTable.RESPECT_NULLS.createCall(pos, new SqlNode[]{call});
        }
        if (node.getWindow().isPresent()) {
            return SqlStdOperatorTable.OVER.createCall(pos, new SqlNode[]{call, this.visitWindow((Window)node.getWindow().get(), context)});
        }
        return call;
    }

    private SqlNode visitWindow(Window window, ParserVisitorContext context) {
        if (window instanceof WindowSpecification) {
            return this.visitWindowSpecification((WindowSpecification)window, context);
        }
        if (window instanceof WindowReference) {
            return this.visitWindowReference((WindowReference)window, context);
        }
        return null;
    }

    protected SqlNode visitLambdaExpression(LambdaExpression node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, LAMBDA_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSimpleCaseExpression(SimpleCaseExpression node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos((Node)node);
        SqlNode operand = (SqlNode)this.process((Node)node.getOperand(), context);
        ParserVisitorContext caseWhenContext = new ParserVisitorContext();
        node.getWhenClauses().forEach(cw -> {
            SqlNode cfr_ignored_0 = (SqlNode)this.process((Node)cw, caseWhenContext);
        });
        SqlNode defaultValue = node.getDefaultValue().isPresent() ? (SqlNode)this.process((Node)node.getDefaultValue().get(), context) : CalciteUtil.createLiteralNull((SqlParserPos)SqlParserPos.ZERO);
        return caseWhenContext.createCaseCall(pos, operand, defaultValue);
    }

    protected SqlNode visitStringLiteral(StringLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createStringLiteral((String)node.getValue(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitCharLiteral(CharLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createStringLiteral((String)node.getValue(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitBinaryLiteral(BinaryLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createBinaryLiteral((byte[])node.getValue().getBytes(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitBooleanLiteral(BooleanLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralBoolean((boolean)node.getValue(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitInListExpression(InListExpression node, ParserVisitorContext context) {
        return this.getChildSqlNodeList((Node)node, context);
    }

    protected SqlIdentifier visitIdentifier(Identifier node, ParserVisitorContext context) {
        return CalciteUtil.createSqlIdentifier((SqlParserPos)this.getPos((Node)node), (String[])new String[]{node.getValue()});
    }

    protected SqlNode visitDereferenceExpression(DereferenceExpression node, ParserVisitorContext context) {
        SqlNode base = (SqlNode)this.process((Node)node.getBase(), context);
        if (base.getKind().equals((Object)SqlKind.IDENTIFIER)) {
            ArrayList<String> names = new ArrayList<String>((Collection<String>)((SqlIdentifier)base).names);
            names.add(node.getField().getValue());
            return CalciteUtil.createSqlIdentifier((SqlParserPos)this.getPos((Node)node), (String[])names.toArray(new String[0]));
        }
        return SqlStdOperatorTable.DOT.createCall(this.getPos((Node)node), new SqlNode[]{base, new SqlIdentifier(node.getField().getValue(), SqlParserPos.ZERO)});
    }

    protected SqlNode visitNullIfExpression(NullIfExpression node, ParserVisitorContext context) {
        return SqlStdOperatorTable.NULLIF.createCall(this.getPos((Node)node), new SqlNode[]{this.getChildSqlNodeList((Node)node, context)});
    }

    protected SqlNode visitIfExpression(IfExpression node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos((Node)node);
        SqlNode defaultValue = node.getFalseValue().isPresent() ? (SqlNode)this.process((Node)node.getFalseValue().get(), context) : CalciteUtil.createLiteralNull((SqlParserPos)SqlParserPos.ZERO);
        SqlNodeList whenList = this.toSqlNodeList(Collections.singletonList(node.getCondition()), context, pos);
        SqlNodeList thenList = this.toSqlNodeList(Collections.singletonList(node.getTrueValue()), context, pos);
        return SqlStdOperatorTable.CASE.createCall(null, pos, new SqlNode[]{null, whenList, thenList, defaultValue});
    }

    protected SqlNode visitNullLiteral(NullLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNull((SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitArithmeticUnary(ArithmeticUnaryExpression node, ParserVisitorContext context) {
        SqlNode operand = (SqlNode)this.process((Node)node.getValue(), context);
        if (node.getSign().equals((Object)ArithmeticUnaryExpression.Sign.MINUS)) {
            if (operand instanceof SqlNumericLiteral) {
                return SqlLiteral.createNegative((SqlNumericLiteral)((SqlNumericLiteral)operand), (SqlParserPos)this.getPos((Node)node));
            }
            return SqlStdOperatorTable.UNARY_MINUS.createCall(this.getPos((Node)node), new SqlNode[]{operand});
        }
        return operand;
    }

    protected SqlNode visitNotExpression(NotExpression node, ParserVisitorContext context) {
        SqlNode operand = (SqlNode)this.process((Node)node.getValue(), context);
        SqlParserPos pos = this.getPos((Node)node);
        if (operand.getKind().equals((Object)SqlKind.BETWEEN)) {
            return SqlStdOperatorTable.NOT_BETWEEN.createCall(pos, ((SqlCall)operand).getOperandList());
        }
        if (operand.getKind().equals((Object)SqlKind.IN)) {
            return SqlStdOperatorTable.NOT_IN.createCall(pos, ((SqlCall)operand).getOperandList());
        }
        return SqlStdOperatorTable.NOT.createCall(pos, new SqlNode[]{operand});
    }

    protected SqlNode visitSingleColumn(SingleColumn node, ParserVisitorContext context) {
        if (node.getAlias().isPresent()) {
            return SqlStdOperatorTable.AS.createCall(this.getPos((Node)node), new SqlNode[]{(SqlNode)this.process((Node)node.getExpression(), context), (SqlNode)this.process((Node)node.getAlias().get(), context)});
        }
        return (SqlNode)this.process((Node)node.getExpression(), context);
    }

    protected SqlNode visitAllColumns(AllColumns node, ParserVisitorContext context) {
        if (!node.getAliases().isEmpty()) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        if (node.getTarget().isPresent()) {
            SqlNode target = (SqlNode)this.process((Node)node.getTarget().get(), context);
            if (target.getKind().equals((Object)SqlKind.IDENTIFIER)) {
                ArrayList<String> names = new ArrayList<String>((Collection<String>)((SqlIdentifier)target).names);
                names.add("");
                return CalciteUtil.createSqlIdentifier((SqlParserPos)this.getPos((Node)node), (String[])names.toArray(new String[0]));
            }
            return SqlStdOperatorTable.DOT.createCall(this.getPos((Node)node), new SqlNode[]{target, CalciteUtil.createStarIdentifier((SqlParserPos)SqlParserPos.ZERO)});
        }
        return CalciteUtil.createStarIdentifier((SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitSearchedCaseExpression(SearchedCaseExpression node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos((Node)node);
        ArrayList whenClauses = new ArrayList();
        ArrayList thenClauses = new ArrayList();
        node.getWhenClauses().forEach(caseWhen -> {
            whenClauses.add(this.process((Node)caseWhen.getOperand(), context));
            thenClauses.add(this.process((Node)caseWhen.getResult(), context));
        });
        SqlNode defaultValue = node.getDefaultValue().isPresent() ? (SqlNode)this.process((Node)node.getDefaultValue().get(), context) : CalciteUtil.createLiteralNull((SqlParserPos)SqlParserPos.ZERO);
        return SqlStdOperatorTable.CASE.createCall(null, pos, new SqlNode[]{null, CalciteUtil.createSqlNodeList(whenClauses, (SqlParserPos)pos), CalciteUtil.createSqlNodeList(thenClauses, (SqlParserPos)pos), defaultValue});
    }

    protected SqlNode visitLikePredicate(LikePredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.LIKE.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitIsNotNullPredicate(IsNotNullPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.IS_NOT_NULL.createCall(this.getPos((Node)node), new SqlNode[]{(SqlNode)this.process((Node)node.getValue(), context)});
    }

    protected SqlNode visitIsNullPredicate(IsNullPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.IS_NULL.createCall(this.getPos((Node)node), new SqlNode[]{(SqlNode)this.process((Node)node.getValue(), context)});
    }

    protected SqlNode visitArrayConstructor(ArrayConstructor node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitSubscriptExpression(SubscriptExpression node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ITEM.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitLongLiteral(LongLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber((long)node.getValue(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitParameter(Parameter node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber((long)node.getPosition(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitLogicalBinaryExpression(LogicalBinaryExpression node, ParserVisitorContext context) {
        if (node.getOperator().equals((Object)LogicalBinaryExpression.Operator.AND)) {
            return SqlStdOperatorTable.AND.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
        }
        return SqlStdOperatorTable.OR.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitSubqueryExpression(SubqueryExpression node, ParserVisitorContext context) {
        return (SqlNode)this.process((Node)node.getQuery(), context);
    }

    protected SqlNode visitSortItem(SortItem node, ParserVisitorContext context) {
        SqlNode ordering;
        SqlParserPos pos = this.getPos((Node)node);
        SqlNode operand = (SqlNode)this.process((Node)node.getSortKey(), context);
        Object object = ordering = node.getOrdering().equals((Object)SortItem.Ordering.DESCENDING) ? SqlStdOperatorTable.DESC.createCall(pos, new SqlNode[]{operand}) : operand;
        if (node.getNullOrdering().equals((Object)SortItem.NullOrdering.FIRST)) {
            return SqlStdOperatorTable.NULLS_FIRST.createCall(pos, new SqlNode[]{ordering});
        }
        if (node.getNullOrdering().equals((Object)SortItem.NullOrdering.LAST)) {
            return SqlStdOperatorTable.NULLS_LAST.createCall(pos, new SqlNode[]{ordering});
        }
        return ordering;
    }

    protected SqlNode visitTable(Table node, ParserVisitorContext context) {
        return this.convertQualifiedName(node.getName(), this.getPos((Node)node));
    }

    protected SqlNode visitUnnest(Unnest node, ParserVisitorContext context) {
        if (node.isWithOrdinality()) {
            return SqlStdOperatorTable.UNNEST_WITH_ORDINALITY.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
        }
        return SqlStdOperatorTable.UNNEST.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitLateral(Lateral node, ParserVisitorContext context) {
        return (SqlNode)this.process((Node)node.getQuery(), context);
    }

    protected SqlNode visitValues(Values node, ParserVisitorContext context) {
        return SqlStdOperatorTable.VALUES.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitRow(Row node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ROW.createCall(this.getPos((Node)node), this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNode visitTableSubquery(TableSubquery node, ParserVisitorContext context) {
        return (SqlNode)this.process((Node)node.getQuery(), context);
    }

    protected SqlNode visitAliasedRelation(AliasedRelation node, ParserVisitorContext context) {
        ArrayList<Object> operands = new ArrayList<Object>();
        operands.add(this.process((Node)node.getRelation(), context));
        operands.add(this.visitIdentifier(node.getAlias(), context));
        operands.addAll(this.toListOfSqlNode(node.getColumnNames(), context));
        return SqlStdOperatorTable.AS.createCall(this.getPos((Node)node), operands);
    }

    protected SqlNode visitSampledRelation(SampledRelation node, ParserVisitorContext context) {
        ArrayList<Object> operands = new ArrayList<Object>();
        operands.add(this.process((Node)node.getRelation(), context));
        SqlNode percentageNode = (SqlNode)this.process((Node)node.getSamplePercentage(), context);
        float percentage = 0.0f;
        if (!(percentageNode instanceof SqlNumericLiteral)) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        percentage = (float)((double)((SqlNumericLiteral)percentageNode).longValue(true) / 100.0);
        operands.add(SqlLiteral.createSample((SqlSampleSpec)SqlSampleSpec.createTableSample((boolean)node.getType().equals((Object)SampledRelation.Type.BERNOULLI), (float)percentage), (SqlParserPos)this.getPos((Node)node)));
        return SqlStdOperatorTable.TABLESAMPLE.createCall(this.getPos((Node)node), operands);
    }

    protected SqlNode visitJoin(Join node, ParserVisitorContext context) {
        JoinType joinType;
        SqlNode left = (SqlNode)this.process((Node)node.getLeft(), context);
        SqlNode right = (SqlNode)this.process((Node)node.getRight(), context);
        SqlLiteral natural = CalciteUtil.createLiteralBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO);
        JoinConditionType conditionType = JoinConditionType.NONE;
        SqlNode condition = null;
        if (node.getCriteria().isPresent()) {
            JoinCriteria joinCriteria = (JoinCriteria)node.getCriteria().get();
            natural = CalciteUtil.createLiteralBoolean((boolean)(joinCriteria instanceof NaturalJoin), (SqlParserPos)SqlParserPos.ZERO);
            if (joinCriteria instanceof JoinOn) {
                conditionType = JoinConditionType.ON;
                condition = (SqlNode)this.process((Node)((JoinOn)joinCriteria).getExpression(), context);
            } else if (joinCriteria instanceof JoinUsing) {
                conditionType = JoinConditionType.USING;
                condition = this.toSqlNodeList(((JoinUsing)joinCriteria).getColumns(), context, this.getPos((Node)node));
            }
        }
        if ((joinType = (JoinType)JOIN_TYPE_MAP.get((Object)node.getType())) == null) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return new SqlJoin(this.getPos((Node)node), left, natural, joinType.symbol(SqlParserPos.ZERO), right, conditionType.symbol(SqlParserPos.ZERO), condition);
    }

    protected SqlNode visitExists(ExistsPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.EXISTS.createCall(this.getPos((Node)node), new SqlNode[]{(SqlNode)this.process((Node)node.getSubquery(), context)});
    }

    protected SqlNode visitCast(Cast node, ParserVisitorContext context) {
        SqlDataTypeSpec spec = (SqlDataTypeSpec)this.process((Node)node.getType(), context);
        return SqlStdOperatorTable.CAST.createCall(this.getPos((Node)node), new SqlNode[]{(SqlNode)this.process((Node)node.getExpression(), context), spec});
    }

    protected SqlNode visitFieldReference(FieldReference node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber((long)node.getFieldIndex(), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitWindowSpecification(WindowSpecification node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos((Node)node);
        SqlNodeList partitionList = this.toSqlNodeList(node.getPartitionBy(), context, pos);
        SqlNodeList orderList = (SqlNodeList)ObjectUtils.defaultIfNull((Object)((SqlNodeList)this.processOptional(node.getOrderBy(), context)), (Object)CalciteUtil.createSqlNodeList(Collections.emptyList(), (SqlParserPos)SqlParserPos.ZERO));
        ParserVisitorContext frameContext = new ParserVisitorContext();
        if (node.getFrame().isPresent()) {
            this.process((Node)node.getFrame().get(), frameContext);
        }
        return frameContext.createWindow(pos, partitionList, orderList);
    }

    protected SqlNode visitWindowFrame(WindowFrame node, ParserVisitorContext context) {
        context.isRows = node.getType().equals((Object)WindowFrame.Type.ROWS);
        context.lowerBound = this.visitFrameBound(node.getStart(), context);
        context.upperBound = node.getEnd().isPresent() ? this.visitFrameBound((FrameBound)node.getEnd().get(), context) : null;
        return null;
    }

    protected SqlNode visitFrameBound(FrameBound node, ParserVisitorContext context) {
        if (node.getValue().isPresent()) {
            return this.getUnresolvedFunction(node.getType().name(), Collections.singletonList(this.process((Node)node.getValue().get(), context)));
        }
        return SqlLiteral.createSymbol((Enum)node.getType(), (SqlParserPos)SqlParserPos.ZERO);
    }

    protected SqlNode visitCallArgument(CallArgument node, ParserVisitorContext context) {
        return (SqlNode)this.process((Node)node.getValue(), context);
    }

    protected SqlNode visitLikeClause(LikeClause node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCreateSchema(CreateSchema node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDropSchema(DropSchema node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRenameSchema(RenameSchema node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCreateTable(CreateTable node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCreateTableAsSelect(CreateTableAsSelect node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitProperty(Property node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDropTable(DropTable node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRenameTable(RenameTable node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRenameColumn(RenameColumn node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDropColumn(DropColumn node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitAddColumn(AddColumn node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitAnalyze(Analyze node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCreateView(CreateView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDropView(DropView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCreateMaterializedView(CreateMaterializedView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDropMaterializedView(DropMaterializedView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRefreshMaterializedView(RefreshMaterializedView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitInsert(Insert node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCall(Call node, ParserVisitorContext context) {
        return SqlStdOperatorTable.PROCEDURE_CALL.createCall(this.getPos((Node)node), new SqlNode[]{this.getUnresolvedFunction(node.getName().toString(), this.toListOfSqlNode(node.getArguments(), context))});
    }

    protected SqlNode visitDelete(Delete node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitStartTransaction(StartTransaction node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCreateRole(CreateRole node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDropRole(DropRole node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitGrantRoles(GrantRoles node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRevokeRoles(RevokeRoles node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSetRole(SetRole node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitGrant(Grant node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRevoke(Revoke node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowGrants(ShowGrants node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowRoles(ShowRoles node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowRoleGrants(ShowRoleGrants node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitTransactionMode(TransactionMode node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitIsolationLevel(Isolation node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitTransactionAccessMode(TransactionAccessMode node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCommit(Commit node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRollback(Rollback node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitAtTimeZone(AtTimeZone node, ParserVisitorContext context) {
        return this.getUnresolvedFunction("AT_TIMEZONE", this.getChildSqlNodeList((Node)node, context).getList());
    }

    protected SqlNodeList visitGroupBy(GroupBy node, ParserVisitorContext context) {
        return this.getChildSqlNodeList((Node)node, context);
    }

    protected SqlNode visitCube(Cube node, ParserVisitorContext context) {
        return SqlStdOperatorTable.CUBE.createCall(this.getPos((Node)node), this.toListOfSqlNode(node.getExpressions(), context));
    }

    protected SqlNode visitGroupingSets(GroupingSets node, ParserVisitorContext context) {
        List sets = node.getSets();
        ArrayList<Object> operands = new ArrayList<Object>();
        for (List expressions : sets) {
            if (expressions.isEmpty()) {
                operands.add(CalciteUtil.createSqlNodeList(Collections.emptyList()));
                continue;
            }
            if (expressions.size() > 1) {
                operands.add(SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, new SqlNode[]{this.toSqlNodeList(expressions, context, this.getPos((Node)node))}));
                continue;
            }
            operands.add(this.process((Node)expressions.get(0), context));
        }
        return SqlStdOperatorTable.GROUPING_SETS.createCall(this.getPos((Node)node), operands);
    }

    protected SqlNode visitRollup(Rollup node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ROLLUP.createCall(this.getPos((Node)node), this.toListOfSqlNode(node.getExpressions(), context));
    }

    protected SqlNode visitSimpleGroupBy(SimpleGroupBy node, ParserVisitorContext context) {
        Preconditions.checkArgument((node.getExpressions().size() == 1 ? 1 : 0) != 0, (Object)"SimpleGroupBy should have only one element in the expression.");
        return (SqlNode)this.process((Node)node.getExpressions().get(0), context);
    }

    protected SqlNode visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, ParserVisitorContext context) {
        SqlNode left = (SqlNode)this.process((Node)node.getValue(), context);
        SqlNode right = (SqlNode)this.process((Node)node.getSubquery(), context);
        SqlParserPos pos = this.getPos((Node)node);
        if (node.getQuantifier().equals((Object)QuantifiedComparisonExpression.Quantifier.ALL)) {
            return ((SqlOperator)ALL_COMPARISON_OPERATOR.get((Object)node.getOperator())).createCall(pos, new SqlNode[]{left, right});
        }
        return ((SqlOperator)SOME_COMPARISON_OPERATOR.get((Object)node.getOperator())).createCall(pos, new SqlNode[]{left, right});
    }

    protected SqlNode visitLambdaArgumentDeclaration(LambdaArgumentDeclaration node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, LAMBDA_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitBindExpression(BindExpression node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, LAMBDA_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitGroupingOperation(GroupingOperation node, ParserVisitorContext context) {
        return SqlStdOperatorTable.GROUPING.createCall(this.getPos((Node)node), this.toListOfSqlNode(node.getGroupingColumns(), context));
    }

    protected SqlNode visitCurrentUser(CurrentUser node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitPrepare(Prepare node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDeallocate(Deallocate node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitExecute(Execute node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDescribeOutput(DescribeOutput node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitDescribeInput(DescribeInput node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitExplain(Explain node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowTables(ShowTables node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowSchemas(ShowSchemas node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowCatalogs(ShowCatalogs node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowColumns(ShowColumns node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowStats(ShowStats node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowCreate(ShowCreate node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowFunctions(ShowFunctions node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitUse(Use node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitShowSession(ShowSession node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSetSession(SetSession node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitResetSession(ResetSession node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitExplainOption(ExplainOption node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitTryExpression(TryExpression node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
    }

    protected SqlNode visitColumnDefinition(ColumnDefinition node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSymbolReference(SymbolReference node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
    }

    protected SqlNode visitFetchFirst(FetchFirst node, ParserVisitorContext context) {
        if (node.isWithTies()) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        if (!node.getRowCount().isPresent()) {
            return null;
        }
        return (SqlNode)this.process((Node)node.getRowCount().get(), context);
    }

    protected SqlNode visitLimit(Limit node, ParserVisitorContext context) {
        return (SqlNode)this.process((Node)node.getRowCount(), context);
    }

    protected SqlNode visitAllRows(AllRows node, ParserVisitorContext context) {
        return null;
    }

    protected SqlNode visitWindowReference(WindowReference node, ParserVisitorContext context) {
        return this.visitIdentifier(node.getName(), context);
    }

    protected SqlNode visitWindowDefinition(WindowDefinition node, ParserVisitorContext context) {
        SqlWindow window = (SqlWindow)this.visitWindowSpecification(node.getWindow(), context);
        return SqlWindow.create((SqlIdentifier)this.visitIdentifier(node.getName(), context), (SqlIdentifier)window.getRefName(), (SqlNodeList)window.getPartitionList(), (SqlNodeList)window.getOrderList(), (SqlLiteral)CalciteUtil.createLiteralBoolean((boolean)window.isRows(), (SqlParserPos)SqlParserPos.ZERO), (SqlNode)window.getLowerBound(), (SqlNode)window.getUpperBound(), (SqlLiteral)CalciteUtil.createLiteralBoolean((boolean)window.isAllowPartial(), (SqlParserPos)SqlParserPos.ZERO), (SqlParserPos)window.getParserPosition());
    }

    protected SqlNode visitMergeInsert(MergeInsert node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitMergeUpdate(MergeUpdate node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitMergeDelete(MergeDelete node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSetSchemaAuthorization(SetSchemaAuthorization node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRenameView(RenameView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSetViewAuthorization(SetViewAuthorization node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitComment(Comment node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSetTableAuthorization(SetTableAuthorization node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitUpdate(Update node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitUpdateAssignment(UpdateAssignment node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitSetPath(SetPath node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitPathSpecification(PathSpecification node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitPathElement(PathElement node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitCurrentPath(CurrentPath node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitFormat(Format node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
    }

    protected SqlNode visitMerge(Merge node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException((Node)node, DDL_NOT_SUPPORT_MSG);
    }

    protected SqlNode visitRowDataType(RowDataType node, ParserVisitorContext context) {
        ParserVisitorContext rowContext = new ParserVisitorContext();
        node.getFields().forEach(f -> {
            SqlNode cfr_ignored_0 = (SqlNode)this.process((Node)f, rowContext);
        });
        return rowContext.createRowType(this.getPos((Node)node));
    }

    protected SqlNode visitGenericDataType(GenericDataType node, ParserVisitorContext context) {
        if (node.getArguments().isEmpty()) {
            return SqlTypeUtil.convertTypeToSpec((RelDataType)this.sqlTypeFactory.createSqlType(SqlTypeName.valueOf((String)node.getName().getValue().toUpperCase())));
        }
        switch (node.getName().getValue().toUpperCase()) {
            case "DECIMAL": {
                int precision = this.getNumberFromNumericParameter((Node)node.getArguments().get(0));
                int scale = node.getArguments().size() > 1 ? this.getNumberFromNumericParameter((Node)node.getArguments().get(0)) : 0;
                return SqlTypeUtil.convertTypeToSpec((RelDataType)this.sqlTypeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale));
            }
            case "CHAR": 
            case "VARCHAR": 
            case "BINARY": {
                int len = this.getNumberFromNumericParameter((Node)node.getArguments().get(0));
                return SqlTypeUtil.convertTypeToSpec((RelDataType)this.sqlTypeFactory.createSqlType(SqlTypeName.valueOf((String)node.getName().getValue().toUpperCase()), len));
            }
            case "ARRAY": {
                return new SqlArrayTypeSpec((SqlDataTypeSpec)this.process((Node)node.getArguments().get(0)), SqlParserPos.ZERO);
            }
            case "MAP": {
                return new SqlMapTypeSpec((SqlDataTypeSpec)this.process((Node)node.getArguments().get(0)), (SqlDataTypeSpec)this.process((Node)node.getArguments().get(1)), SqlParserPos.ZERO);
            }
        }
        throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
    }

    protected SqlNode visitRowField(RowDataType.Field node, ParserVisitorContext context) {
        if (!node.getName().isPresent()) {
            throw new UnhandledASTNodeException((Node)node, UNSUPPORTED_EXCEPTION_MSG);
        }
        context.fieldTypes.add((SqlDataTypeSpec)this.process((Node)node.getType(), context));
        context.fieldNames.add((SqlIdentifier)this.process((Node)node.getName().get(), context));
        return null;
    }

    protected SqlNode visitIntervalDataType(IntervalDayTimeDataType node, ParserVisitorContext context) {
        return new SqlIntervalQualifier((TimeUnit)TIME_UNIT_MAP.get((Object)node.getFrom().name()), (TimeUnit)TIME_UNIT_MAP.get((Object)node.getTo().name()), this.getPos((Node)node));
    }

    int getNumberFromNumericParameter(Node numericParameter) {
        return Integer.parseInt(((NumericParameter)numericParameter).getValue());
    }

    protected SqlNode visitDateTimeType(DateTimeDataType node, ParserVisitorContext context) {
        int precision = node.getPrecision().isPresent() ? this.getNumberFromNumericParameter((Node)node.getPrecision().get()) : -1;
        SqlParserPos pos = this.getPos((Node)node);
        if (node.isWithTimeZone()) {
            if (node.getType().equals((Object)DateTimeDataType.Type.TIME)) {
                return new SqlDataTypeSpec((SqlTypeNameSpec)new SqlBasicTypeNameSpec(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, precision, pos), pos);
            }
            return new SqlDataTypeSpec((SqlTypeNameSpec)new SqlBasicTypeNameSpec(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, precision, pos), pos);
        }
        return new SqlDataTypeSpec((SqlTypeNameSpec)new SqlBasicTypeNameSpec(SqlTypeName.valueOf((String)node.getType().name()), precision, pos), pos);
    }

    protected SqlNode visitNumericTypeParameter(NumericParameter node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber((long)this.getNumberFromNumericParameter((Node)node), (SqlParserPos)this.getPos((Node)node));
    }

    protected SqlNode visitTypeParameter(TypeParameter node, ParserVisitorContext context) {
        return (SqlNode)this.process((Node)node.getValue(), context);
    }
}

