/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import io.trino.hadoop.$internal.htrace.core.TraceScope;
import io.trino.hadoop.$internal.htrace.core.Tracer;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;

@InterfaceAudience.Private
public class ReencryptionStatusIterator
extends BatchedRemoteIterator<Long, ZoneReencryptionStatus> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public ReencryptionStatusIterator(ClientProtocol namenode, Tracer tracer) {
        super(0L);
        this.namenode = namenode;
        this.tracer = tracer;
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> makeRequest(Long prevId) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listReencryptionStatus");){
            BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> batchedEntries = this.namenode.listReencryptionStatus(prevId);
            return batchedEntries;
        }
    }

    @Override
    public Long elementToPrevKey(ZoneReencryptionStatus entry) {
        return entry.getId();
    }
}

