/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.com.google.common.base.Predicate;
import io.trino.hadoop.$internal.com.google.common.collect.Collections2;
import io.trino.hadoop.$internal.com.google.common.collect.HashMultimap;
import io.trino.hadoop.$internal.com.google.common.collect.Iterables;
import io.trino.hadoop.$internal.com.google.common.collect.Multimap;
import io.trino.hadoop.$internal.com.google.common.collect.UnmodifiableIterator;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.util.CombinedHostsFileReader;

public class CombinedHostFileManager
extends HostConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedHostFileManager.class);
    private Configuration conf;
    private HostProperties hostProperties = new HostProperties();

    @Override
    public Iterable<InetSocketAddress> getIncludes() {
        return this.hostProperties.getIncludes();
    }

    @Override
    public Iterable<InetSocketAddress> getExcludes() {
        return this.hostProperties.getExcludes();
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void refresh() throws IOException {
        this.refresh(this.conf.get("dfs.hosts", ""));
    }

    private void refresh(String hostsFile) throws IOException {
        DatanodeAdminProperties[] all;
        HostProperties hostProps = new HostProperties();
        for (DatanodeAdminProperties properties : all = CombinedHostsFileReader.readFile(hostsFile)) {
            InetSocketAddress addr = CombinedHostFileManager.parseEntry(hostsFile, properties.getHostName(), properties.getPort());
            if (addr == null) continue;
            hostProps.add(addr.getAddress(), properties);
        }
        this.refresh(hostProps);
    }

    @VisibleForTesting
    static InetSocketAddress parseEntry(String fn, String hostName, int port) {
        InetSocketAddress addr = new InetSocketAddress(hostName, port);
        if (addr.isUnresolved()) {
            LOG.warn("Failed to resolve {} in {}. ", (Object)hostName, (Object)fn);
            return null;
        }
        return addr;
    }

    @Override
    public synchronized boolean isIncluded(DatanodeID dn) {
        return this.hostProperties.isIncluded(dn.getResolvedAddress());
    }

    @Override
    public synchronized boolean isExcluded(DatanodeID dn) {
        return this.isExcluded(dn.getResolvedAddress());
    }

    private boolean isExcluded(InetSocketAddress address) {
        return this.hostProperties.isExcluded(address);
    }

    @Override
    public synchronized String getUpgradeDomain(DatanodeID dn) {
        return this.hostProperties.getUpgradeDomain(dn.getResolvedAddress());
    }

    @Override
    public long getMaintenanceExpirationTimeInMS(DatanodeID dn) {
        return this.hostProperties.getMaintenanceExpireTimeInMS(dn.getResolvedAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private void refresh(HostProperties hostProperties) {
        CombinedHostFileManager combinedHostFileManager = this;
        synchronized (combinedHostFileManager) {
            this.hostProperties = hostProperties;
        }
    }

    static class HostProperties {
        private Multimap<InetAddress, DatanodeAdminProperties> allDNs = HashMultimap.create();
        private boolean emptyInServiceNodeLists = true;

        HostProperties() {
        }

        synchronized void add(InetAddress addr, DatanodeAdminProperties properties) {
            this.allDNs.put(addr, properties);
            if (properties.getAdminState().equals((Object)DatanodeInfo.AdminStates.NORMAL)) {
                this.emptyInServiceNodeLists = false;
            }
        }

        synchronized boolean isIncluded(final InetSocketAddress address) {
            return this.emptyInServiceNodeLists || Iterables.any(this.allDNs.get(address.getAddress()), new Predicate<DatanodeAdminProperties>(){

                @Override
                public boolean apply(DatanodeAdminProperties input) {
                    return input.getPort() == 0 || input.getPort() == address.getPort();
                }
            });
        }

        synchronized boolean isExcluded(final InetSocketAddress address) {
            return Iterables.any(this.allDNs.get(address.getAddress()), new Predicate<DatanodeAdminProperties>(){

                @Override
                public boolean apply(DatanodeAdminProperties input) {
                    return input.getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED) && (input.getPort() == 0 || input.getPort() == address.getPort());
                }
            });
        }

        synchronized String getUpgradeDomain(final InetSocketAddress address) {
            Iterable<DatanodeAdminProperties> datanode = Iterables.filter(this.allDNs.get(address.getAddress()), new Predicate<DatanodeAdminProperties>(){

                @Override
                public boolean apply(DatanodeAdminProperties input) {
                    return input.getPort() == 0 || input.getPort() == address.getPort();
                }
            });
            return datanode.iterator().hasNext() ? datanode.iterator().next().getUpgradeDomain() : null;
        }

        Iterable<InetSocketAddress> getIncludes() {
            return new Iterable<InetSocketAddress>(){

                @Override
                public Iterator<InetSocketAddress> iterator() {
                    return new HostIterator(allDNs.entries());
                }
            };
        }

        Iterable<InetSocketAddress> getExcludes() {
            return new Iterable<InetSocketAddress>(){

                @Override
                public Iterator<InetSocketAddress> iterator() {
                    return new HostIterator(Collections2.filter(allDNs.entries(), new Predicate<Map.Entry<InetAddress, DatanodeAdminProperties>>(){

                        @Override
                        public boolean apply(Map.Entry<InetAddress, DatanodeAdminProperties> entry) {
                            return entry.getValue().getAdminState().equals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED);
                        }
                    }));
                }
            };
        }

        synchronized long getMaintenanceExpireTimeInMS(final InetSocketAddress address) {
            Iterable<DatanodeAdminProperties> datanode = Iterables.filter(this.allDNs.get(address.getAddress()), new Predicate<DatanodeAdminProperties>(){

                @Override
                public boolean apply(DatanodeAdminProperties input) {
                    return input.getAdminState().equals((Object)DatanodeInfo.AdminStates.IN_MAINTENANCE) && (input.getPort() == 0 || input.getPort() == address.getPort());
                }
            });
            return datanode.iterator().hasNext() ? datanode.iterator().next().getMaintenanceExpireTimeInMS() : 0L;
        }

        static class HostIterator
        extends UnmodifiableIterator<InetSocketAddress> {
            private final Iterator<Map.Entry<InetAddress, DatanodeAdminProperties>> it;

            public HostIterator(Collection<Map.Entry<InetAddress, DatanodeAdminProperties>> nodes) {
                this.it = nodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public InetSocketAddress next() {
                Map.Entry<InetAddress, DatanodeAdminProperties> e = this.it.next();
                return new InetSocketAddress(e.getKey(), e.getValue().getPort());
            }
        }
    }
}

