/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Identifier;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.Relation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AliasedRelation
extends Relation {
    private final Relation relation;
    private final Identifier alias;
    private final List<Identifier> columnNames;

    public AliasedRelation(Relation relation, Identifier alias, List<Identifier> columnNames) {
        this(Optional.empty(), relation, alias, columnNames);
    }

    public AliasedRelation(NodeLocation location, Relation relation, Identifier alias, List<Identifier> columnNames) {
        this(Optional.of(location), relation, alias, columnNames);
    }

    private AliasedRelation(Optional<NodeLocation> location, Relation relation, Identifier alias, List<Identifier> columnNames) {
        super(location);
        Objects.requireNonNull(relation, "relation is null");
        Objects.requireNonNull(alias, "alias is null");
        this.relation = relation;
        this.alias = alias;
        this.columnNames = columnNames;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Identifier getAlias() {
        return this.alias;
    }

    public List<Identifier> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAliasedRelation(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.relation);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("relation", this.relation).add("alias", this.alias).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasedRelation that = (AliasedRelation)o;
        return Objects.equals(this.relation, that.relation) && Objects.equals(this.alias, that.alias) && Objects.equals(this.columnNames, that.columnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relation, this.alias, this.columnNames);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!AliasedRelation.sameClass(this, other)) {
            return false;
        }
        AliasedRelation otherRelation = (AliasedRelation)other;
        return this.alias.equals(otherRelation.alias) && Objects.equals(this.columnNames, otherRelation.columnNames);
    }
}

