/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl.mask;

import io.trino.hive.orc.DataMask;
import io.trino.hive.orc.TypeDescription;
import io.trino.hive.orc.impl.mask.ListIdentity;
import io.trino.hive.orc.impl.mask.MapIdentity;
import io.trino.hive.orc.impl.mask.StructIdentity;
import io.trino.hive.orc.impl.mask.UnionIdentity;
import java.util.List;

public abstract class MaskFactory {
    protected abstract DataMask buildBooleanMask(TypeDescription var1);

    protected abstract DataMask buildLongMask(TypeDescription var1);

    protected abstract DataMask buildDecimalMask(TypeDescription var1);

    protected abstract DataMask buildDoubleMask(TypeDescription var1);

    protected abstract DataMask buildStringMask(TypeDescription var1);

    protected abstract DataMask buildDateMask(TypeDescription var1);

    protected abstract DataMask buildTimestampMask(TypeDescription var1);

    protected abstract DataMask buildBinaryMask(TypeDescription var1);

    public DataMask build(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return this.buildBooleanMask(schema);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return this.buildLongMask(schema);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.buildDoubleMask(schema);
            }
            case DECIMAL: {
                return this.buildDecimalMask(schema);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return this.buildStringMask(schema);
            }
            case TIMESTAMP: {
                return this.buildTimestampMask(schema);
            }
            case DATE: {
                return this.buildDateMask(schema);
            }
            case BINARY: {
                return this.buildBinaryMask(schema);
            }
            case UNION: {
                return this.buildUnionMask(schema);
            }
            case STRUCT: {
                return this.buildStructMask(schema);
            }
            case LIST: {
                return this.buildListMask(schema);
            }
            case MAP: {
                return this.buildMapMask(schema);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    protected DataMask[] buildChildren(List<TypeDescription> children) {
        DataMask[] result = new DataMask[children.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.build(children.get(i));
        }
        return result;
    }

    protected DataMask buildStructMask(TypeDescription schema) {
        return new StructIdentity(this.buildChildren(schema.getChildren()));
    }

    DataMask buildListMask(TypeDescription schema) {
        return new ListIdentity(this.buildChildren(schema.getChildren()));
    }

    DataMask buildMapMask(TypeDescription schema) {
        return new MapIdentity(this.buildChildren(schema.getChildren()));
    }

    DataMask buildUnionMask(TypeDescription schema) {
        return new UnionIdentity(this.buildChildren(schema.getChildren()));
    }
}

