/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import org.apache.hadoop.hive.ql.wm.CounterLimit;

public class VertexCounterLimit
implements CounterLimit {
    private VertexCounter vertexCounter;
    private long limit;

    VertexCounterLimit(VertexCounter vertexCounter, long limit) {
        this.vertexCounter = vertexCounter;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return this.vertexCounter.name();
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public CounterLimit clone() {
        return new VertexCounterLimit(this.vertexCounter, this.limit);
    }

    public String toString() {
        return "counter: " + this.vertexCounter.name() + " limit: " + this.limit;
    }

    public int hashCode() {
        int hash = 31 * this.vertexCounter.hashCode();
        hash = (int)((long)hash + 31L * this.limit);
        return 31 * hash;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof VertexCounterLimit)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        VertexCounterLimit otherVcl = (VertexCounterLimit)other;
        return this.vertexCounter.equals((Object)otherVcl.vertexCounter) && this.limit == otherVcl.limit;
    }

    public static enum VertexCounter {
        DAG_TOTAL_TASKS,
        DAG_GROUPED_INPUT_SPLITS,
        DAG_INPUT_DIRECTORIES,
        DAG_INPUT_FILES,
        DAG_RAW_INPUT_SPLITS,
        VERTEX_TOTAL_TASKS,
        VERTEX_GROUPED_INPUT_SPLITS,
        VERTEX_INPUT_DIRECTORIES,
        VERTEX_INPUT_FILES,
        VERTEX_RAW_INPUT_SPLITS;

    }
}

