/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class HiveTableProperties {
    public static final String EXTERNAL_LOCATION_PROPERTY = "external_location";
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String BUCKETED_BY_PROPERTY = "bucketed_by";
    public static final String BUCKETING_VERSION = "bucketing_version";
    public static final String BUCKET_COUNT_PROPERTY = "bucket_count";
    public static final String SORTED_BY_PROPERTY = "sorted_by";
    public static final String ORC_BLOOM_FILTER_COLUMNS = "orc_bloom_filter_columns";
    public static final String ORC_BLOOM_FILTER_FPP = "orc_bloom_filter_fpp";
    public static final String AVRO_SCHEMA_URL = "avro_schema_url";
    public static final String TEXTFILE_FIELD_SEPARATOR = "textfile_field_separator";
    public static final String TEXTFILE_FIELD_SEPARATOR_ESCAPE = "textfile_field_separator_escape";
    public static final String NULL_FORMAT_PROPERTY = "null_format";
    public static final String SKIP_HEADER_LINE_COUNT = "skip_header_line_count";
    public static final String SKIP_FOOTER_LINE_COUNT = "skip_footer_line_count";
    public static final String CSV_SEPARATOR = "csv_separator";
    public static final String CSV_QUOTE = "csv_quote";
    public static final String CSV_ESCAPE = "csv_escape";
    public static final String TRANSACTIONAL = "transactional";
    public static final String AUTO_PURGE = "auto_purge";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public HiveTableProperties(HiveConfig config, OrcWriterConfig orcWriterConfig) {
        this.tableProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXTERNAL_LOCATION_PROPERTY, (String)"File system location URI for external table", null, (boolean)false), (Object)PropertyMetadata.enumProperty((String)STORAGE_FORMAT_PROPERTY, (String)"Hive storage format for the table", HiveStorageFormat.class, (Enum)config.getHiveStorageFormat(), (boolean)false), (Object)new PropertyMetadata(PARTITIONED_BY_PROPERTY, "Partition columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)new PropertyMetadata(BUCKETED_BY_PROPERTY, "Bucketing columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)new PropertyMetadata(SORTED_BY_PROPERTY, "Bucket sorting columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(String.class::cast).map(HiveUtil::sortingColumnFromString).collect(ImmutableList.toImmutableList()), value -> value.stream().map(SortingColumn.class::cast).map(HiveUtil::sortingColumnToString).collect(ImmutableList.toImmutableList())), (Object)new PropertyMetadata(ORC_BLOOM_FILTER_COLUMNS, "ORC Bloom filter index columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.doubleProperty((String)ORC_BLOOM_FILTER_FPP, (String)"ORC Bloom filter false positive probability", (Double)orcWriterConfig.getDefaultBloomFilterFpp(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)BUCKETING_VERSION, (String)"Bucketing version", null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)BUCKET_COUNT_PROPERTY, (String)"Number of buckets", (Integer)0, (boolean)false), (Object)PropertyMetadata.stringProperty((String)AVRO_SCHEMA_URL, (String)"URI pointing to Avro schema for the table", null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)SKIP_HEADER_LINE_COUNT, (String)"Number of header lines", null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)SKIP_FOOTER_LINE_COUNT, (String)"Number of footer lines", null, (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.stringProperty((String)TEXTFILE_FIELD_SEPARATOR, (String)"TEXTFILE field separator character", null, (boolean)false), PropertyMetadata.stringProperty((String)TEXTFILE_FIELD_SEPARATOR_ESCAPE, (String)"TEXTFILE field separator escape character", null, (boolean)false), PropertyMetadata.stringProperty((String)NULL_FORMAT_PROPERTY, (String)"Serialization format for NULL value", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_SEPARATOR, (String)"CSV separator character", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_QUOTE, (String)"CSV quote character", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_ESCAPE, (String)"CSV escape character", null, (boolean)false), PropertyMetadata.booleanProperty((String)TRANSACTIONAL, (String)"Table is transactional", null, (boolean)false), PropertyMetadata.booleanProperty((String)AUTO_PURGE, (String)"Skip trash when table or partition is deleted", (Boolean)config.isAutoPurge(), (boolean)false), PropertyMetadata.booleanProperty((String)"partition_projection_ignore", (String)"Disable AWS Athena partition projection in Trino only", null, (boolean)false), PropertyMetadata.booleanProperty((String)"partition_projection_enabled", (String)"Enable AWS Athena partition projection", null, (boolean)false), PropertyMetadata.stringProperty((String)"partition_projection_location_template", (String)"Partition projection location template", null, (boolean)false)});
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static String getExternalLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(EXTERNAL_LOCATION_PROPERTY);
    }

    public static String getAvroSchemaUrl(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(AVRO_SCHEMA_URL);
    }

    public static Optional<Integer> getHeaderSkipCount(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Integer)tableProperties.get(SKIP_HEADER_LINE_COUNT));
    }

    public static Optional<Integer> getFooterSkipCount(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Integer)tableProperties.get(SKIP_FOOTER_LINE_COUNT));
    }

    public static Optional<String> getNullFormat(Map<String, Object> tableProperties) {
        return Optional.ofNullable((String)tableProperties.get(NULL_FORMAT_PROPERTY));
    }

    public static HiveStorageFormat getHiveStorageFormat(Map<String, Object> tableProperties) {
        return (HiveStorageFormat)((Object)tableProperties.get(STORAGE_FORMAT_PROPERTY));
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        List partitionedBy = (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
        return partitionedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitionedBy);
    }

    public static Optional<HiveBucketProperty> getBucketProperty(Map<String, Object> tableProperties) {
        List<String> bucketedBy = HiveTableProperties.getBucketedBy(tableProperties);
        List<SortingColumn> sortedBy = HiveTableProperties.getSortedBy(tableProperties);
        int bucketCount = (Integer)tableProperties.get(BUCKET_COUNT_PROPERTY);
        if (bucketedBy.isEmpty() && bucketCount == 0) {
            if (!sortedBy.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s may be specified only when %s is specified", SORTED_BY_PROPERTY, BUCKETED_BY_PROPERTY));
            }
            return Optional.empty();
        }
        if (bucketCount < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be greater than zero", BUCKET_COUNT_PROPERTY));
        }
        if (bucketedBy.isEmpty() || bucketCount == 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s and %s must be specified together", BUCKETED_BY_PROPERTY, BUCKET_COUNT_PROPERTY));
        }
        HiveBucketing.BucketingVersion bucketingVersion = HiveTableProperties.getBucketingVersion(tableProperties);
        return Optional.of(new HiveBucketProperty(bucketedBy, bucketingVersion, bucketCount, sortedBy));
    }

    public static HiveBucketing.BucketingVersion getBucketingVersion(Map<String, Object> tableProperties) {
        Integer property = (Integer)tableProperties.get(BUCKETING_VERSION);
        if (property == null || property == 1) {
            return HiveBucketing.BucketingVersion.BUCKETING_V1;
        }
        if (property == 2) {
            return HiveBucketing.BucketingVersion.BUCKETING_V2;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be between 1 and 2 (inclusive): %s", BUCKETING_VERSION, property));
    }

    private static List<String> getBucketedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(BUCKETED_BY_PROPERTY);
    }

    private static List<SortingColumn> getSortedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(SORTED_BY_PROPERTY);
    }

    public static List<String> getOrcBloomFilterColumns(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(ORC_BLOOM_FILTER_COLUMNS);
    }

    public static Double getOrcBloomFilterFpp(Map<String, Object> tableProperties) {
        return (Double)tableProperties.get(ORC_BLOOM_FILTER_FPP);
    }

    public static Optional<Character> getSingleCharacterProperty(Map<String, Object> tableProperties, String key) {
        Object value = tableProperties.get(key);
        if (value == null) {
            return Optional.empty();
        }
        String stringValue = (String)value;
        if (stringValue.length() != 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be a single character string, but was: '%s'", key, stringValue));
        }
        return Optional.of(Character.valueOf(stringValue.charAt(0)));
    }

    public static Optional<Boolean> isTransactional(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Boolean)tableProperties.get(TRANSACTIONAL));
    }

    public static Optional<Boolean> isAutoPurge(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Boolean)tableProperties.get(AUTO_PURGE));
    }
}

