/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena.projection;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;

public class InjectedProjection
extends Projection {
    public InjectedProjection(String columnName) {
        super(columnName);
    }

    @Override
    public List<String> getProjectedValues(Optional<Domain> partitionValueFilter) {
        if (partitionValueFilter.isEmpty()) {
            throw InjectedProjection.invalidProjectionException(this.getColumnName(), "Injected projection requires single predicate for it's column in where clause");
        }
        Domain domain = partitionValueFilter.get();
        Type type = domain.getType();
        if (!domain.isNullableSingleValue() || !MetastoreUtil.canConvertSqlTypeToStringForParts(type, true)) {
            throw InjectedProjection.invalidProjectionException(this.getColumnName(), "Injected projection requires single predicate for it's column in where clause. Currently provided can't be converted to single partition.");
        }
        return (List)Optional.ofNullable(MetastoreUtil.sqlScalarToString(type, domain.getNullableSingleValue(), null)).map(ImmutableList::of).orElseThrow(() -> this.unsupportedProjectionColumnTypeException(type));
    }
}

