/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena.projection;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IntegerProjection
extends Projection {
    private final int leftBound;
    private final int rightBound;
    private final int interval;
    private final Optional<Integer> digits;

    public IntegerProjection(String columnName, int leftBound, int rightBound, int interval, Optional<Integer> digits) {
        super(columnName);
        this.leftBound = leftBound;
        this.rightBound = rightBound;
        this.interval = interval;
        this.digits = Objects.requireNonNull(digits, "digits is null");
    }

    @Override
    public List<String> getProjectedValues(Optional<Domain> partitionValueFilter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int current = this.leftBound; current <= this.rightBound; current += this.interval) {
            int currentValue = current;
            String currentValueFormatted = this.digits.map(digits -> String.format("%0" + digits + "d", currentValue)).orElse(Integer.toString(current));
            if (!this.isValueInDomain(partitionValueFilter, current, currentValueFormatted)) continue;
            builder.add((Object)currentValueFormatted);
        }
        return builder.build();
    }

    private boolean isValueInDomain(Optional<Domain> valueDomain, int value, String formattedValue) {
        if (valueDomain.isEmpty() || valueDomain.get().isAll()) {
            return true;
        }
        Domain domain = valueDomain.get();
        Type type = domain.getType();
        if (type instanceof VarcharType) {
            return domain.contains(Domain.singleValue((Type)type, (Object)Slices.utf8Slice((String)formattedValue)));
        }
        if (type instanceof IntegerType || type instanceof BigintType) {
            return domain.contains(Domain.singleValue((Type)type, (Object)value));
        }
        throw this.unsupportedProjectionColumnTypeException(type);
    }
}

