/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class GlueCredentialsProvider
implements Provider<AWSCredentialsProvider> {
    private final AWSCredentialsProvider credentialsProvider;

    @Inject
    public GlueCredentialsProvider(GlueHiveMetastoreConfig config) {
        Objects.requireNonNull(config, "config is null");
        if (config.getAwsCredentialsProvider().isPresent()) {
            this.credentialsProvider = GlueCredentialsProvider.getCustomAWSCredentialsProvider(config.getAwsCredentialsProvider().get());
        } else {
            Object provider = config.getAwsAccessKey().isPresent() && config.getAwsSecretKey().isPresent() ? new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.getAwsAccessKey().get(), config.getAwsSecretKey().get())) : DefaultAWSCredentialsProviderChain.getInstance();
            if (config.getIamRole().isPresent()) {
                provider = new STSAssumeRoleSessionCredentialsProvider.Builder(config.getIamRole().get(), "trino-session").withExternalId((String)config.getExternalId().orElse(null)).withLongLivedCredentialsProvider((AWSCredentialsProvider)provider).build();
            }
            this.credentialsProvider = provider;
        }
    }

    public AWSCredentialsProvider get() {
        return this.credentialsProvider;
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(String providerClass) {
        try {
            Object instance = Class.forName(providerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof AWSCredentialsProvider)) {
                throw new RuntimeException("Invalid credentials provider class: " + instance.getClass().getName());
            }
            return (AWSCredentialsProvider)instance;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s", providerClass), e);
        }
    }
}

