/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.RecordFileWriter;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.write.ParquetRecordWriterWrapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.parquet.hadoop.ParquetFileWriter;

public final class ParquetRecordWriter
implements RecordFileWriter.ExtendedRecordWriter {
    private static final Field REAL_WRITER_FIELD;
    private static final Field INTERNAL_WRITER_FIELD;
    private static final Field FILE_WRITER_FIELD;
    private final FileSinkOperator.RecordWriter recordWriter;
    private final ParquetFileWriter fileWriter;
    private long length;

    public static FileSinkOperator.RecordWriter create(Path target, JobConf conf, Properties properties, ConnectorSession session) throws IOException, ReflectiveOperationException {
        conf.setLong("parquet.block.size", HiveSessionProperties.getParquetWriterBlockSize(session).toBytes());
        conf.setLong("parquet.page.size", HiveSessionProperties.getParquetWriterPageSize(session).toBytes());
        FileSinkOperator.RecordWriter recordWriter = new MapredParquetOutputFormat().getHiveRecordWriter(conf, target, Text.class, false, properties, (Progressable)Reporter.NULL);
        Object realWriter = REAL_WRITER_FIELD.get(recordWriter);
        Object internalWriter = INTERNAL_WRITER_FIELD.get(realWriter);
        ParquetFileWriter fileWriter = (ParquetFileWriter)FILE_WRITER_FIELD.get(internalWriter);
        return new ParquetRecordWriter(recordWriter, fileWriter);
    }

    private ParquetRecordWriter(FileSinkOperator.RecordWriter recordWriter, ParquetFileWriter fileWriter) {
        this.recordWriter = Objects.requireNonNull(recordWriter, "recordWriter is null");
        this.fileWriter = Objects.requireNonNull(fileWriter, "fileWriter is null");
    }

    @Override
    public long getWrittenBytes() {
        return this.length;
    }

    public void write(Writable value) throws IOException {
        this.recordWriter.write(value);
        this.length = this.fileWriter.getPos();
    }

    public void close(boolean abort) throws IOException {
        this.recordWriter.close(abort);
        if (!abort) {
            this.length = this.fileWriter.getPos();
        }
    }

    static {
        try {
            REAL_WRITER_FIELD = ParquetRecordWriterWrapper.class.getDeclaredField("realWriter");
            INTERNAL_WRITER_FIELD = org.apache.parquet.hadoop.ParquetRecordWriter.class.getDeclaredField("internalWriter");
            FILE_WRITER_FIELD = INTERNAL_WRITER_FIELD.getType().getDeclaredField("parquetFileWriter");
            REAL_WRITER_FIELD.setAccessible(true);
            INTERNAL_WRITER_FIELD.setAccessible(true);
            FILE_WRITER_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

