/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.inject.Inject;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.trino.plugin.hive.s3.ForS3SecurityMapping;
import io.trino.plugin.hive.s3.S3SecurityMappingConfig;
import io.trino.plugin.hive.s3.S3SecurityMappings;
import io.trino.plugin.hive.s3.S3SecurityMappingsParser;
import io.trino.plugin.hive.s3.S3SecurityMappingsProvider;
import java.net.URI;
import java.util.Objects;

public class UriBasedS3SecurityMappingsProvider
implements S3SecurityMappingsProvider {
    private final URI configUri;
    private final HttpClient httpClient;
    private final S3SecurityMappingsParser parser;

    @Inject
    public UriBasedS3SecurityMappingsProvider(S3SecurityMappingConfig config, @ForS3SecurityMapping HttpClient httpClient) {
        this.configUri = config.getConfigFilePath().map(URI::create).orElseThrow(() -> new IllegalArgumentException("configUri not set"));
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.parser = new S3SecurityMappingsParser(config);
    }

    String getRawJsonString() {
        Request request = Request.Builder.prepareGet().setUri(this.configUri).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        int status = response.getStatusCode();
        if (status != HttpStatus.OK.code()) {
            throw new IllegalStateException(String.format("Request to '%s' returned unexpected status code: '%d'", this.configUri, status));
        }
        return response.getBody();
    }

    @Override
    public S3SecurityMappings get() {
        return this.parser.parseJSONString(this.getRawJsonString());
    }
}

