/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.s3select.IonSqlQueryBuilder;
import io.trino.plugin.hive.s3select.S3SelectDataType;
import io.trino.plugin.hive.s3select.S3SelectLineRecordReader;
import io.trino.plugin.hive.s3select.S3SelectLineRecordReaderProvider;
import io.trino.plugin.hive.s3select.S3SelectRecordCursor;
import io.trino.plugin.hive.s3select.S3SelectSerDeDataTypeMapper;
import io.trino.plugin.hive.s3select.TrinoS3ClientFactory;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class S3SelectRecordCursorProvider
implements HiveRecordCursorProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final TrinoS3ClientFactory s3ClientFactory;

    @Inject
    public S3SelectRecordCursorProvider(HdfsEnvironment hdfsEnvironment, TrinoS3ClientFactory s3ClientFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.s3ClientFactory = Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
    }

    @Override
    public Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> createRecordCursor(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
        if (!s3SelectPushdownEnabled) {
            return Optional.empty();
        }
        try {
            this.hdfsEnvironment.getFileSystem(session.getIdentity(), path, configuration);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        Optional<ReaderColumns> projectedReaderColumns = HivePageSourceProvider.projectBaseColumns(columns);
        effectivePredicate = effectivePredicate.filter((column, domain) -> column.isBaseColumn());
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        Optional<S3SelectDataType> s3SelectDataTypeOptional = S3SelectSerDeDataTypeMapper.getDataType(serdeName);
        if (s3SelectDataTypeOptional.isPresent()) {
            List<HiveColumnHandle> readerColumns;
            S3SelectDataType s3SelectDataType = s3SelectDataTypeOptional.get();
            IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager, s3SelectDataType);
            String ionSqlQuery = queryBuilder.buildSql(readerColumns = projectedReaderColumns.map(ReaderColumns::get).map(readColumns -> readColumns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns), (TupleDomain<HiveColumnHandle>)effectivePredicate);
            Optional<S3SelectLineRecordReader> recordReader = S3SelectLineRecordReaderProvider.get(configuration, path, start, length, schema, ionSqlQuery, this.s3ClientFactory, s3SelectDataType);
            if (recordReader.isEmpty()) {
                return Optional.empty();
            }
            S3SelectRecordCursor cursor = new S3SelectRecordCursor(configuration, path, recordReader.get(), length, schema, readerColumns);
            return Optional.of(new HiveRecordCursorProvider.ReaderRecordCursorWithProjections(cursor, projectedReaderColumns));
        }
        return Optional.empty();
    }
}

