/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;

final class LogFileName
implements Comparable<LogFileName> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("-yyyyMMdd.HHmmss");
    private static final int MAX_GENERATED_INDEX = 1000;
    private final String fileName;
    private final LocalDateTime dateTime;
    private final OptionalInt index;
    private final OptionalInt legacyIndex;
    private final Optional<String> slug;
    private final boolean compressed;

    public static Optional<LogFileName> parseHistoryLogFileName(String masterLogFileName, String historyFileName) {
        Objects.requireNonNull(masterLogFileName, "masterLogFileName is null");
        Objects.requireNonNull(historyFileName, "historyFileName is null");
        if (!historyFileName.startsWith(masterLogFileName + "-")) {
            return Optional.empty();
        }
        String remainder = historyFileName.substring(masterLogFileName.length() + 1);
        boolean compressed = remainder.endsWith(".gz");
        if (compressed) {
            remainder = remainder.substring(0, remainder.length() - ".gz".length());
        }
        if (remainder.isEmpty()) {
            return Optional.empty();
        }
        if (remainder.endsWith(".log")) {
            return LogFileName.parseLegacyLogName(historyFileName, remainder, compressed);
        }
        return LogFileName.parseNewLogName(historyFileName, remainder, compressed);
    }

    private static Optional<LogFileName> parseNewLogName(String historyFileName, String remainder, boolean compressed) {
        LocalDateTime dateTime;
        List parts = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)".-")).limit(3).splitToList((CharSequence)remainder);
        if (parts.size() < 2) {
            return Optional.empty();
        }
        String date = (String)parts.get(0);
        String time = (String)parts.get(1);
        if (date.length() != 8 || time.length() != 6) {
            return Optional.empty();
        }
        try {
            dateTime = LocalDateTime.of(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)), Integer.parseInt(date.substring(6, 8)), Integer.parseInt(time.substring(0, 2)), Integer.parseInt(time.substring(2, 4)), Integer.parseInt(time.substring(4, 6)));
        }
        catch (NumberFormatException | DateTimeException e) {
            return Optional.empty();
        }
        int index = 0;
        Optional<String> slug = Optional.empty();
        if (parts.size() == 3) {
            try {
                index = Integer.parseInt((String)parts.get(2));
            }
            catch (NumberFormatException ignored) {
                slug = Optional.of((String)parts.get(2));
            }
        }
        return Optional.of(new LogFileName(historyFileName, dateTime, OptionalInt.of(index), OptionalInt.empty(), slug, compressed));
    }

    private static Optional<LogFileName> parseLegacyLogName(String historyFileName, String remainder, boolean compressed) {
        LocalDateTime dateTime;
        remainder = remainder.substring(0, remainder.length() - ".log".length());
        List parts = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)".-")).limit(4).splitToList((CharSequence)remainder);
        if (parts.size() != 4) {
            return Optional.empty();
        }
        try {
            dateTime = LocalDateTime.of(Integer.parseInt((String)parts.get(0)), Integer.parseInt((String)parts.get(1)), Integer.parseInt((String)parts.get(2)), 0, 0);
        }
        catch (NumberFormatException | DateTimeException e) {
            return Optional.empty();
        }
        int legacyIndex = -1;
        Optional<String> slug = Optional.empty();
        try {
            legacyIndex = Integer.parseInt((String)parts.get(3));
        }
        catch (NumberFormatException ignored) {
            slug = Optional.of((String)parts.get(3));
        }
        return Optional.of(new LogFileName(historyFileName, dateTime, OptionalInt.empty(), OptionalInt.of(legacyIndex), slug, compressed));
    }

    public static LogFileName generateNextLogFileName(Path masterLogFile, Optional<String> compressionExtension) {
        LocalDateTime dateTime = LocalDateTime.now().withNano(0);
        String suffix = DATE_TIME_FORMATTER.format(dateTime);
        for (int index = 0; index < 1000; ++index) {
            String newFileName = masterLogFile.getFileName() + suffix + (String)(index > 0 ? "-" + index : "");
            Path newFile = masterLogFile.resolveSibling(newFileName);
            if (LogFileName.fileAlreadyExists(newFile, compressionExtension)) continue;
            return new LogFileName(newFileName, dateTime, OptionalInt.of(index), OptionalInt.empty(), Optional.empty(), false);
        }
        String slug = UUID.randomUUID().toString();
        String randomFileName = masterLogFile.getFileName() + suffix + "--" + slug;
        return new LogFileName(randomFileName, dateTime, OptionalInt.of(0), OptionalInt.empty(), Optional.of(slug), false);
    }

    private static boolean fileAlreadyExists(Path newFile, Optional<String> compressionExtension) {
        return Files.exists(newFile, new LinkOption[0]) || compressionExtension.map(extension -> newFile.resolveSibling(newFile.getFileName() + extension)).map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false) != false;
    }

    private LogFileName(String fileName, LocalDateTime dateTime, OptionalInt index, OptionalInt legacyIndex, Optional<String> slug, boolean compressed) {
        this.fileName = Objects.requireNonNull(fileName, "fileName is null");
        this.dateTime = Objects.requireNonNull(dateTime, "dateTime is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.legacyIndex = Objects.requireNonNull(legacyIndex, "legacyIndex is null");
        this.slug = Objects.requireNonNull(slug, "slug is null");
        this.compressed = compressed;
    }

    public String getFileName() {
        return this.fileName;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public OptionalInt getIndex() {
        return this.index;
    }

    public OptionalInt getLegacyIndex() {
        return this.legacyIndex;
    }

    public Optional<String> getSlug() {
        return this.slug;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogFileName that = (LogFileName)o;
        return this.dateTime.equals(that.dateTime) && this.index.equals(that.index) && this.legacyIndex.equals(that.legacyIndex) && this.slug.equals(that.slug);
    }

    public int hashCode() {
        return Objects.hash(this.dateTime, this.index, this.legacyIndex, this.slug);
    }

    @Override
    public int compareTo(LogFileName o) {
        return ComparisonChain.start().compare((Comparable)this.dateTime, (Comparable)o.dateTime).compareTrueFirst(this.index.isPresent(), o.index.isPresent()).compare(this.index.orElse(0), o.index.orElse(0)).compareTrueFirst(this.legacyIndex.isPresent(), o.legacyIndex.isPresent()).compare(-this.legacyIndex.orElse(0), -o.legacyIndex.orElse(0)).compareFalseFirst(this.slug.isPresent(), o.slug.isPresent()).compare((Comparable)((Object)this.slug.orElse("")), (Comparable)((Object)o.slug.orElse(""))).result();
    }

    public String toString() {
        return this.fileName;
    }

    public LogFileName withCompression(Path compressedFile) {
        return new LogFileName(compressedFile.getFileName().toString(), this.dateTime, this.index, this.legacyIndex, this.slug, true);
    }
}

