/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AbstractMasterClient;
import alluxio.AlluxioURI;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CheckAccessPRequest;
import alluxio.grpc.CheckConsistencyPOptions;
import alluxio.grpc.CheckConsistencyPRequest;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.CompleteFilePRequest;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateDirectoryPRequest;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.CreateFilePRequest;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.DeletePRequest;
import alluxio.grpc.FileSystemMasterClientServiceGrpc;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.FreePRequest;
import alluxio.grpc.GetFilePathPRequest;
import alluxio.grpc.GetMountTablePRequest;
import alluxio.grpc.GetNewBlockIdForFilePOptions;
import alluxio.grpc.GetNewBlockIdForFilePRequest;
import alluxio.grpc.GetStateLockHoldersPOptions;
import alluxio.grpc.GetStateLockHoldersPRequest;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.GetStatusPRequest;
import alluxio.grpc.GetSyncPathListPRequest;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.ListStatusPRequest;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.MountPRequest;
import alluxio.grpc.MountPointInfo;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.RenamePRequest;
import alluxio.grpc.ReverseResolvePRequest;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePRequest;
import alluxio.grpc.ServiceType;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAclPRequest;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.SetAttributePRequest;
import alluxio.grpc.StartSyncPRequest;
import alluxio.grpc.StopSyncPRequest;
import alluxio.grpc.UnmountPOptions;
import alluxio.grpc.UnmountPRequest;
import alluxio.grpc.UpdateMountPRequest;
import alluxio.grpc.UpdateUfsModePOptions;
import alluxio.grpc.UpdateUfsModePRequest;
import alluxio.master.MasterClientContext;
import alluxio.retry.RetryUtils;
import alluxio.security.authorization.AclEntry;
import alluxio.shaded.client.com.google.protobuf.ProtocolStringList;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.FileSystemOptions;
import alluxio.wire.SyncPointInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RetryHandlingFileSystemMasterClient
extends AbstractMasterClient
implements FileSystemMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(FileSystemMasterClient.class);
    private FileSystemMasterClientServiceGrpc.FileSystemMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingFileSystemMasterClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.FILE_SYSTEM_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "FileSystemMasterClient";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = FileSystemMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public void checkAccess(AlluxioURI path, CheckAccessPOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.checkAccess(CheckAccessPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), RPC_LOG, "CheckAccess", "path=%s,options=%s", path, options);
    }

    @Override
    public List<AlluxioURI> checkConsistency(AlluxioURI path, CheckConsistencyPOptions options) throws AlluxioStatusException {
        return this.retryRPC(() -> {
            ProtocolStringList inconsistentPaths = this.mClient.checkConsistency(CheckConsistencyPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()).getInconsistentPathsList();
            ArrayList<AlluxioURI> inconsistentUris = new ArrayList<AlluxioURI>(inconsistentPaths.size());
            for (String inconsistentPath : inconsistentPaths) {
                inconsistentUris.add(new AlluxioURI(inconsistentPath));
            }
            return inconsistentUris;
        }, RPC_LOG, "CheckConsistency", "path=%s,options=%s", path, options);
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.createDirectory(CreateDirectoryPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), RPC_LOG, "CreateDirectory", "path=%s,options=%s", path, options);
    }

    @Override
    public URIStatus createFile(AlluxioURI path, CreateFilePOptions options) throws AlluxioStatusException {
        return this.retryRPC(() -> new URIStatus(GrpcUtils.fromProto(this.mClient.createFile(CreateFilePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()).getFileInfo())), RPC_LOG, "CreateFile", "path=%s,options=%s", path, options);
    }

    @Override
    public void completeFile(AlluxioURI path, CompleteFilePOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.completeFile(CompleteFilePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), RPC_LOG, "CompleteFile", "path=%s,options=%s", path, options);
    }

    @Override
    public void delete(AlluxioURI path, DeletePOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.remove(DeletePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), RPC_LOG, "Delete", "path=%s,options=%s", path, options);
    }

    @Override
    public void free(AlluxioURI path, FreePOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.free(FreePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), RPC_LOG, "Free", "path=%s,options=%s", path, options);
    }

    @Override
    public String getFilePath(long fileId) throws AlluxioStatusException {
        return this.retryRPC(() -> this.mClient.getFilePath(GetFilePathPRequest.newBuilder().setFileId(fileId).build()).getPath(), RPC_LOG, "GetFilePath", "fileId=%d", fileId);
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws AlluxioStatusException {
        return this.retryRPC(() -> new URIStatus(GrpcUtils.fromProto(this.mClient.getStatus(GetStatusPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()).getFileInfo())), RPC_LOG, "GetStatus", "path=%s,options=%s", path, options);
    }

    @Override
    public synchronized List<SyncPointInfo> getSyncPathList() throws AlluxioStatusException {
        return this.retryRPC(() -> this.mClient.getSyncPathList(GetSyncPathListPRequest.getDefaultInstance()).getSyncPathsList().stream().map(x -> SyncPointInfo.fromProto(x)).collect(Collectors.toList()), RPC_LOG, "GetSyncPathList", "", new Object[0]);
    }

    @Override
    public long getNewBlockIdForFile(AlluxioURI path) throws AlluxioStatusException {
        return this.retryRPC(() -> this.mClient.getNewBlockIdForFile(GetNewBlockIdForFilePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(GetNewBlockIdForFilePOptions.newBuilder().build()).build()).getId(), RPC_LOG, "GetNewBlockIdForFile", "path=%s", path);
    }

    @Override
    public Map<String, alluxio.wire.MountPointInfo> getMountTable() throws AlluxioStatusException {
        return this.retryRPC(() -> {
            HashMap<String, alluxio.wire.MountPointInfo> mountTableWire = new HashMap<String, alluxio.wire.MountPointInfo>();
            for (Map.Entry<String, MountPointInfo> entry : this.mClient.getMountTable(GetMountTablePRequest.newBuilder().build()).getMountPointsMap().entrySet()) {
                mountTableWire.put(entry.getKey(), GrpcUtils.fromProto(entry.getValue()));
            }
            return mountTableWire;
        }, RPC_LOG, "GetMountTable", "", new Object[0]);
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) throws AlluxioStatusException {
        this.retryRPC(RetryUtils.noRetryPolicy(), () -> {
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.mClient.listStatus(ListStatusPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), 16), false).flatMap(pListStatusResponse -> pListStatusResponse.getFileInfosList().stream().map(pFileInfo -> new URIStatus(GrpcUtils.fromProto(pFileInfo)))).forEach(action);
            return null;
        }, RPC_LOG, "ListStatus", "path=%s,options=%s", path, options);
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws AlluxioStatusException {
        return this.retryRPC(() -> {
            ArrayList result = new ArrayList();
            this.mClient.listStatus(ListStatusPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()).forEachRemaining(pListStatusResponse -> result.addAll(pListStatusResponse.getFileInfosList().stream().map(pFileInfo -> new URIStatus(GrpcUtils.fromProto(pFileInfo))).collect(Collectors.toList())));
            return result;
        }, RPC_LOG, "ListStatus", "path=%s,options=%s", path, options);
    }

    @Override
    public void mount(AlluxioURI alluxioPath, AlluxioURI ufsPath, MountPOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.mount(MountPRequest.newBuilder().setAlluxioPath(alluxioPath.toString()).setUfsPath(ufsPath.toString()).setOptions(options).build()), RPC_LOG, "Mount", "alluxioPath=%s,ufsPath=%s,options=%s", alluxioPath, ufsPath, options);
    }

    @Override
    public void updateMount(AlluxioURI alluxioPath, MountPOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.updateMount(UpdateMountPRequest.newBuilder().setAlluxioPath(alluxioPath.toString()).setOptions(options).build()), RPC_LOG, "UpdateMount", "path=%s,options=%s", alluxioPath, options);
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst) throws AlluxioStatusException {
        this.rename(src, dst, FileSystemOptions.renameDefaults(this.mContext.getClusterConf()));
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.rename(RenamePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(src)).setDstPath(RetryHandlingFileSystemMasterClient.getTransportPath(dst)).setOptions(options).build()), RPC_LOG, "Rename", "src=%s,dst=%s,options=%s", src, dst, options);
    }

    @Override
    public AlluxioURI reverseResolve(AlluxioURI ufsUri) throws AlluxioStatusException {
        return this.retryRPC(() -> new AlluxioURI(this.mClient.reverseResolve(ReverseResolvePRequest.newBuilder().setUfsUri(ufsUri.toString()).build()).getAlluxioPath()), RPC_LOG, "ReverseResolve", "ufsUri=%s", ufsUri);
    }

    @Override
    public void setAcl(AlluxioURI path, SetAclAction action, List<AclEntry> entries, SetAclPOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.setAcl(SetAclPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setAction(action).addAllEntries(entries.stream().map(GrpcUtils::toProto).collect(Collectors.toList())).setOptions(options).build()), RPC_LOG, "SetAcl", "path=%s,action=%s,entries=%s,options=%s", path, action, entries, options);
    }

    @Override
    public void setAttribute(AlluxioURI path, SetAttributePOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.setAttribute(SetAttributePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), RPC_LOG, "SetAttribute", "path=%s,options=%s", path, options);
    }

    @Override
    public void scheduleAsyncPersist(AlluxioURI path, ScheduleAsyncPersistencePOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.scheduleAsyncPersistence(ScheduleAsyncPersistencePRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).setOptions(options).build()), RPC_LOG, "ScheduleAsyncPersist", "path=%s,options=%s", path, options);
    }

    @Override
    public synchronized void startSync(AlluxioURI path) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.startSync(StartSyncPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).build()), RPC_LOG, "StartSync", "path=%s", path);
    }

    @Override
    public synchronized void stopSync(AlluxioURI path) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.stopSync(StopSyncPRequest.newBuilder().setPath(RetryHandlingFileSystemMasterClient.getTransportPath(path)).build()), RPC_LOG, "StopSync", "path=%s", path);
    }

    @Override
    public void unmount(AlluxioURI alluxioPath) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.unmount(UnmountPRequest.newBuilder().setAlluxioPath(RetryHandlingFileSystemMasterClient.getTransportPath(alluxioPath)).setOptions(UnmountPOptions.newBuilder().build()).build()), RPC_LOG, "Unmount", "path=%s", alluxioPath);
    }

    @Override
    public void updateUfsMode(AlluxioURI ufsUri, UpdateUfsModePOptions options) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.updateUfsMode(UpdateUfsModePRequest.newBuilder().setUfsPath(ufsUri.getRootPath()).setOptions(options).build()), RPC_LOG, "UpdateUfsMode", "ufsUri=%s,options=%s", ufsUri, options);
    }

    @Override
    public List<String> getStateLockHolders() throws AlluxioStatusException {
        return this.retryRPC(() -> {
            ArrayList result = new ArrayList();
            this.mClient.getStateLockHolders(GetStateLockHoldersPRequest.newBuilder().setOptions(GetStateLockHoldersPOptions.newBuilder().build()).build()).getThreadsList().forEach(thread -> result.add(thread));
            return result;
        }, RPC_LOG, "GetStateLockHolders", "", new Object[0]);
    }

    private static String getTransportPath(AlluxioURI uri) {
        if (uri.hasScheme() && !uri.getScheme().equals("alluxio")) {
            return uri.toString();
        }
        return uri.getPath();
    }
}

