/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.plugin.base.expression.ConnectorExpressions;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConstraintExtractor {
    private ConstraintExtractor() {
    }

    public static ExtractionResult extractTupleDomain(Constraint constraint) {
        TupleDomain result = constraint.getSummary().transformKeys(IcebergColumnHandle.class::cast);
        ImmutableList.Builder remainingExpressions = ImmutableList.builder();
        for (ConnectorExpression conjunct : ConnectorExpressions.extractConjuncts((ConnectorExpression)constraint.getExpression())) {
            Optional<TupleDomain<IcebergColumnHandle>> converted = ConstraintExtractor.toTupleDomain(conjunct, (Map<String, ColumnHandle>)constraint.getAssignments());
            if (converted.isEmpty()) {
                remainingExpressions.add((Object)conjunct);
                continue;
            }
            if (!(result = result.intersect(converted.get())).isNone()) continue;
            return new ExtractionResult((TupleDomain<IcebergColumnHandle>)TupleDomain.none(), (ConnectorExpression)Constant.TRUE);
        }
        return new ExtractionResult((TupleDomain<IcebergColumnHandle>)result, ConnectorExpressions.and((List)remainingExpressions.build()));
    }

    private static Optional<TupleDomain<IcebergColumnHandle>> toTupleDomain(ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        if (expression instanceof Call) {
            return ConstraintExtractor.toTupleDomain((Call)expression, assignments);
        }
        return Optional.empty();
    }

    private static Optional<TupleDomain<IcebergColumnHandle>> toTupleDomain(Call call, Map<String, ColumnHandle> assignments) {
        if (call.getArguments().size() == 2) {
            ConnectorExpression firstArgument = (ConnectorExpression)call.getArguments().get(0);
            ConnectorExpression secondArgument = (ConnectorExpression)call.getArguments().get(1);
            if (firstArgument instanceof Call && ((Call)firstArgument).getFunctionName().equals((Object)StandardFunctions.CAST_FUNCTION_NAME) && secondArgument instanceof Constant && firstArgument.getType().equals(secondArgument.getType())) {
                return ConstraintExtractor.unwrapCastInComparison(call.getFunctionName(), (ConnectorExpression)Iterables.getOnlyElement((Iterable)((Call)firstArgument).getArguments()), (Constant)secondArgument, assignments);
            }
        }
        return Optional.empty();
    }

    private static Optional<TupleDomain<IcebergColumnHandle>> unwrapCastInComparison(FunctionName functionName, ConnectorExpression castSource, Constant constant, Map<String, ColumnHandle> assignments) {
        if (!(castSource instanceof Variable)) {
            return Optional.empty();
        }
        if (constant.getValue() == null) {
            return Optional.empty();
        }
        IcebergColumnHandle column = ConstraintExtractor.resolve((Variable)castSource, assignments);
        if (column.getType() instanceof TimestampWithTimeZoneType) {
            Preconditions.checkArgument((((TimestampWithTimeZoneType)column.getType()).getPrecision() == 6 ? 1 : 0) != 0, (String)"Unexpected type: %s", (Object)column.getType());
            if (constant.getType() == DateType.DATE) {
                return ConstraintExtractor.unwrapTimestampTzToDateCast(column, functionName, (Long)constant.getValue()).map(domain -> TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)));
            }
        }
        return Optional.empty();
    }

    private static Optional<Domain> unwrapTimestampTzToDateCast(IcebergColumnHandle column, FunctionName functionName, long date) {
        Type type = column.getType();
        Preconditions.checkArgument((boolean)type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS), (String)"Column of unexpected type %s: %s ", (Object)type, (Object)column);
        Verify.verify((date <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Date value out of range: %s", (long)date);
        LongTimestampWithTimeZone startOfDate = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(date * 86400000L), (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone startOfNextDate = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)((date + 1L) * 86400000L), (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        if (functionName.equals((Object)StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)startOfDate, (boolean)true, (Object)startOfNextDate, (boolean)false), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfDate), (Range[])new Range[]{Range.greaterThanOrEqual((Type)type, (Object)startOfNextDate)}), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfNextDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)startOfNextDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)startOfDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfDate), (Range[])new Range[]{Range.greaterThanOrEqual((Type)type, (Object)startOfNextDate)}), (boolean)true));
        }
        return Optional.empty();
    }

    private static IcebergColumnHandle resolve(Variable variable, Map<String, ColumnHandle> assignments) {
        ColumnHandle columnHandle = assignments.get(variable.getName());
        Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"No assignment for %s", (Object)variable);
        return (IcebergColumnHandle)columnHandle;
    }

    public static class ExtractionResult {
        private final TupleDomain<IcebergColumnHandle> tupleDomain;
        private final ConnectorExpression remainingExpression;

        public ExtractionResult(TupleDomain<IcebergColumnHandle> tupleDomain, ConnectorExpression remainingExpression) {
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
            this.remainingExpression = Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }

        public TupleDomain<IcebergColumnHandle> getTupleDomain() {
            return this.tupleDomain;
        }

        public ConnectorExpression getRemainingExpression() {
            return this.remainingExpression;
        }
    }
}

