/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.iceberg.HdfsInputFile;
import io.trino.plugin.iceberg.HdfsOutputFile;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;

public class HdfsFileIo
implements FileIO {
    private final HdfsEnvironment environment;
    private final HdfsEnvironment.HdfsContext context;

    public HdfsFileIo(HdfsEnvironment environment, HdfsEnvironment.HdfsContext context) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    public InputFile newInputFile(String path) {
        return new HdfsInputFile(new Path(path), this.environment, this.context);
    }

    public OutputFile newOutputFile(String path) {
        return new HdfsOutputFile(new Path(path), this.environment, this.context);
    }

    public void deleteFile(String pathString) {
        Path path = new Path(pathString);
        try {
            this.environment.doAs(this.context.getIdentity(), () -> this.environment.getFileSystem(this.context, path).delete(path, false));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to delete file: " + path, (Throwable)e);
        }
    }
}

