/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.iceberg.HdfsInputFile;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;

public class HdfsOutputFile
implements OutputFile {
    private final OutputFile delegate;
    private final Path path;
    private final HdfsEnvironment environment;
    private final HdfsEnvironment.HdfsContext context;

    public HdfsOutputFile(Path path, HdfsEnvironment environment, HdfsEnvironment.HdfsContext context) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
        try {
            this.delegate = HadoopOutputFile.fromPath((Path)path, (FileSystem)environment.getFileSystem(context, path), (Configuration)environment.getConfiguration(context, path));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to create output file: " + path.toString(), (Throwable)e);
        }
    }

    public PositionOutputStream create() {
        return (PositionOutputStream)this.environment.doAs(this.context.getIdentity(), () -> ((OutputFile)this.delegate).create());
    }

    public PositionOutputStream createOrOverwrite() {
        return (PositionOutputStream)this.environment.doAs(this.context.getIdentity(), () -> ((OutputFile)this.delegate).createOrOverwrite());
    }

    public String location() {
        return this.delegate.location();
    }

    public InputFile toInputFile() {
        return new HdfsInputFile(this.path, this.environment, this.context);
    }
}

