/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.iceberg.CatalogType;
import io.trino.plugin.iceberg.IcebergFileFormat;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class IcebergConfig {
    public static final int FORMAT_VERSION_SUPPORT_MIN = 1;
    public static final int FORMAT_VERSION_SUPPORT_MAX = 2;
    public static final String EXPIRE_SNAPSHOTS_MIN_RETENTION = "iceberg.expire_snapshots.min-retention";
    public static final String REMOVE_ORPHAN_FILES_MIN_RETENTION = "iceberg.remove_orphan_files.min-retention";
    private IcebergFileFormat fileFormat = IcebergFileFormat.ORC;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.ZSTD;
    private boolean useFileSizeFromMetadata = true;
    private int maxPartitionsPerWriter = 100;
    private boolean uniqueTableLocation = true;
    private CatalogType catalogType = CatalogType.HIVE_METASTORE;
    private Duration dynamicFilteringWaitTimeout = new Duration(0.0, TimeUnit.SECONDS);
    private boolean tableStatisticsEnabled = true;
    private boolean projectionPushdownEnabled = true;
    private Optional<String> hiveCatalogName = Optional.empty();
    private int formatVersion = 2;
    private Duration expireSnapshotsMinRetention = new Duration(7.0, TimeUnit.DAYS);
    private Duration removeOrphanFilesMinRetention = new Duration(7.0, TimeUnit.DAYS);
    private DataSize targetMaxFileSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private boolean deleteSchemaLocationsFallback;
    private double minimumAssignedSplitWeight = 0.05;
    private boolean allowLegacySnapshotSyntax;
    private Optional<String> materializedViewsStorageSchema = Optional.empty();

    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    @Config(value="iceberg.catalog.type")
    public IcebergConfig setCatalogType(CatalogType catalogType) {
        this.catalogType = catalogType;
        return this;
    }

    @NotNull
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @Config(value="iceberg.file-format")
    public IcebergConfig setFileFormat(IcebergFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="iceberg.compression-codec")
    public IcebergConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    @Deprecated
    public boolean isUseFileSizeFromMetadata() {
        return this.useFileSizeFromMetadata;
    }

    @Deprecated
    @Config(value="iceberg.use-file-size-from-metadata")
    public IcebergConfig setUseFileSizeFromMetadata(boolean useFileSizeFromMetadata) {
        this.useFileSizeFromMetadata = useFileSizeFromMetadata;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="iceberg.max-partitions-per-writer")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public IcebergConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    public boolean isUniqueTableLocation() {
        return this.uniqueTableLocation;
    }

    @Config(value="iceberg.unique-table-location")
    @ConfigDescription(value="Use randomized, unique table locations")
    public IcebergConfig setUniqueTableLocation(boolean uniqueTableLocation) {
        this.uniqueTableLocation = uniqueTableLocation;
        return this;
    }

    @NotNull
    public Duration getDynamicFilteringWaitTimeout() {
        return this.dynamicFilteringWaitTimeout;
    }

    @Config(value="iceberg.dynamic-filtering.wait-timeout")
    @ConfigDescription(value="Duration to wait for completion of dynamic filters during split generation")
    public IcebergConfig setDynamicFilteringWaitTimeout(Duration dynamicFilteringWaitTimeout) {
        this.dynamicFilteringWaitTimeout = dynamicFilteringWaitTimeout;
        return this;
    }

    @Config(value="iceberg.table-statistics-enabled")
    @ConfigDescription(value="Enable use of table statistics")
    public IcebergConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    public boolean isProjectionPushdownEnabled() {
        return this.projectionPushdownEnabled;
    }

    @Config(value="iceberg.projection-pushdown-enabled")
    @ConfigDescription(value="Read only required fields from a struct")
    public IcebergConfig setProjectionPushdownEnabled(boolean projectionPushdownEnabled) {
        this.projectionPushdownEnabled = projectionPushdownEnabled;
        return this;
    }

    public Optional<String> getHiveCatalogName() {
        return this.hiveCatalogName;
    }

    @Config(value="iceberg.hive-catalog-name")
    @ConfigDescription(value="Catalog to redirect to when a Hive table is referenced")
    public IcebergConfig setHiveCatalogName(String hiveCatalogName) {
        this.hiveCatalogName = Optional.ofNullable(hiveCatalogName);
        return this;
    }

    @Min(value=1L)
    @Max(value=2L)
    public @Min(value=1L) @Max(value=2L) int getFormatVersion() {
        return this.formatVersion;
    }

    @Config(value="iceberg.format-version")
    @ConfigDescription(value="Default Iceberg table format version")
    public IcebergConfig setFormatVersion(int formatVersion) {
        this.formatVersion = formatVersion;
        return this;
    }

    @NotNull
    public Duration getExpireSnapshotsMinRetention() {
        return this.expireSnapshotsMinRetention;
    }

    @Config(value="iceberg.expire_snapshots.min-retention")
    @ConfigDescription(value="Minimal retention period for expire_snapshot procedure")
    public IcebergConfig setExpireSnapshotsMinRetention(Duration expireSnapshotsMinRetention) {
        this.expireSnapshotsMinRetention = expireSnapshotsMinRetention;
        return this;
    }

    @NotNull
    public Duration getRemoveOrphanFilesMinRetention() {
        return this.removeOrphanFilesMinRetention;
    }

    @Config(value="iceberg.remove_orphan_files.min-retention")
    @ConfigDescription(value="Minimal retention period for remove_orphan_files procedure")
    public IcebergConfig setRemoveOrphanFilesMinRetention(Duration removeOrphanFilesMinRetention) {
        this.removeOrphanFilesMinRetention = removeOrphanFilesMinRetention;
        return this;
    }

    public DataSize getTargetMaxFileSize() {
        return this.targetMaxFileSize;
    }

    @LegacyConfig(value={"hive.target-max-file-size"})
    @Config(value="iceberg.target-max-file-size")
    @ConfigDescription(value="Target maximum size of written files; the actual size may be larger")
    public IcebergConfig setTargetMaxFileSize(DataSize targetMaxFileSize) {
        this.targetMaxFileSize = targetMaxFileSize;
        return this;
    }

    public boolean isDeleteSchemaLocationsFallback() {
        return this.deleteSchemaLocationsFallback;
    }

    @LegacyConfig(value={"hive.delete-schema-locations-fallback"})
    @Config(value="iceberg.delete-schema-locations-fallback")
    @ConfigDescription(value="Whether schema locations should be deleted when Trino can't determine whether they contain external files.")
    public IcebergConfig setDeleteSchemaLocationsFallback(boolean deleteSchemaLocationsFallback) {
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        return this;
    }

    @Config(value="iceberg.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned")
    public IcebergConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }

    @Config(value="iceberg.allow-legacy-snapshot-syntax")
    @Deprecated
    public IcebergConfig setAllowLegacySnapshotSyntax(boolean allowLegacySnapshotSyntax) {
        this.allowLegacySnapshotSyntax = allowLegacySnapshotSyntax;
        return this;
    }

    @Deprecated
    public boolean isAllowLegacySnapshotSyntax() {
        return this.allowLegacySnapshotSyntax;
    }

    @NotNull
    public Optional<String> getMaterializedViewsStorageSchema() {
        return this.materializedViewsStorageSchema;
    }

    @Config(value="iceberg.materialized-views.storage-schema")
    @ConfigDescription(value="Schema for creating materialized views storage tables")
    public IcebergConfig setMaterializedViewsStorageSchema(String materializedViewsStorageSchema) {
        this.materializedViewsStorageSchema = Optional.ofNullable(materializedViewsStorageSchema);
        return this;
    }
}

