/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.trino.plugin.base.Versions;
import io.trino.plugin.iceberg.InternalIcebergConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IcebergConnectorFactory
implements ConnectorFactory {
    private final Class<? extends Module> module;

    public IcebergConnectorFactory() {
        this(EmptyModule.class);
    }

    public IcebergConnectorFactory(Class<? extends Module> module) {
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public String getName() {
        return "iceberg";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkSpiVersion((ConnectorContext)context, (ConnectorFactory)this);
        ClassLoader classLoader = context.duplicatePluginClassLoader();
        try {
            Object moduleInstance = classLoader.loadClass(this.module.getName()).getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> moduleClass = classLoader.loadClass(Module.class.getName());
            return (Connector)classLoader.loadClass(InternalIcebergConnectorFactory.class.getName()).getMethod("createConnector", String.class, Map.class, ConnectorContext.class, moduleClass, Optional.class, Optional.class).invoke(null, catalogName, config, context, moduleInstance, Optional.empty(), Optional.empty());
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            Throwables.throwIfUnchecked((Throwable)targetException);
            throw new RuntimeException(targetException);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class EmptyModule
    implements Module {
        public void configure(Binder binder) {
        }
    }
}

