/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;

public final class PartitionFields {
    private static final String NAME = "[a-z_][a-z0-9_]*";
    private static final String FUNCTION_ARGUMENT_NAME = "\\(([a-z_][a-z0-9_]*)\\)";
    private static final String FUNCTION_ARGUMENT_NAME_AND_INT = "\\(([a-z_][a-z0-9_]*), *(\\d+)\\)";
    private static final Pattern IDENTITY_PATTERN = Pattern.compile("[a-z_][a-z0-9_]*");
    private static final Pattern YEAR_PATTERN = Pattern.compile("year\\(([a-z_][a-z0-9_]*)\\)");
    private static final Pattern MONTH_PATTERN = Pattern.compile("month\\(([a-z_][a-z0-9_]*)\\)");
    private static final Pattern DAY_PATTERN = Pattern.compile("day\\(([a-z_][a-z0-9_]*)\\)");
    private static final Pattern HOUR_PATTERN = Pattern.compile("hour\\(([a-z_][a-z0-9_]*)\\)");
    private static final Pattern BUCKET_PATTERN = Pattern.compile("bucket\\(([a-z_][a-z0-9_]*), *(\\d+)\\)");
    private static final Pattern TRUNCATE_PATTERN = Pattern.compile("truncate\\(([a-z_][a-z0-9_]*), *(\\d+)\\)");
    private static final Pattern VOID_PATTERN = Pattern.compile("void\\(([a-z_][a-z0-9_]*)\\)");
    private static final Pattern ICEBERG_BUCKET_PATTERN = Pattern.compile("bucket\\[(\\d+)]");
    private static final Pattern ICEBERG_TRUNCATE_PATTERN = Pattern.compile("truncate\\[(\\d+)]");

    private PartitionFields() {
    }

    public static PartitionSpec parsePartitionFields(Schema schema, List<String> fields) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        for (String field : fields) {
            PartitionFields.parsePartitionField(builder, field);
        }
        return builder.build();
    }

    public static void parsePartitionField(PartitionSpec.Builder builder, String field) {
        boolean matched;
        boolean bl = PartitionFields.tryMatch(field, IDENTITY_PATTERN, match -> builder.identity(match.group())) || PartitionFields.tryMatch(field, YEAR_PATTERN, match -> builder.year(match.group(1))) || PartitionFields.tryMatch(field, MONTH_PATTERN, match -> builder.month(match.group(1))) || PartitionFields.tryMatch(field, DAY_PATTERN, match -> builder.day(match.group(1))) || PartitionFields.tryMatch(field, HOUR_PATTERN, match -> builder.hour(match.group(1))) || PartitionFields.tryMatch(field, BUCKET_PATTERN, match -> builder.bucket(match.group(1), Integer.parseInt(match.group(2)))) || PartitionFields.tryMatch(field, TRUNCATE_PATTERN, match -> builder.truncate(match.group(1), Integer.parseInt(match.group(2)))) || PartitionFields.tryMatch(field, VOID_PATTERN, match -> builder.alwaysNull(match.group(1))) ? true : (matched = false);
        if (!matched) {
            throw new IllegalArgumentException("Invalid partition field declaration: " + field);
        }
    }

    private static boolean tryMatch(CharSequence value, Pattern pattern, Consumer<MatchResult> match) {
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            match.accept(matcher.toMatchResult());
            return true;
        }
        return false;
    }

    public static List<String> toPartitionFields(PartitionSpec spec) {
        return (List)spec.fields().stream().map(field -> PartitionFields.toPartitionField(spec, field)).collect(ImmutableList.toImmutableList());
    }

    private static String toPartitionField(PartitionSpec spec, PartitionField field) {
        String transform;
        String name = spec.schema().findColumnName(field.sourceId());
        switch (transform = field.transform().toString()) {
            case "identity": {
                return name;
            }
            case "year": 
            case "month": 
            case "day": 
            case "hour": 
            case "void": {
                return String.format("%s(%s)", transform, name);
            }
        }
        Matcher matcher = ICEBERG_BUCKET_PATTERN.matcher(transform);
        if (matcher.matches()) {
            return String.format("bucket(%s, %s)", name, matcher.group(1));
        }
        matcher = ICEBERG_TRUNCATE_PATTERN.matcher(transform);
        if (matcher.matches()) {
            return String.format("truncate(%s, %s)", name, matcher.group(1));
        }
        throw new UnsupportedOperationException("Unsupported partition transform: " + field);
    }
}

