/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.iceberg.Table;

public class RollbackToSnapshotProcedure
implements Provider<Procedure> {
    private static final MethodHandle ROLLBACK_TO_SNAPSHOT = MethodHandleUtil.methodHandle(RollbackToSnapshotProcedure.class, (String)"rollbackToSnapshot", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, Long.class});
    private final TrinoCatalogFactory catalogFactory;
    private final ClassLoader classLoader;

    @Inject
    public RollbackToSnapshotProcedure(TrinoCatalogFactory catalogFactory) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        this.classLoader = this.getClass().getClassLoader();
    }

    public Procedure get() {
        return new Procedure("system", "rollback_to_snapshot", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("SNAPSHOT_ID", (Type)BigintType.BIGINT)), ROLLBACK_TO_SNAPSHOT.bindTo(this));
    }

    public void rollbackToSnapshot(ConnectorSession clientSession, String schema, String table, Long snapshotId) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            SchemaTableName schemaTableName = new SchemaTableName(schema, table);
            Table icebergTable = this.catalogFactory.create(clientSession.getIdentity()).loadTable(clientSession, schemaTableName);
            icebergTable.manageSnapshots().setCurrentSnapshot(snapshotId.longValue()).commit();
        }
    }
}

