/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public final class TrinoTypes {
    private TrinoTypes() {
    }

    public static Optional<Object> getPreviousValue(Type type, Object value) {
        if (!type.isOrderable()) {
            throw new IllegalArgumentException("Type is not orderable: " + type);
        }
        Objects.requireNonNull(value, "value is null");
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT) {
            Type.Range typeRange = (Type.Range)type.getRange().orElseThrow();
            return TrinoTypes.getAdjacentValue((Long)typeRange.getMin(), (Long)typeRange.getMax(), (Long)value, Direction.PREV);
        }
        if (type == DateType.DATE) {
            Verify.verify((boolean)type.getRange().isEmpty(), (String)"Type %s unexpectedly returned a range", (Object)type);
            return TrinoTypes.getAdjacentValue(Integer.MIN_VALUE, Integer.MAX_VALUE, (Long)value, Direction.PREV);
        }
        if (type instanceof TimestampType) {
            Preconditions.checkArgument((((TimestampType)type).getPrecision() == 6 ? 1 : 0) != 0, (String)"Unexpected type: %s", (Object)type);
            Verify.verify((boolean)type.getRange().isEmpty(), (String)"Type %s unexpectedly returned a range", (Object)type);
            return TrinoTypes.getAdjacentValue(Long.MIN_VALUE, Long.MAX_VALUE, (Long)value, Direction.PREV);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            Preconditions.checkArgument((((TimestampWithTimeZoneType)type).getPrecision() == 6 ? 1 : 0) != 0, (String)"Unexpected type: %s", (Object)type);
            Verify.verify((boolean)type.getRange().isEmpty(), (String)"Type %s unexpectedly returned a range", (Object)type);
            LongTimestampWithTimeZone timestampTzValue = (LongTimestampWithTimeZone)value;
            long epochMillis = timestampTzValue.getEpochMillis();
            int picosOfMilli = timestampTzValue.getPicosOfMilli();
            if ((picosOfMilli -= 1000000) < 0) {
                if (epochMillis == Long.MIN_VALUE) {
                    return Optional.empty();
                }
                --epochMillis;
                picosOfMilli += 1000000000;
            }
            return Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMilli, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        }
        return Optional.empty();
    }

    public static Optional<Object> getNextValue(Type type, Object value) {
        if (!type.isOrderable()) {
            throw new IllegalArgumentException("Type is not orderable: " + type);
        }
        Objects.requireNonNull(value, "value is null");
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT) {
            Type.Range typeRange = (Type.Range)type.getRange().orElseThrow();
            return TrinoTypes.getAdjacentValue((Long)typeRange.getMin(), (Long)typeRange.getMax(), (Long)value, Direction.NEXT);
        }
        if (type == DateType.DATE) {
            Verify.verify((boolean)type.getRange().isEmpty(), (String)"Type %s unexpectedly returned a range", (Object)type);
            return TrinoTypes.getAdjacentValue(Integer.MIN_VALUE, Integer.MAX_VALUE, (Long)value, Direction.NEXT);
        }
        if (type instanceof TimestampType) {
            Preconditions.checkArgument((((TimestampType)type).getPrecision() == 6 ? 1 : 0) != 0, (String)"Unexpected type: %s", (Object)type);
            Verify.verify((boolean)type.getRange().isEmpty(), (String)"Type %s unexpectedly returned a range", (Object)type);
            return TrinoTypes.getAdjacentValue(Long.MIN_VALUE, Long.MAX_VALUE, (Long)value, Direction.NEXT);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            Preconditions.checkArgument((((TimestampWithTimeZoneType)type).getPrecision() == 6 ? 1 : 0) != 0, (String)"Unexpected type: %s", (Object)type);
            Verify.verify((boolean)type.getRange().isEmpty(), (String)"Type %s unexpectedly returned a range", (Object)type);
            LongTimestampWithTimeZone timestampTzValue = (LongTimestampWithTimeZone)value;
            long epochMillis = timestampTzValue.getEpochMillis();
            int picosOfMilli = timestampTzValue.getPicosOfMilli();
            if ((picosOfMilli += 1000000) >= 1000000000) {
                if (epochMillis == Long.MAX_VALUE) {
                    return Optional.empty();
                }
                ++epochMillis;
                picosOfMilli -= 1000000000;
            }
            return Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMilli, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        }
        return Optional.empty();
    }

    private static Optional<Object> getAdjacentValue(long min, long max, long value, Direction direction) {
        switch (direction) {
            case PREV: {
                if (value == min) {
                    return Optional.empty();
                }
                return Optional.of(value - 1L);
            }
            case NEXT: {
                if (value == max) {
                    return Optional.empty();
                }
                return Optional.of(value + 1L);
            }
        }
        throw new UnsupportedOperationException("Unsupported direction: " + direction);
    }

    private static enum Direction {
        PREV,
        NEXT;

    }
}

