/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.io.FileIO;

@NotThreadSafe
public abstract class AbstractMetastoreTableOperations
extends AbstractIcebergTableOperations {
    protected final CachingHiveMetastore metastore;

    protected AbstractMetastoreTableOperations(FileIO fileIo, CachingHiveMetastore metastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    protected final String getRefreshedLocation(boolean invalidateCaches) {
        Table table;
        if (invalidateCaches) {
            this.metastore.invalidateTable(this.database, this.tableName);
        }
        if (ViewReaderUtil.isPrestoView((Table)(table = this.getTable())) && ViewReaderUtil.isHiveOrPrestoView((Table)table)) {
            throw new TableNotFoundException(this.getSchemaTableName());
        }
        if (!IcebergUtil.isIcebergTable(table)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)table.getParameters().get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", "metadata_location", this.getSchemaTableName()));
        }
        return metadataLocation;
    }

    @Override
    protected final void commitNewTable(TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version + 1);
        Table.Builder builder = Table.builder().setDatabaseName(this.database).setTableName(this.tableName).setOwner(this.owner).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(AbstractMetastoreTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).withStorage(storage -> storage.setStorageFormat(STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("table_type", "iceberg").setParameter("metadata_location", newMetadataLocation);
        String tableComment = (String)metadata.properties().get("comment");
        if (tableComment != null) {
            builder.setParameter("comment", tableComment);
        }
        Table table = builder.build();
        PrincipalPrivileges privileges = this.owner.map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
        this.metastore.createTable(table, privileges);
    }

    protected Table getTable() {
        return (Table)this.metastore.getTable(this.database, this.tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()));
    }
}

