/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSchemaProperties;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergSchemaProperties;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.io.FileIO;

public class TrinoHiveCatalog
extends AbstractTrinoCatalog {
    private static final Logger log = Logger.get(TrinoHiveCatalog.class);
    public static final String DEPENDS_ON_TABLES = "dependsOnTables";
    private final CachingHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final boolean isUsingSystemSecurity;
    private final boolean deleteSchemaLocationsFallback;
    private final Map<SchemaTableName, TableMetadata> tableMetadataCache = new ConcurrentHashMap<SchemaTableName, TableMetadata>();

    public TrinoHiveCatalog(CatalogName catalogName, CachingHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, String trinoVersion, boolean useUniqueTableLocation, boolean isUsingSystemSecurity, boolean deleteSchemaLocationsFallback) {
        super(catalogName, typeManager, tableOperationsProvider, trinoVersion, useUniqueTableLocation);
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.isUsingSystemSecurity = isUsingSystemSecurity;
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
    }

    public CachingHiveMetastore getMetastore() {
        return this.metastore;
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        return this.metastore.getAllDatabases().stream().filter(schemaName -> !HiveUtil.isHiveSystemSchema((String)schemaName)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        Optional db = this.metastore.getDatabase(namespace);
        if (db.isPresent()) {
            return HiveSchemaProperties.fromDatabase((Database)((Database)db.get()));
        }
        throw new SchemaNotFoundException(namespace);
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        Optional database = this.metastore.getDatabase(namespace);
        if (database.isPresent()) {
            return database.flatMap(db -> db.getOwnerName().map(ownerName -> new TrinoPrincipal((PrincipalType)db.getOwnerType().orElseThrow(), ownerName)));
        }
        throw new SchemaNotFoundException(namespace);
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        Optional<String> location = IcebergSchemaProperties.getSchemaLocation(properties).map(uri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(uri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + uri, (Throwable)e);
            }
            return uri;
        });
        Database database = Database.builder().setDatabaseName(namespace).setLocation(location).setOwnerType(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(owner.getType())).setOwnerName(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(owner.getName())).build();
        this.metastore.createDatabase(database);
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        if (!this.listTables(session, Optional.of(namespace)).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + namespace);
        }
        Optional<Path> location = ((Database)this.metastore.getDatabase(namespace).orElseThrow(() -> new SchemaNotFoundException(namespace))).getLocation().map(Path::new);
        boolean deleteData = location.map(path -> {
            Boolean bl;
            block8: {
                HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
                FileSystem fs = this.hdfsEnvironment.getFileSystem(context, path);
                try {
                    bl = !fs.listLocatedStatus(path).hasNext();
                    if (fs == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                        return this.deleteSchemaLocationsFallback;
                    }
                }
                fs.close();
            }
            return bl;
        }).orElse(this.deleteSchemaLocationsFallback);
        this.metastore.dropDatabase(namespace, deleteData);
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(source, target);
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        this.metastore.setDatabaseOwner(namespace, HivePrincipal.from((TrinoPrincipal)principal));
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, String location, Map<String, String> properties) {
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, location, properties, this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser()));
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> namespace) {
        ImmutableSet.Builder tablesListBuilder = ImmutableSet.builder();
        for (String schemaName : this.listNamespaces(session, namespace)) {
            this.metastore.getAllTables(schemaName).forEach(tableName -> tablesListBuilder.add((Object)new SchemaTableName(schemaName, tableName)));
        }
        return tablesListBuilder.build().asList();
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = (BaseTable)this.loadTable(session, schemaTableName);
        TableMetadata metadata = table.operations().current();
        IcebergUtil.validateTableCanBeDropped((org.apache.iceberg.Table)table);
        Table metastoreTable = (Table)this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        this.metastore.dropTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), false);
        CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)metadata);
        this.deleteTableDirectory(session, schemaTableName, this.hdfsEnvironment, new Path(metastoreTable.getStorage().getLocation()));
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        this.metastore.renameTable(from.getSchemaName(), from.getTableName(), to.getSchemaName(), to.getTableName());
    }

    @Override
    public org.apache.iceberg.Table loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        TableMetadata metadata = this.tableMetadataCache.computeIfAbsent(schemaTableName, ignore -> ((BaseTable)IcebergUtil.loadIcebergTable(this, this.tableOperationsProvider, session, schemaTableName)).operations().current());
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, schemaTableName, metadata);
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        this.metastore.commentTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), comment);
        super.updateTableComment(session, schemaTableName, comment);
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        Table view = (Table)this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition definition = this.getView(viewName, view.getViewOriginalText(), view.getTableType(), view.getParameters(), view.getOwner()).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), comment, definition.getOwner(), definition.isRunAsInvoker());
        Table.Builder viewBuilder = Table.builder((Table)view).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData((ConnectorViewDefinition)newDefinition)));
        PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), viewBuilder.build(), principalPrivileges);
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        this.metastore.commentColumn(schemaTableName.getSchemaName(), schemaTableName.getTableName(), columnIdentity.getName(), comment);
        super.updateColumnComment(session, schemaTableName, columnIdentity, comment);
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        Database database = (Database)this.metastore.getDatabase(schemaTableName.getSchemaName()).orElseThrow(() -> new SchemaNotFoundException(schemaTableName.getSchemaName()));
        String tableNameForLocation = this.createNewTableName(schemaTableName.getTableName());
        return HiveWriteUtils.getTableDefaultLocation((Database)database, (HdfsEnvironment.HdfsContext)new HdfsEnvironment.HdfsContext(session), (HdfsEnvironment)this.hdfsEnvironment, (String)schemaTableName.getSchemaName(), (String)tableNameForLocation).toString();
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting an owner on a table");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        if (this.isUsingSystemSecurity) {
            definition = definition.withoutOwner();
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaViewName.getSchemaName()).setTableName(schemaViewName.getTableName()).setOwner(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser())).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List)ImmutableList.of((Object)new Column("dummy", HiveType.HIVE_STRING, Optional.empty()))).setPartitionColumns((List)ImmutableList.of()).setParameters(this.createViewProperties(session)).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData((ConnectorViewDefinition)definition))).setViewExpandedText(Optional.of("/* Presto View */"));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        Optional existing = this.metastore.getTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isPrestoView((Table)((Table)existing.get()))) {
                throw new ViewAlreadyExistsException(schemaViewName);
            }
            this.metastore.replaceTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(table, principalPrivileges);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        this.setTablePrincipal(session, schemaViewName, principal);
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        if (this.getView(session, schemaViewName).isEmpty()) {
            throw new ViewNotFoundException(schemaViewName);
        }
        try {
            this.metastore.dropTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), true);
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listNamespaces(session, namespace).stream().flatMap(this::listViews).collect(ImmutableList.toImmutableList());
    }

    private Stream<SchemaTableName> listViews(String schema) {
        return this.metastore.getTablesWithParameter(schema, "comment", "Presto View").stream().map(table -> new SchemaTableName(schema, table));
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        if (HiveUtil.isHiveSystemSchema((String)viewName.getSchemaName())) {
            return Optional.empty();
        }
        return this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).flatMap(view -> this.getView(viewName, view.getViewOriginalText(), view.getTableType(), view.getParameters(), view.getOwner()));
    }

    @Override
    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listNamespaces(session, namespace).stream().flatMap(schema -> this.metastore.getTablesWithParameter(schema, "comment", "Presto Materialized View").stream().map(table -> new SchemaTableName(schema, table))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        PrincipalPrivileges principalPrivileges;
        Optional existing = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!ViewReaderUtil.isTrinoMaterializedView((String)((Table)existing.get()).getTableType(), (Map)((Table)existing.get()).getParameters())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Existing table is not a Materialized View: " + viewName);
            }
            if (!replace) {
                if (ignoreExisting) {
                    return;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + viewName);
            }
        }
        SchemaTableName storageTable = this.createMaterializedViewStorageTable(session, viewName, definition);
        Map<String, String> viewProperties = this.createMaterializedViewProperties(session, storageTable);
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser())).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List)ImmutableList.of()).setParameters(viewProperties).withStorage(storage -> storage.setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT)).withStorage(storage -> storage.setLocation("")).setViewOriginalText(Optional.of(IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)))).setViewExpandedText(Optional.of("/* Presto Materialized View */"));
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges2 = principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        if (existing.isPresent()) {
            String oldStorageTable = (String)((Table)existing.get()).getParameters().get("storage_table");
            if (oldStorageTable != null) {
                String storageSchema = Optional.ofNullable((String)((Table)existing.get()).getParameters().get("storage_schema")).orElse(viewName.getSchemaName());
                this.metastore.dropTable(storageSchema, oldStorageTable, true);
            }
            this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        this.metastore.createTable(table, principalPrivileges);
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        Table view = (Table)this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).orElseThrow(() -> new MaterializedViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoMaterializedView((String)view.getTableType(), (Map)view.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + viewName);
        }
        String storageTableName = (String)view.getParameters().get("storage_table");
        if (storageTableName != null) {
            String storageSchema = Optional.ofNullable((String)view.getParameters().get("storage_schema")).orElse(viewName.getSchemaName());
            try {
                this.metastore.dropTable(storageSchema, storageTableName, true);
            }
            catch (TrinoException e) {
                log.warn((Throwable)e, "Failed to drop storage table '%s.%s' for materialized view '%s'", new Object[]{storageSchema, storageTableName, viewName});
            }
        }
        this.metastore.dropTable(viewName.getSchemaName(), viewName.getTableName(), true);
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        org.apache.iceberg.Table icebergTable;
        Optional tableOptional = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (tableOptional.isEmpty()) {
            return Optional.empty();
        }
        Table table = (Table)tableOptional.get();
        if (!ViewReaderUtil.isTrinoMaterializedView((String)table.getTableType(), (Map)table.getParameters())) {
            return Optional.empty();
        }
        Table materializedView = (Table)tableOptional.get();
        String storageTable = (String)materializedView.getParameters().get("storage_table");
        Preconditions.checkState((storageTable != null ? 1 : 0) != 0, (Object)("Storage table missing in definition of materialized view " + viewName));
        String storageSchema = Optional.ofNullable((String)materializedView.getParameters().get("storage_schema")).orElse(viewName.getSchemaName());
        SchemaTableName storageTableName = new SchemaTableName(storageSchema, storageTable);
        try {
            icebergTable = this.loadTable(session, storageTableName);
        }
        catch (RuntimeException e) {
            this.metastore.invalidateTable(viewName.getSchemaName(), viewName.getTableName());
            this.metastore.invalidateTable(storageSchema, storageTable);
            throw new AbstractTrinoCatalog.MaterializedViewMayBeBeingRemovedException(e);
        }
        return Optional.of(this.getMaterializedViewDefinition(icebergTable, table.getOwner(), (String)materializedView.getViewOriginalText().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view original text: " + viewName)), storageTableName));
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent()) {
            if (HiveUtil.isHiveSystemSchema((String)namespace.get())) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<String> targetCatalogName = IcebergSessionProperties.getHiveCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional table = this.metastore.getTable(tableNameBase.getSchemaName(), tableNameBase.getTableName());
        if (table.isEmpty() || ViewReaderUtil.isHiveOrPrestoView((String)((Table)table.get()).getTableType())) {
            return Optional.empty();
        }
        if (!IcebergUtil.isIcebergTable((Table)table.get())) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, tableName));
        }
        return Optional.empty();
    }
}

