/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.openjdk.jol.info.ClassLayout;

public final class DeleteFile {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(DeleteFile.class).instanceSize();
    private final FileContent content;
    private final String path;
    private final FileFormat format;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final List<Integer> equalityFieldIds;

    public static DeleteFile fromIceberg(org.apache.iceberg.DeleteFile deleteFile) {
        return new DeleteFile(deleteFile.content(), deleteFile.path().toString(), deleteFile.format(), deleteFile.recordCount(), deleteFile.fileSizeInBytes(), Optional.ofNullable(deleteFile.equalityFieldIds()).orElseGet(ImmutableList::of));
    }

    @JsonCreator
    public DeleteFile(FileContent content, String path, FileFormat format, long recordCount, long fileSizeInBytes, List<Integer> equalityFieldIds) {
        this.content = Objects.requireNonNull(content, "content is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.format = Objects.requireNonNull(format, "format is null");
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.equalityFieldIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(equalityFieldIds, "equalityFieldIds is null"));
    }

    @JsonProperty
    public FileContent content() {
        return this.content;
    }

    @JsonProperty
    public CharSequence path() {
        return this.path;
    }

    @JsonProperty
    public FileFormat format() {
        return this.format;
    }

    @JsonProperty
    public long recordCount() {
        return this.recordCount;
    }

    @JsonProperty
    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    @JsonProperty
    public List<Integer> equalityFieldIds() {
        return this.equalityFieldIds;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.equalityFieldIds, ignored -> 4L);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).add("records", this.recordCount).toString();
    }
}

