/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.delete.DeleteFilter;
import io.trino.plugin.iceberg.delete.LazyTrinoRow;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.plugin.iceberg.delete.TrinoRow;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.StructProjection;

public final class EqualityDeleteFilter
implements DeleteFilter {
    private final Schema schema;
    private final StructLikeSet deleteSet;

    private EqualityDeleteFilter(Schema schema, StructLikeSet deleteSet) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.deleteSet = Objects.requireNonNull(deleteSet, "deleteSet is null");
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public RowPredicate createPredicate(List<IcebergColumnHandle> columns) {
        Type[] types = (Type[])columns.stream().map(IcebergColumnHandle::getType).toArray(Type[]::new);
        Schema fileSchema = IcebergUtil.schemaFromHandles(columns);
        StructProjection projection = StructProjection.create((Schema)fileSchema, (Schema)this.schema);
        return (page, position) -> {
            LazyTrinoRow row = new LazyTrinoRow(types, page, position);
            return !this.deleteSet.contains((Object)projection.wrap((StructLike)row));
        };
    }

    public static DeleteFilter readEqualityDeletes(ConnectorPageSource pageSource, List<IcebergColumnHandle> columns, Schema tableSchema) {
        Set ids = (Set)columns.stream().map(IcebergColumnHandle::getId).collect(ImmutableSet.toImmutableSet());
        Type[] types = (Type[])columns.stream().map(IcebergColumnHandle::getType).toArray(Type[]::new);
        Schema deleteSchema = TypeUtil.select((Schema)tableSchema, (Set)ids);
        StructLikeSet deleteSet = StructLikeSet.create((Types.StructType)deleteSchema.asStruct());
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            for (int position = 0; position < page.getPositionCount(); ++position) {
                deleteSet.add((StructLike)new TrinoRow(types, page, position));
            }
        }
        return new EqualityDeleteFilter(deleteSchema, deleteSet);
    }
}

