/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.common.metrics.CachingFileSystemMetrics;
import com.qubole.rubix.common.metrics.CustomMetricsReporterProvider;
import com.qubole.rubix.core.DirectReadRequestChain;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.DataTransferClientFactory;
import com.qubole.rubix.spi.DataTransferClientHelper;
import com.qubole.rubix.spi.DataTransferHeader;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class NonLocalReadRequestChain
extends ReadRequestChain {
    long fileSize;
    String filePath;
    long lastModified;
    String remoteNodeName;
    Configuration conf;
    long readFromNonLocalCache;
    long directRead;
    long directReadRequests;
    FileSystem remoteFileSystem;
    int clusterType;
    public boolean strictMode;
    FileSystem.Statistics statistics;
    DirectReadRequestChain directReadChain;
    private static final Log log = LogFactory.getLog(NonLocalReadRequestChain.class);
    private BookKeeperFactory bookKeeperFactory = new BookKeeperFactory();

    public NonLocalReadRequestChain(String remoteLocation, long fileSize, long lastModified, Configuration conf, FileSystem remoteFileSystem, String remotePath, int clusterType, boolean strictMode, FileSystem.Statistics statistics) {
        super(0);
        this.remoteNodeName = remoteLocation;
        this.remoteFileSystem = remoteFileSystem;
        this.lastModified = lastModified;
        this.filePath = remotePath;
        this.fileSize = fileSize;
        this.conf = conf;
        this.clusterType = clusterType;
        this.strictMode = strictMode;
        this.statistics = statistics;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setNonLocalRRCDataRead(this.readFromNonLocalCache).setNonLocalRRCRequests(this.directReadRequests == 0L ? this.requests : this.requests - this.directReadRequests).setDirectRRCDataRead(this.directRead).setDirectRRCRequests(this.directReadRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        log.debug((Object)String.format("Read Request threadName: %s, Non Local read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        if (this.readRequests.size() == 0) {
            return 0L;
        }
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        int dataReadInPreviousCycle = 0;
        for (ReadRequest readRequest : this.readRequests) {
            Serializable serializable;
            this.readFromNonLocalCache += (long)dataReadInPreviousCycle;
            if (this.cancelled) {
                this.propagateCancel(this.getClass().getName());
            }
            try {
                DataTransferClientFactory.DataTransferClient dataTransferClient = DataTransferClientFactory.getClient(this.remoteNodeName, this.conf);
                serializable = null;
                try {
                    int nread = 0;
                    InputStream inStream = dataTransferClient.getSocketChannel().socket().getInputStream();
                    ReadableByteChannel wrappedChannel = Channels.newChannel(inStream);
                    ByteBuffer buf = DataTransferClientHelper.writeHeaders(this.conf, new DataTransferHeader(readRequest.getActualReadStart(), readRequest.getActualReadLengthIntUnsafe(), this.fileSize, this.lastModified, this.clusterType, this.filePath));
                    try {
                        dataTransferClient.getSocketChannel().write(buf);
                    }
                    catch (IOException e) {
                        dataTransferClient.getSocketChannel().close();
                        throw e;
                    }
                    int bytesread = 0;
                    ByteBuffer dst = ByteBuffer.wrap(readRequest.destBuffer, readRequest.getDestBufferOffset(), readRequest.destBuffer.length - readRequest.getDestBufferOffset());
                    while (bytesread != readRequest.getActualReadLengthIntUnsafe()) {
                        try {
                            nread = wrappedChannel.read(dst);
                        }
                        catch (IOException e) {
                            log.warn((Object)("Error in reading..closing socket channel: " + dataTransferClient.getSocketChannel()), (Throwable)e);
                            dataTransferClient.getSocketChannel().close();
                            throw e;
                        }
                        if (nread == -1) {
                            log.warn((Object)"Error reading from Local Transfer Server");
                            dataTransferClient.getSocketChannel().close();
                            throw new IOException("Error reading from Local Transfer Server");
                        }
                        dst.position((bytesread += nread) + readRequest.getDestBufferOffset());
                    }
                    dataReadInPreviousCycle = bytesread;
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (dataTransferClient == null) continue;
                    if (serializable != null) {
                        try {
                            dataTransferClient.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                        continue;
                    }
                    dataTransferClient.close();
                }
            }
            catch (Exception e) {
                if (this.strictMode) {
                    log.warn((Object)("Error reading data from node : " + this.remoteNodeName), (Throwable)e);
                    throw Throwables.propagate(e);
                }
                log.warn((Object)("Error in reading from node: " + this.remoteNodeName + " Using direct reads"), (Throwable)e);
                CustomMetricsReporterProvider.getCustomMetricsReporter().addMetric(CachingFileSystemMetrics.NON_LOCAL_FALLBACK_TO_DIRECT_READ);
                serializable = Long.valueOf(this.directReadRequest(this.readRequests.indexOf(readRequest)));
                return serializable;
            }
            finally {
                if (this.statistics == null) continue;
                this.statistics.incrementBytesRead(this.readFromNonLocalCache);
            }
        }
        this.readFromNonLocalCache += (long)dataReadInPreviousCycle;
        log.debug((Object)String.format("Read %d bytes internally from node %s", this.readFromNonLocalCache, this.remoteNodeName));
        return this.readFromNonLocalCache;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.directReadChain != null) {
            this.directReadChain.cancel();
        }
    }

    private long directReadRequest(int index) throws Exception {
        try (FSDataInputStream inputStream = this.remoteFileSystem.open(new Path(this.filePath));){
            this.directReadChain = new DirectReadRequestChain(inputStream);
            for (ReadRequest readRequest : this.readRequests.subList(index, this.readRequests.size())) {
                this.directReadChain.addReadRequest(readRequest);
                ++this.directReadRequests;
            }
            this.directReadChain.lock();
            this.directRead = this.directReadChain.call();
            this.directReadChain = null;
        }
        return this.readFromNonLocalCache + this.directRead;
    }

    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        if (CacheConfig.isDummyModeEnabled(conf)) {
            try (RetryingPooledBookkeeperClient bookKeeperClient = this.bookKeeperFactory.createBookKeeperClient(this.remoteNodeName, conf);){
                for (ReadRequest readRequest : this.readRequests) {
                    long startBlock = this.toBlock(readRequest.getBackendReadStart());
                    long endBlock = this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L;
                    CacheStatusRequest request = new CacheStatusRequest(remotePath, fileSize, lastModified, startBlock, endBlock).setClusterType(this.clusterType);
                    bookKeeperClient.getCacheStatus(request);
                    bookKeeperClient.setAllCached(remotePath, fileSize, lastModified, startBlock, endBlock, 1);
                }
            }
            catch (Exception e) {
                if (this.strictMode) {
                    throw Throwables.propagate(e);
                }
                log.error((Object)"Dummy Mode: Could not update Cache Status for Non-Local Read Request ", (Throwable)e);
            }
        }
    }

    private long toBlock(long pos) {
        long blockSize = CacheConfig.getBlockSize(this.conf);
        return pos / blockSize;
    }
}

