/*
 * Decompiled with CFR 0.152.
 */
package org.ishugaliy.allgood.consistent.hash.node;

import java.util.Objects;
import java.util.StringJoiner;
import org.ishugaliy.allgood.consistent.hash.annotation.Generated;
import org.ishugaliy.allgood.consistent.hash.node.Node;

public class ServerNode
implements Node {
    private final String dc;
    private final String ip;
    private final int port;

    public ServerNode(String ip, int port) {
        this("", ip, port);
    }

    public ServerNode(String dc, String ip, int port) {
        this.dc = dc != null ? dc : "";
        this.ip = ip != null ? ip : "";
        this.port = port;
    }

    public String getDc() {
        return this.dc;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String getKey() {
        return String.format("%s:%s:%s", this.dc, this.ip, this.port);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerNode)) {
            return false;
        }
        ServerNode that = (ServerNode)o;
        return this.port == that.port && Objects.equals(this.dc, that.dc) && Objects.equals(this.ip, that.ip);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.dc, this.ip, this.port);
    }

    @Generated
    public String toString() {
        return new StringJoiner(", ", ServerNode.class.getSimpleName() + "[", "]").add("dc='" + this.dc + "'").add("ip='" + this.ip + "'").add("port=" + this.port).toString();
    }
}

